/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance;

import com.google.common.collect.ImmutableMap;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.serialization.json.JsonReader;
import voldemort.serialization.json.JsonWriter;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebalancePartitionsInfo {
    private final int stealerId;
    private final int donorId;
    private final List<Integer> partitionList;
    private final List<Integer> deletePartitionsList;
    private List<String> unbalancedStoreList;
    private int attempt;
    private List<Integer> stealMasterPartitions;

    public RebalancePartitionsInfo(int stealerNodeId, int donorId, List<Integer> partitionList, List<Integer> deletePartitionsList, List<String> unbalancedStoreList, int attempt) {
        this.stealerId = stealerNodeId;
        this.donorId = donorId;
        this.partitionList = partitionList;
        this.attempt = attempt;
        this.deletePartitionsList = deletePartitionsList;
        this.unbalancedStoreList = unbalancedStoreList;
    }

    public RebalancePartitionsInfo(int stealerNodeId, int donorId, List<Integer> partitionList, List<Integer> deletePartitionsList, List<Integer> stealMasterPartitions, List<String> unbalancedStoreList, int attempt) {
        this.stealerId = stealerNodeId;
        this.donorId = donorId;
        this.partitionList = partitionList;
        this.attempt = attempt;
        this.deletePartitionsList = deletePartitionsList;
        this.unbalancedStoreList = unbalancedStoreList;
        this.stealMasterPartitions = stealMasterPartitions;
    }

    public static RebalancePartitionsInfo create(String line) {
        try {
            JsonReader reader = new JsonReader(new StringReader(line));
            Map<String, ?> map = reader.readObject();
            return RebalancePartitionsInfo.create(map);
        }
        catch (Exception e) {
            throw new VoldemortException("Failed to create RebalanceStealInfo from String:" + line, e);
        }
    }

    public static RebalancePartitionsInfo create(Map<?, ?> map) {
        int stealerId = (Integer)map.get("stealerId");
        int donorId = (Integer)map.get("donorId");
        List partitionList = (List)Utils.uncheckedCast(map.get("partitionList"));
        int attempt = (Integer)map.get("attempt");
        List deletePartitionsList = (List)Utils.uncheckedCast(map.get("deletePartitionsList"));
        List unbalancedStoreList = (List)Utils.uncheckedCast(map.get("unbalancedStoreList"));
        return new RebalancePartitionsInfo(stealerId, donorId, partitionList, deletePartitionsList, unbalancedStoreList, attempt);
    }

    public List<Integer> getDeletePartitionsList() {
        return this.deletePartitionsList;
    }

    public void setAttempt(int attempt) {
        this.attempt = attempt;
    }

    public int getDonorId() {
        return this.donorId;
    }

    public List<Integer> getPartitionList() {
        return this.partitionList;
    }

    public int getAttempt() {
        return this.attempt;
    }

    public int getStealerId() {
        return this.stealerId;
    }

    public List<String> getUnbalancedStoreList() {
        return this.unbalancedStoreList;
    }

    public void setUnbalancedStoreList(List<String> storeList) {
        this.unbalancedStoreList = storeList;
    }

    public List<Integer> getStealMasterPartitions() {
        return this.stealMasterPartitions;
    }

    public void setStealMasterPartitions(List<Integer> stealMasterPartitions) {
        this.stealMasterPartitions = stealMasterPartitions;
    }

    public String toString() {
        return "RebalancingStealInfo(" + this.getStealerId() + " <--- " + this.getDonorId() + " partitions:" + this.getPartitionList() + " stores:" + this.getUnbalancedStoreList() + ")";
    }

    public String toJsonString() {
        ImmutableMap<String, Object> map = this.asMap();
        StringWriter writer = new StringWriter();
        new JsonWriter(writer).write(map);
        writer.flush();
        return writer.toString();
    }

    public ImmutableMap<String, Object> asMap() {
        ImmutableMap.Builder<String, Integer> builder = new ImmutableMap.Builder<String, Integer>();
        return builder.put("stealerId", this.stealerId).put("donorId", this.donorId).put("partitionList", (Integer)((Object)this.partitionList)).put("unbalancedStoreList", this.unbalancedStoreList).put("deletePartitionsList", this.deletePartitionsList).put("attempt", (List<Integer>)this.attempt).build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RebalancePartitionsInfo that = (RebalancePartitionsInfo)o;
        if (this.attempt != that.attempt) {
            return false;
        }
        if (this.donorId != that.donorId) {
            return false;
        }
        if (this.stealerId != that.stealerId) {
            return false;
        }
        if (!((Object)this.deletePartitionsList).equals(that.deletePartitionsList)) {
            return false;
        }
        if (!((Object)this.partitionList).equals(that.partitionList)) {
            return false;
        }
        if (this.stealMasterPartitions != null ? !((Object)this.stealMasterPartitions).equals(that.stealMasterPartitions) : that.stealMasterPartitions != null) {
            return false;
        }
        return !(this.unbalancedStoreList != null ? !((Object)this.unbalancedStoreList).equals(that.unbalancedStoreList) : that.unbalancedStoreList != null);
    }

    public int hashCode() {
        int result = this.stealerId;
        result = 31 * result + this.donorId;
        result = 31 * result + ((Object)this.partitionList).hashCode();
        result = 31 * result + ((Object)this.deletePartitionsList).hashCode();
        result = 31 * result + (this.unbalancedStoreList != null ? ((Object)this.unbalancedStoreList).hashCode() : 0);
        result = 31 * result + this.attempt;
        result = 31 * result + (this.stealMasterPartitions != null ? ((Object)this.stealMasterPartitions).hashCode() : 0);
        return result;
    }
}

