/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.routing.RoutingStrategyFactory;
import voldemort.store.StoreDefinition;
import voldemort.utils.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebalanceClusterTool {
    private final Cluster cluster;
    private final StoreDefinition storeDefinition;
    private final ListMultimap<Integer, Integer> masterToReplicas;

    public RebalanceClusterTool(Cluster cluster, StoreDefinition storeDefinition) {
        RoutingStrategy routingStrategy = new RoutingStrategyFactory().updateRoutingStrategy(storeDefinition, cluster);
        this.cluster = cluster;
        this.storeDefinition = storeDefinition;
        this.masterToReplicas = this.createMasterToReplicas(cluster, routingStrategy);
    }

    public Multimap<Integer, Integer> getMasterToReplicas() {
        return this.masterToReplicas;
    }

    private ListMultimap<Integer, Integer> createMasterToReplicas(Cluster cluster, RoutingStrategy routingStrategy) {
        ArrayListMultimap<Integer, Integer> lmm = ArrayListMultimap.create();
        for (int i = 0; i < cluster.getNumberOfPartitions(); ++i) {
            for (int replica : routingStrategy.getReplicatingPartitionList(i)) {
                if (replica == i) continue;
                lmm.put(i, replica);
            }
        }
        return lmm;
    }

    public Cluster insertNode(Node template, int minPartitions, int desiredPartitions, int maxRemap) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        nodes.addAll(this.cluster.getNodes());
        nodes.add(template);
        Cluster templateCluster = new Cluster(this.cluster.getName(), nodes);
        Cluster targetCluster = null;
        boolean found = false;
        for (int i = desiredPartitions; i >= minPartitions && !found; --i) {
            Cluster candidateCluster = this.createTargetCluster(templateCluster, i, maxRemap, ImmutableSet.<Integer>of(), this.masterToReplicas.keySet());
            if (candidateCluster.getNodeById(template.getId()).getNumberOfPartitions() <= template.getNumberOfPartitions()) continue;
            targetCluster = candidateCluster;
            found = this.isGoodEnough(candidateCluster, i);
        }
        if (!found) {
            System.err.println("================================================================================");
            System.err.println("Warning: target cluster doesn't meet all constraints, please verify it manually!");
            System.err.println("================================================================================");
        }
        return targetCluster;
    }

    private Cluster createTargetCluster(Cluster candidate, int minPartitions, int maxRemap, Set<Integer> partitionsMoved, Set<Integer> allPartitions) {
        Sets.SetView<Integer> partitionsNotMoved = Sets.difference(allPartitions, partitionsMoved);
        if (partitionsNotMoved.isEmpty()) {
            return candidate;
        }
        if (this.isGoodEnough(candidate, minPartitions)) {
            return candidate;
        }
        for (int i = candidate.getNumberOfPartitions() - 1; i >= 0; --i) {
            Cluster attempt;
            if (partitionsMoved.contains(i) || (attempt = this.moveToLastNode(candidate, i, maxRemap)) == null) continue;
            return this.createTargetCluster(attempt, minPartitions, maxRemap, Sets.union(partitionsMoved, ImmutableSet.of(Integer.valueOf(i))), allPartitions);
        }
        return candidate;
    }

    private Cluster moveToLastNode(Cluster candidate, int partition, int maxRemap) {
        Node lastNode = candidate.getNodeById(candidate.getNumberOfNodes() - 1);
        if (lastNode.getPartitionIds().contains(partition)) {
            return null;
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        for (int i = 0; i < candidate.getNumberOfNodes() - 1; ++i) {
            Node currNode = candidate.getNodeById(i);
            if (currNode.getPartitionIds().contains(partition)) {
                ArrayList<Integer> currNodePartitions = new ArrayList<Integer>();
                for (int oldPartition : currNode.getPartitionIds()) {
                    if (oldPartition == partition) continue;
                    currNodePartitions.add(oldPartition);
                }
                nodes.add(new Node(i, currNode.getHost(), currNode.getHttpPort(), currNode.getSocketPort(), currNode.getAdminPort(), currNodePartitions));
                continue;
            }
            nodes.add(currNode);
        }
        ArrayList<Integer> lastNodePartitions = new ArrayList<Integer>();
        lastNodePartitions.addAll(lastNode.getPartitionIds());
        lastNodePartitions.add(partition);
        Collections.sort(lastNodePartitions);
        nodes.add(new Node(lastNode.getId(), lastNode.getHost(), lastNode.getHttpPort(), lastNode.getSocketPort(), lastNode.getAdminPort(), lastNodePartitions));
        Cluster attempt = new Cluster(candidate.getName(), nodes);
        if (this.hasMultipleCopies(attempt) || this.getRemappedReplicaCount(attempt) > maxRemap) {
            return null;
        }
        return attempt;
    }

    public boolean isGoodEnough(Cluster candidate, int minPartitions) {
        Node lastNode = candidate.getNodeById(candidate.getNumberOfNodes() - 1);
        if (lastNode.getNumberOfPartitions() != minPartitions) {
            return false;
        }
        for (int i = 0; i < candidate.getNumberOfNodes() - 1; ++i) {
            Node curr = candidate.getNodeById(i);
            if (curr.getNumberOfPartitions() >= minPartitions) continue;
            return false;
        }
        return true;
    }

    public Multimap<Node, Integer> getMultipleCopies(Cluster newCluster) {
        LinkedHashMultimap<Node, Integer> copies = LinkedHashMultimap.create();
        for (Node n : newCluster.getNodes()) {
            List<Integer> partitions = n.getPartitionIds();
            for (int partition : partitions) {
                for (int replica : this.masterToReplicas.get(partition)) {
                    if (!partitions.contains(replica)) continue;
                    if (!copies.get(n).contains(partition)) {
                        copies.put(n, partition);
                    }
                    copies.put(n, replica);
                }
            }
        }
        return copies;
    }

    public Multimap<Integer, Pair<Integer, Integer>> getRemappedReplicas(Cluster newCluster) {
        RoutingStrategy routingStrategy = new RoutingStrategyFactory().updateRoutingStrategy(this.storeDefinition, newCluster);
        ListMultimap<Integer, Integer> newMasterToReplicas = this.createMasterToReplicas(newCluster, routingStrategy);
        ArrayListMultimap<Integer, Pair<Integer, Integer>> remappedReplicas = ArrayListMultimap.create();
        Iterator i$ = this.masterToReplicas.keySet().iterator();
        while (i$.hasNext()) {
            int partition = (Integer)i$.next();
            List<Integer> oldReplicas = this.masterToReplicas.get(partition);
            List<Integer> newReplicas = newMasterToReplicas.get(partition);
            if (oldReplicas.size() != newReplicas.size()) {
                throw new IllegalStateException("replica count differs for partition " + partition);
            }
            for (int i = 0; i < oldReplicas.size(); ++i) {
                int oldReplica = oldReplicas.get(i);
                if (newReplicas.contains(oldReplica)) continue;
                Pair<Integer, Integer> pair = new Pair<Integer, Integer>(oldReplica, newReplicas.get(i));
                remappedReplicas.put(partition, pair);
            }
        }
        return remappedReplicas;
    }

    public boolean hasMultipleCopies(Cluster newCluster) {
        return this.getMultipleCopies(newCluster).size() > 0;
    }

    public int getRemappedReplicaCount(Cluster newCluster) {
        return this.getRemappedReplicas(newCluster).entries().size();
    }
}

