/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import voldemort.VoldemortException;
import voldemort.client.rebalance.RebalanceClusterTool;
import voldemort.client.rebalance.RebalanceNodePlan;
import voldemort.client.rebalance.RebalancePartitionsInfo;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.store.StoreDefinition;
import voldemort.utils.Pair;
import voldemort.utils.RebalanceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebalanceClusterPlan {
    private final Queue<RebalanceNodePlan> rebalanceTaskQueue = new ConcurrentLinkedQueue<RebalanceNodePlan>();
    private final List<StoreDefinition> storeDefList;

    public RebalanceClusterPlan(Cluster currentCluster, Cluster targetCluster, List<StoreDefinition> storeDefList, boolean deleteDonorPartition) {
        this.storeDefList = storeDefList;
        if (currentCluster.getNumberOfPartitions() != targetCluster.getNumberOfPartitions()) {
            throw new VoldemortException("Total number of partitions should not change !!");
        }
        for (Node node : targetCluster.getNodes()) {
            List<RebalancePartitionsInfo> rebalanceNodeList = this.getRebalanceNodeTask(currentCluster, targetCluster, RebalanceUtils.getStoreNames(storeDefList), node.getId(), deleteDonorPartition);
            if (rebalanceNodeList.size() <= 0) continue;
            this.rebalanceTaskQueue.offer(new RebalanceNodePlan(node.getId(), rebalanceNodeList));
        }
    }

    public Queue<RebalanceNodePlan> getRebalancingTaskQueue() {
        return this.rebalanceTaskQueue;
    }

    private List<RebalancePartitionsInfo> getRebalanceNodeTask(Cluster currentCluster, Cluster targetCluster, List<String> storeList, int stealNodeId, boolean deleteDonorPartition) {
        Map<Integer, Integer> currentPartitionsToNodeMap = RebalanceUtils.getCurrentPartitionMapping(currentCluster);
        List<Integer> stealList = this.getStealList(currentCluster, targetCluster, stealNodeId);
        Map<Integer, List<Integer>> masterPartitionsMap = this.getStealMasterPartitions(stealList, currentPartitionsToNodeMap);
        Map<Integer, List<Integer>> replicationPartitionsMap = this.getReplicationChanges(currentCluster, targetCluster, stealNodeId, currentPartitionsToNodeMap);
        ArrayList<RebalancePartitionsInfo> stealInfoList = new ArrayList<RebalancePartitionsInfo>();
        for (Node donorNode : currentCluster.getNodes()) {
            HashSet stealPartitions = new HashSet();
            HashSet deletePartitions = new HashSet();
            HashSet stealMasterPartitions = new HashSet();
            if (masterPartitionsMap.containsKey(donorNode.getId())) {
                stealPartitions.addAll(masterPartitionsMap.get(donorNode.getId()));
                stealMasterPartitions.addAll(masterPartitionsMap.get(donorNode.getId()));
                if (deleteDonorPartition) {
                    deletePartitions.addAll(masterPartitionsMap.get(donorNode.getId()));
                }
            }
            if (replicationPartitionsMap.containsKey(donorNode.getId())) {
                stealPartitions.addAll(replicationPartitionsMap.get(donorNode.getId()));
            }
            if (stealPartitions.size() <= 0) continue;
            stealInfoList.add(new RebalancePartitionsInfo(stealNodeId, donorNode.getId(), new ArrayList<Integer>(stealPartitions), new ArrayList<Integer>(deletePartitions), new ArrayList<Integer>(stealMasterPartitions), storeList, 0));
        }
        return stealInfoList;
    }

    private List<Integer> getStealList(Cluster currentCluster, Cluster targetCluster, int stealNodeId) {
        ArrayList<Integer> targetList = new ArrayList<Integer>(targetCluster.getNodeById(stealNodeId).getPartitionIds());
        List<Object> currentList = new ArrayList();
        if (RebalanceUtils.containsNode(currentCluster, stealNodeId)) {
            currentList = currentCluster.getNodeById(stealNodeId).getPartitionIds();
        }
        targetList.removeAll(currentList);
        return targetList;
    }

    private Map<Integer, List<Integer>> getReplicationChanges(Cluster currentCluster, Cluster targetCluster, int stealNodeId, Map<Integer, Integer> currentPartitionsToNodeMap) {
        HashMap<Integer, List<Integer>> replicationMapping = new HashMap<Integer, List<Integer>>();
        List<Integer> targetList = targetCluster.getNodeById(stealNodeId).getPartitionIds();
        RebalanceClusterTool clusterTool = new RebalanceClusterTool(currentCluster, RebalanceUtils.getMaxReplicationStore(this.storeDefList));
        Multimap<Integer, Pair<Integer, Integer>> replicationChanges = clusterTool.getRemappedReplicas(targetCluster);
        for (Map.Entry<Integer, Pair<Integer, Integer>> entry : replicationChanges.entries()) {
            int donorNode;
            int newReplicationPartition = entry.getValue().getSecond();
            if (!targetList.contains(newReplicationPartition) || (donorNode = currentPartitionsToNodeMap.get(entry.getKey()).intValue()) == stealNodeId) continue;
            this.createAndAdd(replicationMapping, donorNode, entry.getKey());
        }
        return replicationMapping;
    }

    private Map<Integer, List<Integer>> getStealMasterPartitions(List<Integer> stealList, Map<Integer, Integer> currentPartitionsToNodeMap) {
        HashMap<Integer, List<Integer>> stealPartitionsMap = new HashMap<Integer, List<Integer>>();
        for (int p : stealList) {
            int donorNode = currentPartitionsToNodeMap.get(p);
            this.createAndAdd(stealPartitionsMap, donorNode, p);
        }
        return stealPartitionsMap;
    }

    private void createAndAdd(Map<Integer, List<Integer>> map, int key, int value) {
        if (!map.containsKey(key)) {
            map.put(key, new ArrayList());
        }
        map.get(key).add(value);
    }

    public String toString() {
        if (this.rebalanceTaskQueue.isEmpty()) {
            return "Cluster is already balanced, No rebalancing needed";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Cluster Rebalancing Plan:\n");
        for (RebalanceNodePlan nodePlan : this.rebalanceTaskQueue) {
            builder.append("StealerNode:" + nodePlan.getStealerNode() + "\n");
            for (RebalancePartitionsInfo stealInfo : nodePlan.getRebalanceTaskList()) {
                builder.append("\t" + stealInfo + "\n");
            }
        }
        return builder.toString();
    }
}

