/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import voldemort.VoldemortClusterViewer;
import voldemort.client.rebalance.RebalanceClusterTool;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.store.StoreDefinition;
import voldemort.utils.CmdUtils;
import voldemort.utils.Utils;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RebalanceClusterBuilder {
    private final Cluster cluster;
    private final List<StoreDefinition> stores;
    private final int maxRemappedReplicas;
    private final int minNumPartitions;
    private final int desiredNumPartitions;

    private RebalanceClusterBuilder(Cluster cluster, List<StoreDefinition> stores, int maxRemappedReplicas, int minNumPartitions, int desiredNumPartitions) {
        this.cluster = cluster;
        this.stores = stores;
        this.maxRemappedReplicas = maxRemappedReplicas;
        this.minNumPartitions = minNumPartitions;
        this.desiredNumPartitions = desiredNumPartitions;
    }

    public static RebalanceClusterBuilder create(String clusterXmlFile, String storesXmlFile, int maxRemappedReplicas, int minNumPartitions, int desiredNumPartitions) throws IOException {
        Cluster cluster = new ClusterMapper().readCluster(new BufferedReader(new FileReader(clusterXmlFile)));
        List<StoreDefinition> stores = new StoreDefinitionsMapper().readStoreList(new BufferedReader(new FileReader(storesXmlFile)));
        if (desiredNumPartitions < minNumPartitions) {
            desiredNumPartitions = cluster.getNumberOfPartitions() / (cluster.getNumberOfNodes() + 1);
        }
        if (maxRemappedReplicas < 0) {
            maxRemappedReplicas = cluster.getNumberOfPartitions() / 2;
        }
        return new RebalanceClusterBuilder(cluster, stores, maxRemappedReplicas, minNumPartitions, desiredNumPartitions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(String targetClusterXmlFile, String host, int httpPort, int socketPort, int adminPort) throws IOException {
        StoreDefinition store = this.stores.get(0);
        for (int i = 1; i < this.stores.size(); ++i) {
            StoreDefinition curr = this.stores.get(i);
            if (store.getReplicationFactor() <= curr.getReplicationFactor()) continue;
            store = curr;
        }
        RebalanceClusterTool clusterTool = new RebalanceClusterTool(this.cluster, store);
        VoldemortClusterViewer voldemortClusterViewer = new VoldemortClusterViewer(this.cluster, store);
        System.out.println("Original layout: ");
        voldemortClusterViewer.viewMasterToReplica();
        Node template = new Node(this.cluster.getNumberOfNodes(), host, httpPort, socketPort, adminPort, ImmutableList.<Integer>of());
        System.out.println("Inserting " + template + "\n");
        System.out.println("Configuration " + Joiner.on(" ").withKeyValueSeparator("=").join(ImmutableMap.builder().put("maxRemappedReplicas", this.maxRemappedReplicas).put("minNumPartitions", this.minNumPartitions).put("desiredNumPartitions", this.desiredNumPartitions).build()));
        Cluster targetCluster = clusterTool.insertNode(template, this.minNumPartitions, this.desiredNumPartitions, this.maxRemappedReplicas);
        if (targetCluster == null) {
            Utils.croak("Unable to insert " + template + " into " + this.cluster);
        }
        System.out.println("Created target cluster layout: ");
        voldemortClusterViewer.viewMasterToReplica(targetCluster);
        voldemortClusterViewer.compareToCluster(targetCluster);
        String clusterXmlString = new ClusterMapper().writeCluster(targetCluster);
        if (targetClusterXmlFile == null) {
            System.err.println("Warning: target-cluster not specified, printing to STDOUT instead\n");
            System.out.println(clusterXmlString);
        } else {
            BufferedWriter out = new BufferedWriter(new FileWriter(targetClusterXmlFile));
            try {
                out.write(clusterXmlString);
            }
            finally {
                out.close();
            }
            System.out.println("Wrote target cluster.xml to " + targetClusterXmlFile);
        }
    }

    public static void main(String[] args) throws IOException {
        Set<String> missing;
        OptionParser parser = new OptionParser();
        parser.accepts("help", "print usage information");
        parser.accepts("stores", "[REQUIRED] path to the stores xml config file").withRequiredArg().describedAs("stores.xml");
        parser.accepts("cluster", "[REQUIRED] path to the ORIGINAL cluster xml config file").withRequiredArg().describedAs("cluster.xml");
        parser.accepts("target-cluster", "path to the TARGET cluster xml config file").withRequiredArg().describedAs("targetCluster.xml");
        parser.accepts("host", "[REQUIRED] new node's host name").withRequiredArg().describedAs("host-name");
        parser.accepts("http-port", "[REQUIRED] new node's http port").withRequiredArg().ofType(Integer.class).describedAs("http-port");
        parser.accepts("socket-port", "[REQUIRED] new node's socket port").withRequiredArg().ofType(Integer.class).describedAs("socket-port");
        parser.accepts("admin-port", "new node's admin port").withRequiredArg().ofType(Integer.class).describedAs("admin-port");
        parser.accepts("max-remaps", "Maximum number of replication mappings that may change").withRequiredArg().ofType(Integer.class);
        parser.accepts("desired-partitions", "Desired number of partitions per node").withRequiredArg().ofType(Integer.class);
        parser.accepts("min-partitions", "Minimum number of partitions per node").withRequiredArg().ofType(Integer.class);
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        if ((missing = CmdUtils.missing(options, "stores", "cluster", "host", "http-port", "socket-port")).size() > 0) {
            System.err.println("Missing required arguments: " + Joiner.on(", ").join(missing));
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        String storesXmlFile = (String)options.valueOf("stores");
        String clusterXmlFile = (String)options.valueOf("cluster");
        String targetClusterXmlFile = (String)options.valueOf("target-cluster");
        int maxRemappedReplicas = CmdUtils.valueOf(options, "max-remaps", Integer.valueOf(-1));
        int minNumPartitions = CmdUtils.valueOf(options, "min-partitions", Integer.valueOf(1));
        int desiredNumPartitions = CmdUtils.valueOf(options, "desired-partitions", Integer.valueOf(-1));
        String host = (String)options.valueOf("host");
        int httpPort = (Integer)options.valueOf("http-port");
        int socketPort = (Integer)options.valueOf("socket-port");
        int adminPort = CmdUtils.valueOf(options, "admin-port", Integer.valueOf(socketPort + 1));
        RebalanceClusterBuilder rebalanceClusterBuilder = RebalanceClusterBuilder.create(clusterXmlFile, storesXmlFile, maxRemappedReplicas, minNumPartitions, desiredNumPartitions);
        rebalanceClusterBuilder.build(targetClusterXmlFile, host, httpPort, socketPort, adminPort);
    }
}

