/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.rebalance;

import java.util.Properties;
import voldemort.client.protocol.admin.AdminClientConfig;
import voldemort.utils.Props;

public class RebalanceClientConfig
extends AdminClientConfig {
    private int maxParallelDonors = 1;
    private int maxParallelRebalancing = 1;
    private int rebalancingClientTimeoutSeconds = 604800;
    private boolean deleteAfterRebalancingEnabled;
    public static final String MaxParallelRebalancingString = "max.parallel.rebalancing";
    public static final String RebalancingClientTimeoutSeconds = "rebalancing.client.timeout.seconds";
    public static final String EnableDeleteAfterRebalancing = "enable.delete.after.rebalancing";
    public static final String MaxParallelDonorsString = "max.parallel.donors";

    public RebalanceClientConfig(Properties properties) {
        super(properties);
        Props props = new Props(properties);
        if (props.containsKey(MaxParallelDonorsString)) {
            this.setMaxParallelDonors(props.getInt(MaxParallelDonorsString));
        }
        if (props.containsKey(MaxParallelRebalancingString)) {
            this.setMaxParallelRebalancing(props.getInt(MaxParallelRebalancingString));
        }
        if (props.containsKey(RebalancingClientTimeoutSeconds)) {
            this.setRebalancingClientTimeoutSeconds(props.getInt(RebalancingClientTimeoutSeconds));
        }
        if (props.containsKey(EnableDeleteAfterRebalancing)) {
            this.setDeleteAfterRebalancingEnabled(props.getBoolean(EnableDeleteAfterRebalancing));
        }
    }

    public RebalanceClientConfig() {
        this(new Properties());
    }

    public void setMaxParallelDonors(int maxParallelDonors) {
        this.maxParallelDonors = maxParallelDonors;
    }

    public int getMaxParallelDonors() {
        return this.maxParallelDonors;
    }

    public void setMaxParallelRebalancing(int maxParallelRebalancing) {
        this.maxParallelRebalancing = maxParallelRebalancing;
    }

    public int getMaxParallelRebalancing() {
        return this.maxParallelRebalancing;
    }

    public void setRebalancingClientTimeoutSeconds(int rebalancingTimeoutSeconds) {
        this.rebalancingClientTimeoutSeconds = rebalancingTimeoutSeconds;
    }

    public int getRebalancingClientTimeoutSeconds() {
        return this.rebalancingClientTimeoutSeconds;
    }

    public boolean isDeleteAfterRebalancingEnabled() {
        return this.deleteAfterRebalancingEnabled;
    }

    public void setDeleteAfterRebalancingEnabled(boolean deleteAfterRebalancingEnabled) {
        this.deleteAfterRebalancingEnabled = deleteAfterRebalancingEnabled;
    }
}

