/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.protocol.vold;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import voldemort.client.protocol.RequestFormat;
import voldemort.server.RequestRoutingType;
import voldemort.store.ErrorCodeMapper;
import voldemort.store.StoreUtils;
import voldemort.utils.ByteArray;
import voldemort.utils.ByteUtils;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortNativeClientRequestFormat
implements RequestFormat {
    private final ErrorCodeMapper mapper = new ErrorCodeMapper();
    private final int protocolVersion;

    public VoldemortNativeClientRequestFormat(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    @Override
    public void writeDeleteRequest(DataOutputStream outputStream, String storeName, ByteArray key, VectorClock version, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKey(key);
        outputStream.writeByte(3);
        outputStream.writeUTF(storeName);
        outputStream.writeBoolean(routingType.equals((Object)RequestRoutingType.ROUTED));
        if (this.protocolVersion >= 2) {
            outputStream.writeByte(routingType.getRoutingTypeCode());
        }
        outputStream.writeInt(key.length());
        outputStream.write(key.get());
        VectorClock clock = version;
        outputStream.writeShort(clock.sizeInBytes());
        outputStream.write(clock.toBytes());
    }

    @Override
    public boolean readDeleteResponse(DataInputStream inputStream) throws IOException {
        this.checkException(inputStream);
        return inputStream.readBoolean();
    }

    @Override
    public void writeGetRequest(DataOutputStream outputStream, String storeName, ByteArray key, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKey(key);
        outputStream.writeByte(1);
        outputStream.writeUTF(storeName);
        outputStream.writeBoolean(routingType.equals((Object)RequestRoutingType.ROUTED));
        if (this.protocolVersion >= 2) {
            outputStream.writeUTF(routingType.toString());
        }
        outputStream.writeInt(key.length());
        outputStream.write(key.get());
    }

    @Override
    public List<Versioned<byte[]>> readGetResponse(DataInputStream inputStream) throws IOException {
        this.checkException(inputStream);
        return this.readResults(inputStream);
    }

    private List<Versioned<byte[]>> readResults(DataInputStream inputStream) throws IOException {
        int resultSize = inputStream.readInt();
        ArrayList<Versioned<byte[]>> results = new ArrayList<Versioned<byte[]>>(resultSize);
        for (int i = 0; i < resultSize; ++i) {
            int valueSize = inputStream.readInt();
            byte[] bytes = new byte[valueSize];
            ByteUtils.read(inputStream, bytes);
            VectorClock clock = new VectorClock(bytes);
            results.add(new Versioned<byte[]>(ByteUtils.copy(bytes, clock.sizeInBytes(), bytes.length), clock));
        }
        return results;
    }

    @Override
    public void writeGetAllRequest(DataOutputStream output, String storeName, Iterable<ByteArray> keys, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKeys(keys);
        output.writeByte(4);
        output.writeUTF(storeName);
        output.writeBoolean(routingType.equals((Object)RequestRoutingType.ROUTED));
        if (this.protocolVersion >= 2) {
            output.writeUTF(routingType.toString());
        }
        ArrayList<ByteArray> l = new ArrayList<ByteArray>();
        for (ByteArray key : keys) {
            l.add(key);
        }
        output.writeInt(l.size());
        for (ByteArray key : keys) {
            output.writeInt(key.length());
            output.write(key.get());
        }
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> readGetAllResponse(DataInputStream stream) throws IOException {
        this.checkException(stream);
        int numResults = stream.readInt();
        HashMap<ByteArray, List<Versioned<byte[]>>> results = new HashMap<ByteArray, List<Versioned<byte[]>>>(numResults);
        for (int i = 0; i < numResults; ++i) {
            int keySize = stream.readInt();
            byte[] key = new byte[keySize];
            stream.readFully(key);
            results.put(new ByteArray(key), this.readResults(stream));
        }
        return results;
    }

    @Override
    public void writePutRequest(DataOutputStream outputStream, String storeName, ByteArray key, byte[] value, VectorClock version, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKey(key);
        outputStream.writeByte(2);
        outputStream.writeUTF(storeName);
        outputStream.writeBoolean(routingType.equals((Object)RequestRoutingType.ROUTED));
        if (this.protocolVersion >= 2) {
            outputStream.writeUTF(routingType.toString());
        }
        outputStream.writeInt(key.length());
        outputStream.write(key.get());
        outputStream.writeInt(value.length + version.sizeInBytes());
        outputStream.write(version.toBytes());
        outputStream.write(value);
    }

    @Override
    public void readPutResponse(DataInputStream inputStream) throws IOException {
        this.checkException(inputStream);
    }

    private void checkException(DataInputStream inputStream) throws IOException {
        short retCode = inputStream.readShort();
        if (retCode != 0) {
            String error = inputStream.readUTF();
            throw this.mapper.getError(retCode, error);
        }
    }

    @Override
    public List<Version> readGetVersionResponse(DataInputStream stream) throws IOException {
        this.checkException(stream);
        int resultSize = stream.readInt();
        ArrayList<Version> results = new ArrayList<Version>(resultSize);
        for (int i = 0; i < resultSize; ++i) {
            int versionSize = stream.readInt();
            byte[] bytes = new byte[versionSize];
            ByteUtils.read(stream, bytes);
            VectorClock clock = new VectorClock(bytes);
            results.add(clock);
        }
        return results;
    }

    @Override
    public void writeGetVersionRequest(DataOutputStream output, String storeName, ByteArray key, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKey(key);
        output.writeByte(10);
        output.writeUTF(storeName);
        output.writeBoolean(routingType.equals((Object)RequestRoutingType.ROUTED));
        if (this.protocolVersion >= 2) {
            output.writeUTF(routingType.toString());
        }
        output.writeInt(key.length());
        output.write(key.get());
    }
}

