/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.protocol.pb;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import voldemort.VoldemortException;
import voldemort.client.protocol.pb.VProto;
import voldemort.store.ErrorCodeMapper;
import voldemort.utils.ByteArray;
import voldemort.versioning.ClockEntry;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtoUtils {
    public static VProto.Error.Builder encodeError(ErrorCodeMapper mapper, VoldemortException e) {
        return VProto.Error.newBuilder().setErrorCode(mapper.getCode(e)).setErrorMessage(e.getMessage());
    }

    public static VProto.Versioned.Builder encodeVersioned(Versioned<byte[]> versioned) {
        return VProto.Versioned.newBuilder().setValue(ByteString.copyFrom((byte[])versioned.getValue())).setVersion(ProtoUtils.encodeClock(versioned.getVersion()));
    }

    public static Versioned<byte[]> decodeVersioned(VProto.Versioned versioned) {
        return new Versioned<byte[]>(versioned.getValue().toByteArray(), ProtoUtils.decodeClock(versioned.getVersion()));
    }

    public static List<Versioned<byte[]>> decodeVersions(List<VProto.Versioned> versioned) {
        ArrayList<Versioned<byte[]>> values = new ArrayList<Versioned<byte[]>>(versioned.size());
        for (VProto.Versioned v : versioned) {
            values.add(ProtoUtils.decodeVersioned(v));
        }
        return values;
    }

    public static VectorClock decodeClock(VProto.VectorClock encoded) {
        ArrayList<ClockEntry> entries = new ArrayList<ClockEntry>(encoded.getEntriesCount());
        for (VProto.ClockEntry entry : encoded.getEntriesList()) {
            entries.add(new ClockEntry((short)entry.getNodeId(), entry.getVersion()));
        }
        return new VectorClock(entries, encoded.getTimestamp());
    }

    public static VProto.VectorClock.Builder encodeClock(Version version) {
        VectorClock clock = (VectorClock)version;
        VProto.VectorClock.Builder encoded = VProto.VectorClock.newBuilder();
        encoded.setTimestamp(clock.getTimestamp());
        for (ClockEntry entry : clock.getEntries()) {
            encoded.addEntries(VProto.ClockEntry.newBuilder().setNodeId(entry.getNodeId()).setVersion(entry.getVersion()));
        }
        return encoded;
    }

    public static ByteArray decodeBytes(ByteString string) {
        return new ByteArray(string.toByteArray());
    }

    public static ByteString encodeBytes(ByteArray array) {
        return ByteString.copyFrom((byte[])array.get());
    }

    public static void writeMessage(DataOutputStream output, Message message) throws IOException {
        output.writeInt(message.getSerializedSize());
        CodedOutputStream codedOut = CodedOutputStream.newInstance((OutputStream)output);
        message.writeTo(codedOut);
        codedOut.flush();
    }

    public static void writeEndOfStream(DataOutputStream output) throws IOException {
        output.writeInt(-1);
    }

    public static <T extends Message.Builder> T readToBuilder(DataInputStream input, T builder) throws IOException {
        int size = input.readInt();
        CodedInputStream codedIn = CodedInputStream.newInstance((InputStream)input);
        codedIn.pushLimit(size);
        builder.mergeFrom(codedIn);
        return builder;
    }
}

