/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client.protocol.pb;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import voldemort.client.protocol.RequestFormat;
import voldemort.client.protocol.pb.ProtoUtils;
import voldemort.client.protocol.pb.VProto;
import voldemort.server.RequestRoutingType;
import voldemort.store.ErrorCodeMapper;
import voldemort.store.StoreUtils;
import voldemort.utils.ByteArray;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtoBuffClientRequestFormat
implements RequestFormat {
    public final ErrorCodeMapper mapper = new ErrorCodeMapper();

    @Override
    public void writeDeleteRequest(DataOutputStream output, String storeName, ByteArray key, VectorClock version, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKey(key);
        ProtoUtils.writeMessage(output, (Message)VProto.VoldemortRequest.newBuilder().setType(VProto.RequestType.DELETE).setStore(storeName).setShouldRoute(routingType.equals((Object)RequestRoutingType.ROUTED)).setRequestRouteType(routingType.getRoutingTypeCode()).setDelete(VProto.DeleteRequest.newBuilder().setKey(ByteString.copyFrom((byte[])key.get())).setVersion(ProtoUtils.encodeClock(version))).build());
    }

    @Override
    public boolean readDeleteResponse(DataInputStream input) throws IOException {
        VProto.DeleteResponse.Builder response = ProtoUtils.readToBuilder(input, VProto.DeleteResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        return response.getSuccess();
    }

    @Override
    public void writeGetRequest(DataOutputStream output, String storeName, ByteArray key, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKey(key);
        ProtoUtils.writeMessage(output, (Message)VProto.VoldemortRequest.newBuilder().setType(VProto.RequestType.GET).setStore(storeName).setShouldRoute(routingType.equals((Object)RequestRoutingType.ROUTED)).setRequestRouteType(routingType.getRoutingTypeCode()).setGet(VProto.GetRequest.newBuilder().setKey(ByteString.copyFrom((byte[])key.get()))).build());
    }

    @Override
    public List<Versioned<byte[]>> readGetResponse(DataInputStream input) throws IOException {
        VProto.GetResponse.Builder response = ProtoUtils.readToBuilder(input, VProto.GetResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        return ProtoUtils.decodeVersions(response.getVersionedList());
    }

    @Override
    public void writeGetAllRequest(DataOutputStream output, String storeName, Iterable<ByteArray> keys, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKeys(keys);
        VProto.GetAllRequest.Builder req = VProto.GetAllRequest.newBuilder();
        for (ByteArray key : keys) {
            req.addKeys(ByteString.copyFrom((byte[])key.get()));
        }
        ProtoUtils.writeMessage(output, (Message)VProto.VoldemortRequest.newBuilder().setType(VProto.RequestType.GET_ALL).setStore(storeName).setShouldRoute(routingType.equals((Object)RequestRoutingType.ROUTED)).setRequestRouteType(routingType.getRoutingTypeCode()).setGetAll(req).build());
    }

    @Override
    public Map<ByteArray, List<Versioned<byte[]>>> readGetAllResponse(DataInputStream input) throws IOException {
        VProto.GetAllResponse.Builder response = ProtoUtils.readToBuilder(input, VProto.GetAllResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        HashMap<ByteArray, List<Versioned<byte[]>>> vals = new HashMap<ByteArray, List<Versioned<byte[]>>>(response.getValuesCount());
        for (VProto.KeyedVersions versions : response.getValuesList()) {
            vals.put(ProtoUtils.decodeBytes(versions.getKey()), ProtoUtils.decodeVersions(versions.getVersionsList()));
        }
        return vals;
    }

    @Override
    public void writePutRequest(DataOutputStream output, String storeName, ByteArray key, byte[] value, VectorClock version, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKey(key);
        VProto.PutRequest.Builder req = VProto.PutRequest.newBuilder().setKey(ByteString.copyFrom((byte[])key.get())).setVersioned(VProto.Versioned.newBuilder().setValue(ByteString.copyFrom((byte[])value)).setVersion(ProtoUtils.encodeClock(version)));
        ProtoUtils.writeMessage(output, (Message)VProto.VoldemortRequest.newBuilder().setType(VProto.RequestType.PUT).setStore(storeName).setShouldRoute(routingType.equals((Object)RequestRoutingType.ROUTED)).setRequestRouteType(routingType.getRoutingTypeCode()).setPut(req).build());
    }

    @Override
    public void readPutResponse(DataInputStream input) throws IOException {
        VProto.PutResponse.Builder response = ProtoUtils.readToBuilder(input, VProto.PutResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
    }

    public void throwException(VProto.Error error) {
        throw this.mapper.getError((short)error.getErrorCode(), error.getErrorMessage());
    }

    @Override
    public List<Version> readGetVersionResponse(DataInputStream stream) throws IOException {
        VProto.GetVersionResponse.Builder response = ProtoUtils.readToBuilder(stream, VProto.GetVersionResponse.newBuilder());
        if (response.hasError()) {
            this.throwException(response.getError());
        }
        ArrayList<Version> versions = Lists.newArrayListWithCapacity(response.getVersionsCount());
        for (VProto.VectorClock version : response.getVersionsList()) {
            versions.add(ProtoUtils.decodeClock(version));
        }
        return versions;
    }

    @Override
    public void writeGetVersionRequest(DataOutputStream output, String storeName, ByteArray key, RequestRoutingType routingType) throws IOException {
        StoreUtils.assertValidKey(key);
        ProtoUtils.writeMessage(output, (Message)VProto.VoldemortRequest.newBuilder().setType(VProto.RequestType.GET_VERSION).setStore(storeName).setShouldRoute(routingType.equals((Object)RequestRoutingType.ROUTED)).setRequestRouteType(routingType.getRoutingTypeCode()).setGet(VProto.GetRequest.newBuilder().setKey(ByteString.copyFrom((byte[])key.get()))).build());
    }
}

