/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client;

import java.net.URI;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import voldemort.client.AbstractStoreClientFactory;
import voldemort.client.ClientConfig;
import voldemort.client.RoutingTier;
import voldemort.client.protocol.RequestFormatType;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.ClientStoreVerifier;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.cluster.failuredetector.FailureDetectorConfig;
import voldemort.cluster.failuredetector.FailureDetectorListener;
import voldemort.cluster.failuredetector.FailureDetectorUtils;
import voldemort.store.Store;
import voldemort.store.socket.SocketDestination;
import voldemort.store.socket.SocketPool;
import voldemort.store.socket.SocketStore;
import voldemort.utils.ByteArray;
import voldemort.utils.JmxUtils;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SocketStoreClientFactory
extends AbstractStoreClientFactory {
    public static final String URL_SCHEME = "tcp";
    private final SocketPool socketPool;
    private final RoutingTier routingTier;
    private FailureDetectorListener failureDetectorListener;

    public SocketStoreClientFactory(ClientConfig config) {
        super(config);
        this.routingTier = config.getRoutingTier();
        this.socketPool = new SocketPool(config.getMaxConnectionsPerNode(), config.getConnectionTimeout(TimeUnit.MILLISECONDS), config.getSocketTimeout(TimeUnit.MILLISECONDS), config.getSocketBufferSize(), config.getSocketKeepAlive());
        if (config.isJmxEnabled()) {
            JmxUtils.registerMbean(this.socketPool, JmxUtils.createObjectName(SocketPool.class));
        }
    }

    @Override
    protected Store<ByteArray, byte[]> getStore(String storeName, String host, int port, RequestFormatType type) {
        return new SocketStore(Utils.notNull(storeName), new SocketDestination(Utils.notNull(host), port, type), this.socketPool, RoutingTier.SERVER.equals((Object)this.routingTier));
    }

    @Override
    protected FailureDetector initFailureDetector(final ClientConfig config, Collection<Node> nodes) {
        this.failureDetectorListener = new FailureDetectorListener(){

            public void nodeAvailable(Node node) {
            }

            public void nodeUnavailable(Node node) {
                if (AbstractStoreClientFactory.logger.isInfoEnabled()) {
                    AbstractStoreClientFactory.logger.info(node + " has been marked as unavailable, destroying socket pool");
                }
                SocketDestination destination = new SocketDestination(node.getHost(), node.getSocketPort(), config.getRequestFormatType());
                SocketStoreClientFactory.this.socketPool.close(destination);
            }
        };
        ClientStoreVerifier storeVerifier = new ClientStoreVerifier(){

            @Override
            protected Store<ByteArray, byte[]> getStoreInternal(Node node) {
                return SocketStoreClientFactory.this.getStore("metadata", node.getHost(), node.getSocketPort(), config.getRequestFormatType());
            }
        };
        FailureDetectorConfig failureDetectorConfig = new FailureDetectorConfig(config).setNodes(nodes).setStoreVerifier(storeVerifier);
        return FailureDetectorUtils.create(failureDetectorConfig, true, this.failureDetectorListener);
    }

    @Override
    protected int getPort(Node node) {
        return node.getSocketPort();
    }

    @Override
    protected void validateUrl(URI url) {
        if (!URL_SCHEME.equals(url.getScheme())) {
            throw new IllegalArgumentException("Illegal scheme in bootstrap URL for SocketStoreClientFactory: expected 'tcp' but found '" + url.getScheme() + "'.");
        }
    }

    @Override
    public void close() {
        this.socketPool.close();
        if (this.failureDetector != null) {
            this.failureDetector.removeFailureDetectorListener(this.failureDetectorListener);
        }
        this.getThreadPool().shutdown();
        super.close();
    }
}

