/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client;

import voldemort.client.DefaultStoreClient;
import voldemort.client.StoreClient;
import voldemort.client.StoreClientFactory;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.cluster.failuredetector.NoopFailureDetector;
import voldemort.serialization.Serializer;
import voldemort.store.Store;
import voldemort.store.memory.InMemoryStorageEngine;
import voldemort.store.serialized.SerializingStore;
import voldemort.store.versioned.InconsistencyResolvingStore;
import voldemort.store.versioned.VersionIncrementingStore;
import voldemort.utils.ByteArray;
import voldemort.utils.SystemTime;
import voldemort.utils.Time;
import voldemort.versioning.ChainedResolver;
import voldemort.versioning.InconsistencyResolver;
import voldemort.versioning.TimeBasedInconsistencyResolver;
import voldemort.versioning.VectorClockInconsistencyResolver;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockStoreClientFactory
implements StoreClientFactory {
    private final int nodeId;
    private final Serializer<?> keySerializer;
    private final Serializer<?> valueSerializer;
    private final Time time;
    private final FailureDetector failureDetector;

    public MockStoreClientFactory(Serializer<?> keySerializer, Serializer<?> valueSerializer) {
        this(keySerializer, valueSerializer, 0, SystemTime.INSTANCE);
    }

    public MockStoreClientFactory(Serializer<?> keySerializer, Serializer<?> valueSerializer, int nodeId, Time time) {
        this.nodeId = nodeId;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.time = time;
        this.failureDetector = new NoopFailureDetector();
    }

    @Override
    public <K, V> StoreClient<K, V> getStoreClient(String storeName) {
        return this.getStoreClient(storeName, new TimeBasedInconsistencyResolver());
    }

    @Override
    public <K, V> StoreClient<K, V> getStoreClient(String storeName, InconsistencyResolver<Versioned<V>> resolver) {
        return new DefaultStoreClient(storeName, resolver, this, 3);
    }

    public <K1, V1> Store<K1, V1> getRawStore(String storeName, InconsistencyResolver<Versioned<V1>> resolver) {
        InconsistencyResolver<Versioned<Object>> secondaryResolver = new TimeBasedInconsistencyResolver();
        if (resolver != null) {
            secondaryResolver = resolver;
        }
        Store<ByteArray, Object> store = new VersionIncrementingStore<ByteArray, byte[]>(new InMemoryStorageEngine(storeName), this.nodeId, this.time);
        if (this.isSerialized()) {
            store = new SerializingStore(store, this.keySerializer, this.valueSerializer);
        }
        InconsistencyResolvingStore<ByteArray, byte[]> consistentStore = new InconsistencyResolvingStore<ByteArray, byte[]>(store, new ChainedResolver(new VectorClockInconsistencyResolver(), secondaryResolver));
        return consistentStore;
    }

    private boolean isSerialized() {
        return this.keySerializer != null && this.valueSerializer != null;
    }

    @Override
    public void close() {
    }

    @Override
    public FailureDetector getFailureDetector() {
        return this.failureDetector;
    }
}

