/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client;

import java.net.URI;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import voldemort.client.AbstractStoreClientFactory;
import voldemort.client.ClientConfig;
import voldemort.client.RoutingTier;
import voldemort.client.protocol.RequestFormatFactory;
import voldemort.client.protocol.RequestFormatType;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.ClientStoreVerifier;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.cluster.failuredetector.FailureDetectorConfig;
import voldemort.cluster.failuredetector.FailureDetectorListener;
import voldemort.cluster.failuredetector.FailureDetectorUtils;
import voldemort.store.Store;
import voldemort.store.http.HttpStore;
import voldemort.utils.ByteArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpStoreClientFactory
extends AbstractStoreClientFactory {
    public static final String URL_SCHEME = "http";
    private static final String VOLDEMORT_USER_AGENT = "vldmrt/0.01";
    private final HttpClient httpClient;
    private final MultiThreadedHttpConnectionManager connectionManager;
    private final RequestFormatFactory requestFormatFactory;
    private final boolean reroute;

    public HttpStoreClientFactory(ClientConfig config) {
        super(config);
        HostConfiguration hostConfig = new HostConfiguration();
        hostConfig.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        this.httpClient = new HttpClient((HttpConnectionManager)this.connectionManager);
        this.httpClient.setHostConfiguration(hostConfig);
        HttpClientParams clientParams = this.httpClient.getParams();
        clientParams.setConnectionManagerTimeout((long)config.getConnectionTimeout(TimeUnit.MILLISECONDS));
        clientParams.setSoTimeout(config.getSocketTimeout(TimeUnit.MILLISECONDS));
        clientParams.setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(0, false));
        clientParams.setCookiePolicy("ignoreCookies");
        clientParams.setParameter("http.useragent", (Object)VOLDEMORT_USER_AGENT);
        HttpConnectionManagerParams managerParams = this.httpClient.getHttpConnectionManager().getParams();
        managerParams.setConnectionTimeout(config.getConnectionTimeout(TimeUnit.MILLISECONDS));
        managerParams.setMaxTotalConnections(config.getMaxTotalConnections());
        managerParams.setStaleCheckingEnabled(false);
        managerParams.setMaxConnectionsPerHost(this.httpClient.getHostConfiguration(), config.getMaxConnectionsPerNode());
        this.reroute = config.getRoutingTier().equals((Object)RoutingTier.SERVER);
        this.requestFormatFactory = new RequestFormatFactory();
    }

    @Override
    protected Store<ByteArray, byte[]> getStore(String name, String host, int port, RequestFormatType type) {
        return new HttpStore(name, host, port, this.httpClient, this.requestFormatFactory.getRequestFormat(type), this.reroute);
    }

    @Override
    protected FailureDetector initFailureDetector(final ClientConfig config, Collection<Node> nodes) {
        ClientStoreVerifier storeVerifier = new ClientStoreVerifier(){

            @Override
            protected Store<ByteArray, byte[]> getStoreInternal(Node node) {
                return HttpStoreClientFactory.this.getStore("metadata", node.getHost(), node.getHttpPort(), config.getRequestFormatType());
            }
        };
        FailureDetectorConfig failureDetectorConfig = new FailureDetectorConfig(config).setNodes(nodes).setStoreVerifier(storeVerifier);
        return FailureDetectorUtils.create(failureDetectorConfig, config.isJmxEnabled(), new FailureDetectorListener[0]);
    }

    @Override
    protected int getPort(Node node) {
        return node.getHttpPort();
    }

    @Override
    protected void validateUrl(URI url) {
        if (!URL_SCHEME.equals(url.getScheme())) {
            throw new IllegalArgumentException("Illegal scheme in bootstrap URL for HttpStoreClientFactory: expected 'http' but found '" + url.getScheme() + "'.");
        }
    }

    @Override
    public void close() {
        super.close();
    }
}

