/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import voldemort.VoldemortException;
import voldemort.annotations.concurrency.Threadsafe;
import voldemort.annotations.jmx.JmxManaged;
import voldemort.annotations.jmx.JmxOperation;
import voldemort.client.StoreClient;
import voldemort.client.StoreClientFactory;
import voldemort.client.UpdateAction;
import voldemort.cluster.Node;
import voldemort.routing.RoutingStrategy;
import voldemort.serialization.Serializer;
import voldemort.store.InvalidMetadataException;
import voldemort.store.Store;
import voldemort.store.StoreCapabilityType;
import voldemort.utils.Utils;
import voldemort.versioning.InconsistencyResolver;
import voldemort.versioning.InconsistentDataException;
import voldemort.versioning.ObsoleteVersionException;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Version;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@JmxManaged(description="A voldemort client")
@Threadsafe
public class DefaultStoreClient<K, V>
implements StoreClient<K, V> {
    private final Logger logger = Logger.getLogger(DefaultStoreClient.class);
    private final StoreClientFactory storeFactory;
    private final int metadataRefreshAttempts;
    private final String storeName;
    private final InconsistencyResolver<Versioned<V>> resolver;
    private volatile Store<K, V> store;

    public DefaultStoreClient(String storeName, InconsistencyResolver<Versioned<V>> resolver, StoreClientFactory storeFactory, int maxMetadataRefreshAttempts) {
        this.storeName = Utils.notNull(storeName);
        this.resolver = resolver;
        this.storeFactory = Utils.notNull(storeFactory);
        this.metadataRefreshAttempts = maxMetadataRefreshAttempts;
        this.bootStrap();
    }

    @JmxOperation(description="bootstrap metadata from the cluster.")
    public void bootStrap() {
        this.logger.info("bootstrapping metadata.");
        this.store = this.storeFactory.getRawStore(this.storeName, this.resolver);
    }

    @Override
    public boolean delete(K key) {
        Versioned<V> versioned = this.get(key);
        if (versioned == null) {
            return false;
        }
        return this.delete(key, versioned.getVersion());
    }

    @Override
    public boolean delete(K key, Version version) {
        for (int attempts = 0; attempts < this.metadataRefreshAttempts; ++attempts) {
            try {
                return this.store.delete(key, version);
            }
            catch (InvalidMetadataException e) {
                this.bootStrap();
                continue;
            }
        }
        throw new VoldemortException(this.metadataRefreshAttempts + " metadata refresh attempts failed.");
    }

    @Override
    public V getValue(K key, V defaultValue) {
        Versioned<V> versioned = this.get(key);
        if (versioned == null) {
            return defaultValue;
        }
        return versioned.getValue();
    }

    @Override
    public V getValue(K key) {
        Versioned<V> returned = this.get(key, null);
        if (returned == null) {
            return null;
        }
        return returned.getValue();
    }

    @Override
    public Versioned<V> get(K key, Versioned<V> defaultValue) {
        for (int attempts = 0; attempts < this.metadataRefreshAttempts; ++attempts) {
            try {
                List<Versioned<V>> items = this.store.get(key);
                return this.getItemOrThrow(key, defaultValue, items);
            }
            catch (InvalidMetadataException e) {
                this.bootStrap();
                continue;
            }
        }
        throw new VoldemortException(this.metadataRefreshAttempts + " metadata refresh attempts failed.");
    }

    private List<Version> getVersions(K key) {
        for (int attempts = 0; attempts < this.metadataRefreshAttempts; ++attempts) {
            try {
                return this.store.getVersions(key);
            }
            catch (InvalidMetadataException e) {
                this.bootStrap();
                continue;
            }
        }
        throw new VoldemortException(this.metadataRefreshAttempts + " metadata refresh attempts failed.");
    }

    private Versioned<V> getItemOrThrow(K key, Versioned<V> defaultValue, List<Versioned<V>> items) {
        if (items.size() == 0) {
            return defaultValue;
        }
        if (items.size() == 1) {
            return items.get(0);
        }
        throw new InconsistentDataException("Unresolved versions returned from get(" + key + ") = " + items, items);
    }

    @Override
    public Versioned<V> get(K key) {
        return this.get(key, null);
    }

    @Override
    public Map<K, Versioned<V>> getAll(Iterable<K> keys) {
        Map<K, List<Versioned<V>>> items = null;
        int attempts = 0;
        while (true) {
            if (attempts >= this.metadataRefreshAttempts) {
                throw new VoldemortException(this.metadataRefreshAttempts + " metadata refresh attempts failed.");
            }
            try {
                items = this.store.getAll(keys);
            }
            catch (InvalidMetadataException e) {
                this.bootStrap();
                ++attempts;
                continue;
            }
            break;
        }
        HashMap<K, Versioned<V>> result = Maps.newHashMapWithExpectedSize(items.size());
        for (Map.Entry<K, List<Versioned<V>>> mapEntry : items.entrySet()) {
            Versioned<V> value = this.getItemOrThrow(mapEntry.getKey(), null, mapEntry.getValue());
            result.put(mapEntry.getKey(), value);
        }
        return result;
    }

    @Override
    public void put(K key, V value) {
        Versioned<V> versioned;
        List<Version> versions = this.getVersions(key);
        if (versions.isEmpty()) {
            versioned = Versioned.value(value, new VectorClock());
        } else if (versions.size() == 1) {
            versioned = Versioned.value(value, versions.get(0));
        } else {
            versioned = this.get(key, null);
            if (versioned == null) {
                versioned = Versioned.value(value, new VectorClock());
            } else {
                versioned.setObject(value);
            }
        }
        this.put(key, versioned);
    }

    @Override
    public boolean putIfNotObsolete(K key, Versioned<V> versioned) {
        try {
            this.put(key, versioned);
            return true;
        }
        catch (ObsoleteVersionException e) {
            return false;
        }
    }

    @Override
    public void put(K key, Versioned<V> versioned) throws ObsoleteVersionException {
        for (int attempts = 0; attempts < this.metadataRefreshAttempts; ++attempts) {
            try {
                this.store.put(key, versioned);
                return;
            }
            catch (InvalidMetadataException e) {
                this.bootStrap();
                continue;
            }
        }
        throw new VoldemortException(this.metadataRefreshAttempts + " metadata refresh attempts failed.");
    }

    @Override
    public boolean applyUpdate(UpdateAction<K, V> action) {
        return this.applyUpdate(action, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean applyUpdate(UpdateAction<K, V> action, int maxTries) {
        boolean success = false;
        try {
            for (int i = 0; i < maxTries; ++i) {
                try {
                    action.update(this);
                    boolean bl = success = true;
                    return bl;
                }
                catch (ObsoleteVersionException e) {
                    try {
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                        return false;
                    }
                }
            }
        }
        finally {
            if (!success) {
                action.rollback();
            }
        }
    }

    @Override
    public List<Node> getResponsibleNodes(K key) {
        RoutingStrategy strategy = (RoutingStrategy)this.store.getCapability(StoreCapabilityType.ROUTING_STRATEGY);
        Serializer keySerializer = (Serializer)this.store.getCapability(StoreCapabilityType.KEY_SERIALIZER);
        return strategy.routeRequest(keySerializer.toBytes(key));
    }

    private Version getVersion(K key) {
        List<Version> versions = this.getVersions(key);
        if (versions.size() == 0) {
            return null;
        }
        if (versions.size() == 1) {
            return versions.get(0);
        }
        throw new InconsistentDataException("Unresolved versions returned from get(" + key + ") = " + versions, versions);
    }
}

