/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client;

import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import voldemort.client.RoutingTier;
import voldemort.client.protocol.RequestFormatType;
import voldemort.cluster.failuredetector.FailureDetectorConfig;
import voldemort.serialization.DefaultSerializerFactory;
import voldemort.serialization.SerializerFactory;
import voldemort.utils.Props;
import voldemort.utils.ReflectUtils;
import voldemort.utils.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClientConfig {
    private volatile int maxConnectionsPerNode = 6;
    private volatile int maxTotalConnections = 500;
    private volatile int maxThreads = 5;
    private volatile int maxQueuedRequests = 50;
    private volatile long threadIdleMs = 100000L;
    private volatile long connectionTimeoutMs = 500L;
    private volatile long socketTimeoutMs = 5000L;
    private volatile boolean socketKeepAlive = false;
    private volatile long routingTimeoutMs = 15000L;
    private volatile int socketBufferSize = 65536;
    private volatile SerializerFactory serializerFactory = new DefaultSerializerFactory();
    private volatile List<String> bootstrapUrls = null;
    private volatile RequestFormatType requestFormatType = RequestFormatType.VOLDEMORT_V1;
    private volatile RoutingTier routingTier = RoutingTier.CLIENT;
    private volatile boolean enableJmx = true;
    private volatile String failureDetectorImplementation = FailureDetectorConfig.DEFAULT_IMPLEMENTATION_CLASS_NAME;
    private volatile long failureDetectorBannagePeriod = 30000L;
    private volatile int failureDetectorThreshold = 80;
    private volatile int failureDetectorThresholdCountMinimum = 10;
    private volatile long failureDetectorThresholdInterval = 10000L;
    private volatile long failureDetectorAsyncRecoveryInterval = 10000L;
    private volatile List<String> failureDetectorCatastrophicErrorTypes = FailureDetectorConfig.DEFAULT_CATASTROPHIC_ERROR_TYPES;
    private long failureDetectorRequestLengthThreshold = this.socketTimeoutMs;
    private volatile int maxBootstrapRetries = 2;
    public static final String MAX_CONNECTIONS_PER_NODE_PROPERTY = "max_connections";
    public static final String MAX_TOTAL_CONNECTIONS_PROPERTY = "max_total_connections";
    public static final String MAX_THREADS_PROPERTY = "max_threads";
    public static final String MAX_QUEUED_REQUESTS_PROPERTY = "max_queued_requests";
    public static final String THREAD_IDLE_MS_PROPERTY = "thread_idle_ms";
    public static final String CONNECTION_TIMEOUT_MS_PROPERTY = "connection_timeout_ms";
    public static final String SOCKET_TIMEOUT_MS_PROPERTY = "socket_timeout_ms";
    public static final String SOCKET_KEEPALIVE_PROPERTY = "socket_keepalive";
    public static final String ROUTING_TIMEOUT_MS_PROPERTY = "routing_timeout_ms";
    public static final String NODE_BANNAGE_MS_PROPERTY = "node_bannage_ms";
    public static final String SOCKET_BUFFER_SIZE_PROPERTY = "socket_buffer_size";
    public static final String SERIALIZER_FACTORY_CLASS_PROPERTY = "serializer_factory_class";
    public static final String BOOTSTRAP_URLS_PROPERTY = "bootstrap_urls";
    public static final String REQUEST_FORMAT_PROPERTY = "request_format";
    public static final String ENABLE_JMX_PROPERTY = "enable_jmx";
    public static final String FAILUREDETECTOR_IMPLEMENTATION_PROPERTY = "failuredetector_implementation";
    public static final String FAILUREDETECTOR_BANNAGE_PERIOD_PROPERTY = "failuredetector_bannage_period";
    public static final String FAILUREDETECTOR_THRESHOLD_PROPERTY = "failuredetector_threshold";
    public static final String FAILUREDETECTOR_THRESHOLD_INTERVAL_PROPERTY = "failuredetector_threshold_interval";
    public static final String FAILUREDETECTOR_THRESHOLD_COUNTMINIMUM_PROPERTY = "failuredetector_threshold_countminimum";
    public static final String FAILUREDETECTOR_ASYNCRECOVERY_INTERVAL_PROPERTY = "failuredetector_asyncscan_interval";
    public static final String FAILUREDETECTOR_CATASTROPHIC_ERROR_TYPES_PROPERTY = "failuredetector_catastrophic_error_types";
    public static final String FAILUREDETECTOR_REQUEST_LENGTH_THRESHOLD_PROPERTY = "failuredetector_request_length_threshold";
    public static final String MAX_BOOTSTRAP_RETRIES = "max_bootstrap_retries";

    public ClientConfig() {
    }

    public ClientConfig(Properties properties) {
        Props props = new Props(properties);
        if (props.containsKey(MAX_CONNECTIONS_PER_NODE_PROPERTY)) {
            this.setMaxConnectionsPerNode(props.getInt(MAX_CONNECTIONS_PER_NODE_PROPERTY));
        }
        if (props.containsKey(MAX_TOTAL_CONNECTIONS_PROPERTY)) {
            this.setMaxTotalConnections(props.getInt(MAX_TOTAL_CONNECTIONS_PROPERTY));
        }
        if (props.containsKey(MAX_THREADS_PROPERTY)) {
            this.setMaxThreads(props.getInt(MAX_THREADS_PROPERTY));
        }
        if (props.containsKey(MAX_QUEUED_REQUESTS_PROPERTY)) {
            this.setMaxQueuedRequests(props.getInt(MAX_QUEUED_REQUESTS_PROPERTY));
        }
        if (props.containsKey(THREAD_IDLE_MS_PROPERTY)) {
            this.setThreadIdleTime(props.getLong(THREAD_IDLE_MS_PROPERTY), TimeUnit.MILLISECONDS);
        }
        if (props.containsKey(CONNECTION_TIMEOUT_MS_PROPERTY)) {
            this.setConnectionTimeout(props.getInt(CONNECTION_TIMEOUT_MS_PROPERTY), TimeUnit.MILLISECONDS);
        }
        if (props.containsKey(SOCKET_TIMEOUT_MS_PROPERTY)) {
            this.setSocketTimeout(props.getInt(SOCKET_TIMEOUT_MS_PROPERTY), TimeUnit.MILLISECONDS);
        }
        if (props.containsKey(SOCKET_KEEPALIVE_PROPERTY)) {
            this.setSocketKeepAlive(props.getBoolean(SOCKET_KEEPALIVE_PROPERTY));
        }
        if (props.containsKey(ROUTING_TIMEOUT_MS_PROPERTY)) {
            this.setRoutingTimeout(props.getInt(ROUTING_TIMEOUT_MS_PROPERTY), TimeUnit.MILLISECONDS);
        }
        if (props.containsKey(SOCKET_BUFFER_SIZE_PROPERTY)) {
            this.setSocketBufferSize(props.getInt(SOCKET_BUFFER_SIZE_PROPERTY));
        }
        if (props.containsKey(SERIALIZER_FACTORY_CLASS_PROPERTY)) {
            Class<?> factoryClass = ReflectUtils.loadClass(props.getString(SERIALIZER_FACTORY_CLASS_PROPERTY));
            SerializerFactory factory = (SerializerFactory)ReflectUtils.callConstructor(factoryClass, new Object[0]);
            this.setSerializerFactory(factory);
        }
        if (props.containsKey(BOOTSTRAP_URLS_PROPERTY)) {
            this.setBootstrapUrls(props.getList(BOOTSTRAP_URLS_PROPERTY));
        }
        if (props.containsKey(REQUEST_FORMAT_PROPERTY)) {
            this.setRequestFormatType(RequestFormatType.fromCode(props.getString(REQUEST_FORMAT_PROPERTY)));
        }
        if (props.containsKey(ENABLE_JMX_PROPERTY)) {
            this.setEnableJmx(props.getBoolean(ENABLE_JMX_PROPERTY));
        }
        if (props.containsKey(FAILUREDETECTOR_IMPLEMENTATION_PROPERTY)) {
            this.setFailureDetectorImplementation(props.getString(FAILUREDETECTOR_IMPLEMENTATION_PROPERTY));
        }
        if (props.containsKey(NODE_BANNAGE_MS_PROPERTY) && !props.containsKey(FAILUREDETECTOR_BANNAGE_PERIOD_PROPERTY)) {
            props.put(FAILUREDETECTOR_BANNAGE_PERIOD_PROPERTY, props.get(NODE_BANNAGE_MS_PROPERTY));
        }
        if (props.containsKey(FAILUREDETECTOR_BANNAGE_PERIOD_PROPERTY)) {
            this.setFailureDetectorBannagePeriod(props.getLong(FAILUREDETECTOR_BANNAGE_PERIOD_PROPERTY));
        }
        if (props.containsKey(FAILUREDETECTOR_THRESHOLD_PROPERTY)) {
            this.setFailureDetectorThreshold(props.getInt(FAILUREDETECTOR_THRESHOLD_PROPERTY));
        }
        if (props.containsKey(FAILUREDETECTOR_THRESHOLD_COUNTMINIMUM_PROPERTY)) {
            this.setFailureDetectorThresholdCountMinimum(props.getInt(FAILUREDETECTOR_THRESHOLD_COUNTMINIMUM_PROPERTY));
        }
        if (props.containsKey(FAILUREDETECTOR_THRESHOLD_INTERVAL_PROPERTY)) {
            this.setFailureDetectorThresholdInterval(props.getLong(FAILUREDETECTOR_THRESHOLD_INTERVAL_PROPERTY));
        }
        if (props.containsKey(FAILUREDETECTOR_ASYNCRECOVERY_INTERVAL_PROPERTY)) {
            this.setFailureDetectorAsyncRecoveryInterval(props.getLong(FAILUREDETECTOR_ASYNCRECOVERY_INTERVAL_PROPERTY));
        }
        if (props.containsKey(FAILUREDETECTOR_CATASTROPHIC_ERROR_TYPES_PROPERTY)) {
            this.setFailureDetectorCatastrophicErrorTypes(props.getList(FAILUREDETECTOR_CATASTROPHIC_ERROR_TYPES_PROPERTY));
        }
        if (props.containsKey(FAILUREDETECTOR_REQUEST_LENGTH_THRESHOLD_PROPERTY)) {
            this.setFailureDetectorRequestLengthThreshold(props.getLong(FAILUREDETECTOR_REQUEST_LENGTH_THRESHOLD_PROPERTY));
        } else {
            this.setFailureDetectorRequestLengthThreshold(this.getSocketTimeout(TimeUnit.MILLISECONDS));
        }
        if (props.containsKey(MAX_BOOTSTRAP_RETRIES)) {
            this.setMaxBootstrapRetries(props.getInt(MAX_BOOTSTRAP_RETRIES));
        }
    }

    public int getMaxConnectionsPerNode() {
        return this.maxConnectionsPerNode;
    }

    public ClientConfig setMaxConnectionsPerNode(int maxConnectionsPerNode) {
        if (maxConnectionsPerNode <= 0) {
            throw new IllegalArgumentException("Value must be greater than zero.");
        }
        this.maxConnectionsPerNode = maxConnectionsPerNode;
        return this;
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }

    public ClientConfig setMaxTotalConnections(int maxTotalConnections) {
        if (maxTotalConnections <= 0) {
            throw new IllegalArgumentException("Value must be greater than zero.");
        }
        this.maxTotalConnections = maxTotalConnections;
        return this;
    }

    public int getSocketTimeout(TimeUnit unit) {
        return this.toInt(unit.convert(this.socketTimeoutMs, TimeUnit.MILLISECONDS));
    }

    public ClientConfig setSocketTimeout(int socketTimeout, TimeUnit unit) {
        this.socketTimeoutMs = unit.toMillis(socketTimeout);
        return this;
    }

    public boolean getSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public ClientConfig setSocketKeepAlive(boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
        return this;
    }

    public int getRoutingTimeout(TimeUnit unit) {
        return this.toInt(unit.convert(this.routingTimeoutMs, TimeUnit.MILLISECONDS));
    }

    public ClientConfig setRoutingTimeout(int routingTimeout, TimeUnit unit) {
        this.routingTimeoutMs = unit.toMillis(routingTimeout);
        return this;
    }

    @Deprecated
    public int getNodeBannagePeriod(TimeUnit unit) {
        return this.toInt(unit.convert(this.failureDetectorBannagePeriod, TimeUnit.MILLISECONDS));
    }

    @Deprecated
    public ClientConfig setNodeBannagePeriod(int nodeBannagePeriod, TimeUnit unit) {
        this.failureDetectorBannagePeriod = unit.toMillis(nodeBannagePeriod);
        return this;
    }

    public int getConnectionTimeout(TimeUnit unit) {
        return (int)Math.min(unit.convert(this.connectionTimeoutMs, TimeUnit.MILLISECONDS), Integer.MAX_VALUE);
    }

    public ClientConfig setConnectionTimeout(int connectionTimeout, TimeUnit unit) {
        this.connectionTimeoutMs = unit.toMillis(connectionTimeout);
        return this;
    }

    public int getThreadIdleTime(TimeUnit unit) {
        return this.toInt(unit.convert(this.threadIdleMs, TimeUnit.MILLISECONDS));
    }

    public ClientConfig setThreadIdleTime(long threadIdleTime, TimeUnit unit) {
        this.threadIdleMs = unit.toMillis(threadIdleTime);
        return this;
    }

    public int getMaxQueuedRequests() {
        return this.maxQueuedRequests;
    }

    public ClientConfig setMaxQueuedRequests(int maxQueuedRequests) {
        this.maxQueuedRequests = maxQueuedRequests;
        return this;
    }

    public int getSocketBufferSize() {
        return this.socketBufferSize;
    }

    public ClientConfig setSocketBufferSize(int socketBufferSize) {
        this.socketBufferSize = socketBufferSize;
        return this;
    }

    public SerializerFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    public ClientConfig setSerializerFactory(SerializerFactory serializerFactory) {
        this.serializerFactory = Utils.notNull(serializerFactory);
        return this;
    }

    public String[] getBootstrapUrls() {
        if (this.bootstrapUrls == null) {
            throw new IllegalStateException("No bootstrap urls have been set.");
        }
        return this.bootstrapUrls.toArray(new String[this.bootstrapUrls.size()]);
    }

    public ClientConfig setBootstrapUrls(List<String> bootstrapUrls) {
        this.bootstrapUrls = Utils.notNull(bootstrapUrls);
        if (this.bootstrapUrls.size() <= 0) {
            throw new IllegalArgumentException("Must provide at least one bootstrap URL.");
        }
        return this;
    }

    public ClientConfig setBootstrapUrls(String ... bootstrapUrls) {
        this.bootstrapUrls = Arrays.asList((Object[])Utils.notNull(bootstrapUrls));
        if (this.bootstrapUrls.size() <= 0) {
            throw new IllegalArgumentException("Must provide at least one bootstrap URL.");
        }
        return this;
    }

    public RequestFormatType getRequestFormatType() {
        return this.requestFormatType;
    }

    public ClientConfig setRequestFormatType(RequestFormatType requestFormatType) {
        this.requestFormatType = Utils.notNull(requestFormatType);
        return this;
    }

    public RoutingTier getRoutingTier() {
        return this.routingTier;
    }

    public ClientConfig setRoutingTier(RoutingTier routingTier) {
        this.routingTier = Utils.notNull(routingTier);
        return this;
    }

    public int getMaxThreads() {
        return this.maxThreads;
    }

    public ClientConfig setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
        return this;
    }

    public int toInt(long l) {
        return (int)Math.min(l, Integer.MAX_VALUE);
    }

    public boolean isJmxEnabled() {
        return this.enableJmx;
    }

    public ClientConfig setEnableJmx(boolean enableJmx) {
        this.enableJmx = enableJmx;
        return this;
    }

    public String getFailureDetectorImplementation() {
        return this.failureDetectorImplementation;
    }

    public ClientConfig setFailureDetectorImplementation(String failureDetectorImplementation) {
        this.failureDetectorImplementation = failureDetectorImplementation;
        return this;
    }

    public long getFailureDetectorBannagePeriod() {
        return this.failureDetectorBannagePeriod;
    }

    public ClientConfig setFailureDetectorBannagePeriod(long failureDetectorBannagePeriod) {
        this.failureDetectorBannagePeriod = failureDetectorBannagePeriod;
        return this;
    }

    public int getFailureDetectorThreshold() {
        return this.failureDetectorThreshold;
    }

    public ClientConfig setFailureDetectorThreshold(int failureDetectorThreshold) {
        this.failureDetectorThreshold = failureDetectorThreshold;
        return this;
    }

    public int getFailureDetectorThresholdCountMinimum() {
        return this.failureDetectorThresholdCountMinimum;
    }

    public ClientConfig setFailureDetectorThresholdCountMinimum(int failureDetectorThresholdCountMinimum) {
        this.failureDetectorThresholdCountMinimum = failureDetectorThresholdCountMinimum;
        return this;
    }

    public long getFailureDetectorThresholdInterval() {
        return this.failureDetectorThresholdInterval;
    }

    public ClientConfig setFailureDetectorThresholdInterval(long failureDetectorThresholdInterval) {
        this.failureDetectorThresholdInterval = failureDetectorThresholdInterval;
        return this;
    }

    public long getFailureDetectorAsyncRecoveryInterval() {
        return this.failureDetectorAsyncRecoveryInterval;
    }

    public ClientConfig setFailureDetectorAsyncRecoveryInterval(long failureDetectorAsyncRecoveryInterval) {
        this.failureDetectorAsyncRecoveryInterval = failureDetectorAsyncRecoveryInterval;
        return this;
    }

    public List<String> getFailureDetectorCatastrophicErrorTypes() {
        return this.failureDetectorCatastrophicErrorTypes;
    }

    public ClientConfig setFailureDetectorCatastrophicErrorTypes(List<String> failureDetectorCatastrophicErrorTypes) {
        this.failureDetectorCatastrophicErrorTypes = failureDetectorCatastrophicErrorTypes;
        return this;
    }

    public long getFailureDetectorRequestLengthThreshold() {
        return this.failureDetectorRequestLengthThreshold;
    }

    public ClientConfig setFailureDetectorRequestLengthThreshold(long failureDetectorRequestLengthThreshold) {
        this.failureDetectorRequestLengthThreshold = failureDetectorRequestLengthThreshold;
        return this;
    }

    public int getMaxBootstrapRetries() {
        return this.maxBootstrapRetries;
    }

    public ClientConfig setMaxBootstrapRetries(int maxBootstrapRetries) {
        if (maxBootstrapRetries < 1) {
            throw new IllegalArgumentException("maxBootstrapRetries should be >= 1");
        }
        this.maxBootstrapRetries = maxBootstrapRetries;
        return this;
    }
}

