/*
 * Decompiled with CFR 0.152.
 */
package voldemort.client;

import com.google.common.collect.Maps;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;
import voldemort.client.BootstrapFailureException;
import voldemort.client.ClientConfig;
import voldemort.client.ClientThreadPool;
import voldemort.client.DefaultStoreClient;
import voldemort.client.StoreClient;
import voldemort.client.StoreClientFactory;
import voldemort.client.protocol.RequestFormatType;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.serialization.Serializer;
import voldemort.serialization.SerializerDefinition;
import voldemort.serialization.SerializerFactory;
import voldemort.serialization.StringSerializer;
import voldemort.store.Store;
import voldemort.store.StoreDefinition;
import voldemort.store.compress.CompressingStore;
import voldemort.store.compress.CompressionStrategy;
import voldemort.store.compress.CompressionStrategyFactory;
import voldemort.store.logging.LoggingStore;
import voldemort.store.routed.RoutedStore;
import voldemort.store.serialized.SerializingStore;
import voldemort.store.stats.StatTrackingStore;
import voldemort.store.stats.StoreStats;
import voldemort.store.stats.StoreStatsJmx;
import voldemort.store.versioned.InconsistencyResolvingStore;
import voldemort.utils.ByteArray;
import voldemort.utils.JmxUtils;
import voldemort.utils.SystemTime;
import voldemort.versioning.ChainedResolver;
import voldemort.versioning.InconsistencyResolver;
import voldemort.versioning.TimeBasedInconsistencyResolver;
import voldemort.versioning.VectorClockInconsistencyResolver;
import voldemort.versioning.Versioned;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractStoreClientFactory
implements StoreClientFactory {
    private static AtomicInteger jmxIdCounter = new AtomicInteger(0);
    public static final int DEFAULT_ROUTING_TIMEOUT_MS = 5000;
    protected static final ClusterMapper clusterMapper = new ClusterMapper();
    private static final StoreDefinitionsMapper storeMapper = new StoreDefinitionsMapper();
    protected static final Logger logger = Logger.getLogger(AbstractStoreClientFactory.class);
    private final URI[] bootstrapUrls;
    private final int routingTimeoutMs;
    private final ExecutorService threadPool;
    private final SerializerFactory serializerFactory;
    private final boolean isJmxEnabled;
    private final RequestFormatType requestFormatType;
    private final int jmxId;
    protected volatile FailureDetector failureDetector;
    private final int maxBootstrapRetries;
    private final StoreStats stats;
    private final ClientConfig config;

    public AbstractStoreClientFactory(ClientConfig config) {
        this.config = config;
        this.threadPool = new ClientThreadPool(config.getMaxThreads(), config.getThreadIdleTime(TimeUnit.MILLISECONDS), config.getMaxQueuedRequests());
        this.serializerFactory = config.getSerializerFactory();
        this.bootstrapUrls = this.validateUrls(config.getBootstrapUrls());
        this.routingTimeoutMs = config.getRoutingTimeout(TimeUnit.MILLISECONDS);
        this.isJmxEnabled = config.isJmxEnabled();
        this.requestFormatType = config.getRequestFormatType();
        this.jmxId = jmxIdCounter.getAndIncrement();
        this.maxBootstrapRetries = config.getMaxBootstrapRetries();
        this.stats = new StoreStats();
        if (this.isJmxEnabled) {
            JmxUtils.registerMbean(this.threadPool, JmxUtils.createObjectName(JmxUtils.getPackageName(this.threadPool.getClass()), JmxUtils.getClassName(this.threadPool.getClass()) + this.jmxId()));
            JmxUtils.registerMbean(new StoreStatsJmx(this.stats), JmxUtils.createObjectName("voldemort.store.stats.aggregate", "aggregate-perf" + this.jmxId()));
        }
    }

    @Override
    public <K, V> StoreClient<K, V> getStoreClient(String storeName) {
        return this.getStoreClient(storeName, null);
    }

    @Override
    public <K, V> StoreClient<K, V> getStoreClient(String storeName, InconsistencyResolver<Versioned<V>> resolver) {
        return new DefaultStoreClient(storeName, resolver, this, 3);
    }

    @Override
    public <K, V> Store<K, V> getRawStore(String storeName, InconsistencyResolver<Versioned<V>> resolver) {
        String clusterXml = this.bootstrapMetadataWithRetries("cluster.xml", this.bootstrapUrls);
        Cluster cluster = clusterMapper.readCluster(new StringReader(clusterXml));
        String storesXml = this.bootstrapMetadataWithRetries("stores.xml", this.bootstrapUrls);
        List<StoreDefinition> storeDefs = storeMapper.readStoreList(new StringReader(storesXml));
        StoreDefinition storeDef = null;
        for (StoreDefinition d : storeDefs) {
            if (!d.getName().equals(storeName)) continue;
            storeDef = d;
        }
        if (storeDef == null) {
            throw new BootstrapFailureException("Unknown store '" + storeName + "'.");
        }
        HashMap<Integer, Store<ByteArray, byte[]>> clientMapping = Maps.newHashMap();
        for (Node node : cluster.getNodes()) {
            Store<ByteArray, byte[]> store = this.getStore(storeDef.getName(), node.getHost(), this.getPort(node), this.requestFormatType);
            store = new LoggingStore<ByteArray, byte[]>(store);
            clientMapping.put(node.getId(), store);
        }
        boolean repairReads = !storeDef.isView();
        Store<ByteArray, byte[]> store = new RoutedStore(storeName, clientMapping, cluster, storeDef, repairReads, this.threadPool, this.routingTimeoutMs, this.getFailureDetector(), SystemTime.INSTANCE);
        if (this.isJmxEnabled) {
            StatTrackingStore<ByteArray, byte[]> statStore = new StatTrackingStore<ByteArray, byte[]>(store, this.stats);
            store = statStore;
            JmxUtils.registerMbean(new StoreStatsJmx(statStore.getStats()), JmxUtils.createObjectName(JmxUtils.getPackageName(store.getClass()), store.getName() + this.jmxId()));
        }
        if (storeDef.getKeySerializer().hasCompression() || storeDef.getValueSerializer().hasCompression()) {
            store = new CompressingStore(store, this.getCompressionStrategy(storeDef.getKeySerializer()), this.getCompressionStrategy(storeDef.getValueSerializer()));
        }
        Serializer<?> keySerializer = this.serializerFactory.getSerializer(storeDef.getKeySerializer());
        Serializer<?> valueSerializer = this.serializerFactory.getSerializer(storeDef.getValueSerializer());
        Store<?, ?> serializedStore = SerializingStore.wrap(store, keySerializer, valueSerializer);
        TimeBasedInconsistencyResolver secondaryResolver = resolver == null ? new TimeBasedInconsistencyResolver() : resolver;
        serializedStore = new InconsistencyResolvingStore(serializedStore, new ChainedResolver(new VectorClockInconsistencyResolver(), secondaryResolver));
        return serializedStore;
    }

    protected abstract FailureDetector initFailureDetector(ClientConfig var1, Collection<Node> var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FailureDetector getFailureDetector() {
        FailureDetector result = this.failureDetector;
        if (result == null) {
            String clusterXml = this.bootstrapMetadataWithRetries("cluster.xml", this.bootstrapUrls);
            Cluster cluster = clusterMapper.readCluster(new StringReader(clusterXml));
            AbstractStoreClientFactory abstractStoreClientFactory = this;
            synchronized (abstractStoreClientFactory) {
                result = this.failureDetector;
                if (result == null) {
                    this.failureDetector = result = this.initFailureDetector(this.config, cluster.getNodes());
                }
            }
        }
        return result;
    }

    private CompressionStrategy getCompressionStrategy(SerializerDefinition serializerDef) {
        return new CompressionStrategyFactory().get(serializerDef.getCompression());
    }

    public String bootstrapMetadataWithRetries(String key, URI[] urls) {
        int nTries = 0;
        while (nTries++ < this.maxBootstrapRetries) {
            try {
                return this.bootstrapMetadata(key, urls);
            }
            catch (BootstrapFailureException e) {
                if (nTries >= this.maxBootstrapRetries) continue;
                int backOffTime = 5 * nTries;
                logger.warn("Failed to bootstrap will try again after " + backOffTime + " seconds.");
                try {
                    Thread.sleep(backOffTime * 1000);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
        throw new BootstrapFailureException("No available boostrap servers found!");
    }

    public String bootstrapMetadataWithRetries(String key) {
        return this.bootstrapMetadataWithRetries(key, this.bootstrapUrls);
    }

    private String bootstrapMetadata(String key, URI[] urls) {
        for (URI url : urls) {
            try {
                Store<ByteArray, byte[]> remoteStore = this.getStore("metadata", url.getHost(), url.getPort(), this.requestFormatType);
                SerializingStore<String, String> store = SerializingStore.wrap(remoteStore, new StringSerializer("UTF-8"), new StringSerializer("UTF-8"));
                List found = store.get(key);
                if (found.size() != 1) continue;
                return (String)found.get(0).getValue();
            }
            catch (Exception e) {
                logger.warn("Failed to bootstrap from " + url, e);
            }
        }
        throw new BootstrapFailureException("No available bootstrap servers found!");
    }

    public URI[] validateUrls(String[] urls) {
        if (urls == null || urls.length == 0) {
            throw new IllegalArgumentException("Must provide at least one bootstrap URL!");
        }
        URI[] uris = new URI[urls.length];
        for (int i = 0; i < urls.length; ++i) {
            if (urls[i] == null) {
                throw new IllegalArgumentException("Null URL not allowed for bootstrapping!");
            }
            URI uri = null;
            try {
                uri = new URI(urls[i]);
            }
            catch (URISyntaxException e) {
                throw new BootstrapFailureException(e);
            }
            if (uri.getHost() == null || uri.getHost().length() == 0) {
                throw new IllegalArgumentException("Illegal scheme in bootstrap URL, must specify a host, URL: " + uri);
            }
            if (uri.getPort() < 0) {
                throw new IllegalArgumentException("Must specify a port in bootstrap URL, URL: " + uri);
            }
            this.validateUrl(uri);
            uris[i] = uri;
        }
        return uris;
    }

    protected abstract Store<ByteArray, byte[]> getStore(String var1, String var2, int var3, RequestFormatType var4);

    protected abstract int getPort(Node var1);

    protected abstract void validateUrl(URI var1);

    protected ExecutorService getThreadPool() {
        return this.threadPool;
    }

    public long getRoutingTimeoutMs() {
        return this.routingTimeoutMs;
    }

    public SerializerFactory getSerializerFactory() {
        return this.serializerFactory;
    }

    @Override
    public void close() {
        if (this.failureDetector != null) {
            this.failureDetector.destroy();
        }
    }

    private String jmxId() {
        return this.jmxId == 0 ? "" : Integer.toString(this.jmxId);
    }
}

