/*
 * Decompiled with CFR 0.152.
 */
package voldemort;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import voldemort.client.rebalance.RebalanceClusterTool;
import voldemort.cluster.Cluster;
import voldemort.cluster.Node;
import voldemort.store.StoreDefinition;
import voldemort.utils.CmdUtils;
import voldemort.utils.Pair;
import voldemort.utils.Utils;
import voldemort.xml.ClusterMapper;
import voldemort.xml.StoreDefinitionsMapper;

public class VoldemortClusterViewer {
    private final Cluster originalCluster;
    private final StoreDefinition storeDefinition;

    public VoldemortClusterViewer(Cluster originalCluster, StoreDefinition storeDefinition) {
        this.originalCluster = originalCluster;
        this.storeDefinition = storeDefinition;
    }

    public void viewMasterToReplica() {
        this.viewMasterToReplica(this.originalCluster);
    }

    public void viewMasterToReplica(Cluster cluster) {
        RebalanceClusterTool clusterTool = new RebalanceClusterTool(cluster, this.storeDefinition);
        System.out.println(cluster);
        Multimap<Integer, Integer> masterToReplicas = clusterTool.getMasterToReplicas();
        System.out.println("\nReplication: ");
        for (int partition : masterToReplicas.keySet()) {
            Sets.SetView<Integer> replicas = Sets.union(ImmutableSet.of(Integer.valueOf(partition)), ImmutableSet.copyOf(masterToReplicas.get(partition)));
            System.out.println("\t" + partition + " -> " + Joiner.on(", ").join(replicas));
        }
        System.out.println();
    }

    public void compareToCluster(Cluster target) {
        RebalanceClusterTool clusterTool = new RebalanceClusterTool(this.originalCluster, this.storeDefinition);
        Multimap<Node, Integer> multipleCopies = clusterTool.getMultipleCopies(target);
        if (multipleCopies.size() > 0) {
            for (Node n : multipleCopies.keySet()) {
                System.out.println(n + " has multiple copies of data: " + Joiner.on(", ").join(multipleCopies.get(n)));
            }
        } else {
            System.out.println("No multiple copies found.");
        }
        Multimap<Integer, Pair<Integer, Integer>> remappedReplicas = clusterTool.getRemappedReplicas(target);
        System.out.println();
        if (remappedReplicas.size() > 0) {
            for (int partition : remappedReplicas.keySet()) {
                System.out.println("Mapping for partition " + partition + " has changed: ");
                for (Pair<Integer, Integer> pair : remappedReplicas.get(partition)) {
                    System.out.println("\tUsed to have " + partition + " -> " + pair.getFirst() + "; now have: " + partition + " -> " + pair.getSecond());
                }
            }
        } else {
            System.out.println("No replica mappings have changed.");
        }
    }

    public static void main(String[] args) throws IOException {
        Set<String> missing;
        OptionParser parser = new OptionParser();
        parser.accepts("help", "print usage information");
        parser.accepts("stores", "[REQUIRED] path to stores xml config file").withRequiredArg().describedAs("stores.xml");
        parser.accepts("cluster", "[REQUIRED] path to cluster xml config file").withRequiredArg().describedAs("cluster.xml");
        parser.accepts("other-cluster", "Cluster to compare with").withRequiredArg().describedAs("targetCluster.xml");
        parser.accepts("store-name", "[REQUIRED] store name").withRequiredArg().describedAs("store name");
        OptionSet options = parser.parse(args);
        if (options.has("help")) {
            parser.printHelpOn((OutputStream)System.out);
            System.exit(0);
        }
        if ((missing = CmdUtils.missing(options, "store-name", "cluster", "stores")).size() > 0) {
            System.err.println("Missing required arguments: " + Joiner.on(", ").join(missing));
            parser.printHelpOn((OutputStream)System.err);
            System.exit(1);
        }
        String clusterFile = (String)options.valueOf("cluster");
        String storesFile = (String)options.valueOf("stores");
        String storeName = (String)options.valueOf("store-name");
        try {
            Cluster cluster = new ClusterMapper().readCluster(new BufferedReader(new FileReader(clusterFile)));
            List<StoreDefinition> stores = new StoreDefinitionsMapper().readStoreList(new BufferedReader(new FileReader(storesFile)));
            StoreDefinition storeDef = null;
            for (StoreDefinition def : stores) {
                if (!def.getName().equals(storeName)) continue;
                storeDef = def;
            }
            if (storeDef == null) {
                Utils.croak("No store found with name \"" + storeName + "\"");
            }
            VoldemortClusterViewer voldemortClusterViewer = new VoldemortClusterViewer(cluster, storeDef);
            System.out.println("Original cluster: ");
            voldemortClusterViewer.viewMasterToReplica();
            if (options.has("other-cluster")) {
                String otherClusterFile = (String)options.valueOf("other-cluster");
                Cluster otherCluster = new ClusterMapper().readCluster(new BufferedReader(new FileReader(otherClusterFile)));
                System.out.println("New cluster: ");
                voldemortClusterViewer.viewMasterToReplica(otherCluster);
                voldemortClusterViewer.compareToCluster(otherCluster);
            }
        }
        catch (FileNotFoundException e) {
            Utils.croak(e.getMessage());
        }
    }
}

