/*
 * Decompiled with CFR 0.152.
 */
package voldemort;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import voldemort.VoldemortException;
import voldemort.client.ClientConfig;
import voldemort.client.DefaultStoreClient;
import voldemort.client.SocketStoreClientFactory;
import voldemort.client.StoreClientFactory;
import voldemort.cluster.Node;
import voldemort.cluster.failuredetector.FailureDetector;
import voldemort.serialization.SerializationException;
import voldemort.serialization.json.EndOfFileException;
import voldemort.serialization.json.JsonReader;
import voldemort.utils.Utils;
import voldemort.versioning.Versioned;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoldemortClientShell {
    private static final String PROMPT = "> ";
    private static DefaultStoreClient<Object, Object> client;

    public static void main(String[] args) throws Exception {
        if (args.length < 2 || args.length > 3) {
            Utils.croak("USAGE: java VoldemortClientShell store_name bootstrap_url [command_file]");
        }
        String storeName = args[0];
        String bootstrapUrl = args[1];
        String commandsFileName = "";
        BufferedReader fileReader = null;
        BufferedReader inputReader = null;
        try {
            if (args.length == 3) {
                commandsFileName = args[2];
                fileReader = new BufferedReader(new FileReader(commandsFileName));
            }
            inputReader = new BufferedReader(new InputStreamReader(System.in));
        }
        catch (IOException e) {
            Utils.croak("Failure to open input stream: " + e.getMessage());
        }
        ClientConfig clientConfig = new ClientConfig().setBootstrapUrls(bootstrapUrl);
        SocketStoreClientFactory factory = new SocketStoreClientFactory(clientConfig);
        try {
            client = (DefaultStoreClient)factory.getStoreClient(storeName);
        }
        catch (Exception e) {
            Utils.croak("Could not connect to server: " + e.getMessage());
        }
        System.out.println("Established connection to " + storeName + " via " + bootstrapUrl);
        System.out.print(PROMPT);
        if (fileReader != null) {
            VoldemortClientShell.processCommands(factory, fileReader, true);
            fileReader.close();
        }
        VoldemortClientShell.processCommands(factory, inputReader, false);
    }

    private static void processCommands(StoreClientFactory factory, BufferedReader reader, boolean printCommands) throws IOException {
        String line = reader.readLine();
        while (line != null) {
            if (!line.trim().equals("")) {
                if (printCommands) {
                    System.out.println(line);
                }
                try {
                    JsonReader jsonReader;
                    if (line.toLowerCase().startsWith("put")) {
                        jsonReader = new JsonReader(new StringReader(line.substring("put".length())));
                        client.put(VoldemortClientShell.tightenNumericTypes(jsonReader.read()), VoldemortClientShell.tightenNumericTypes(jsonReader.read()));
                    } else if (line.toLowerCase().startsWith("getall")) {
                        jsonReader = new JsonReader(new StringReader(line.substring("getall".length())));
                        ArrayList<Object> keys = new ArrayList<Object>();
                        try {
                            while (true) {
                                keys.add(jsonReader.read());
                            }
                        }
                        catch (EndOfFileException e) {
                            Map<Object, Versioned<Object>> vals = client.getAll(keys);
                            if (vals.size() > 0) {
                                for (Map.Entry<Object, Versioned<Object>> entry : vals.entrySet()) {
                                    System.out.print(entry.getKey());
                                    System.out.print(" => ");
                                    VoldemortClientShell.printVersioned(entry.getValue());
                                }
                            } else {
                                System.out.println("null");
                            }
                        }
                    } else if (line.toLowerCase().startsWith("get")) {
                        jsonReader = new JsonReader(new StringReader(line.substring("get".length())));
                        VoldemortClientShell.printVersioned(client.get(VoldemortClientShell.tightenNumericTypes(jsonReader.read())));
                    } else if (line.toLowerCase().startsWith("delete")) {
                        jsonReader = new JsonReader(new StringReader(line.substring("delete".length())));
                        client.delete(VoldemortClientShell.tightenNumericTypes(jsonReader.read()));
                    } else if (line.startsWith("preflist")) {
                        jsonReader = new JsonReader(new StringReader(line.substring("preflist".length())));
                        Object key = VoldemortClientShell.tightenNumericTypes(jsonReader.read());
                        VoldemortClientShell.printNodeList(client.getResponsibleNodes(key), factory.getFailureDetector());
                    } else if (line.startsWith("help")) {
                        System.out.println("Commands:");
                        System.out.println("put key value -- Associate the given value with the key.");
                        System.out.println("get key -- Retrieve the value associated with the key.");
                        System.out.println("getall key -- Retrieve the value(s) associated with the key.");
                        System.out.println("delete key -- Remove all values associated with the key.");
                        System.out.println("preflist key -- Get node preference list for given key.");
                        System.out.println("help -- Print this message.");
                        System.out.println("exit -- Exit from this shell.");
                        System.out.println();
                    } else if (line.startsWith("quit") || line.startsWith("exit")) {
                        System.out.println("k k thx bye.");
                        System.exit(0);
                    } else {
                        System.err.println("Invalid command.");
                    }
                }
                catch (EndOfFileException e) {
                    System.err.println("Expected additional token.");
                }
                catch (SerializationException e) {
                    System.err.print("Error serializing values: ");
                    e.printStackTrace();
                }
                catch (VoldemortException e) {
                    System.err.println("Exception thrown during operation.");
                    e.printStackTrace(System.err);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    System.err.println("Invalid command.");
                }
                catch (Exception e) {
                    System.err.println("Unexpected error:");
                    e.printStackTrace(System.err);
                }
                System.out.print(PROMPT);
            }
            line = reader.readLine();
        }
    }

    private static void printNodeList(List<Node> nodes, FailureDetector failureDetector) {
        if (nodes.size() > 0) {
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = nodes.get(i);
                System.out.println("Node " + node.getId());
                System.out.println("host:  " + node.getHost());
                System.out.println("port: " + node.getSocketPort());
                System.out.println("available: " + (failureDetector.isAvailable(node) ? "yes" : "no"));
                System.out.println("last checked: " + failureDetector.getLastChecked(node) + " ms ago");
                System.out.println();
            }
        }
    }

    private static void printVersioned(Versioned<Object> v) {
        if (v == null) {
            System.out.println("null");
        } else {
            System.out.print(v.getVersion());
            System.out.print(": ");
            VoldemortClientShell.printObject(v.getValue());
            System.out.println();
        }
    }

    private static void printObject(Object o) {
        if (o == null) {
            System.out.print("null");
        } else if (o instanceof String) {
            System.out.print('\"');
            System.out.print(o);
            System.out.print('\"');
        } else if (o instanceof Date) {
            DateFormat df = DateFormat.getDateTimeInstance(3, 3);
            System.out.print("'");
            System.out.print(df.format((Date)o));
            System.out.print("'");
        } else if (o instanceof List) {
            List l = (List)o;
            System.out.print("[");
            for (Object obj : l) {
                VoldemortClientShell.printObject(obj);
            }
            System.out.print("]");
        } else if (o instanceof Map) {
            Map m = (Map)o;
            System.out.print('{');
            for (String s : m.keySet()) {
                VoldemortClientShell.printObject(s);
                System.out.print(':');
                VoldemortClientShell.printObject(m.get(s));
                System.out.print(", ");
            }
            System.out.print('}');
        } else {
            System.out.print(o);
        }
    }

    private static Object tightenNumericTypes(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof List) {
            List l = (List)o;
            for (int i = 0; i < l.size(); ++i) {
                l.set(i, VoldemortClientShell.tightenNumericTypes(l.get(i)));
            }
            return l;
        }
        if (o instanceof Map) {
            Map m = (Map)o;
            for (Map.Entry entry : m.entrySet()) {
                m.put(entry.getKey(), VoldemortClientShell.tightenNumericTypes(entry.getValue()));
            }
            return m;
        }
        if (o instanceof Number) {
            Number n = (Number)o;
            if (o instanceof Integer) {
                if (n.intValue() < 127) {
                    return n.byteValue();
                }
                if (n.intValue() < Short.MAX_VALUE) {
                    return n.shortValue();
                }
                return n;
            }
            if (o instanceof Double) {
                if (n.doubleValue() < 3.4028234663852886E38) {
                    return Float.valueOf(n.floatValue());
                }
                return n;
            }
            throw new RuntimeException("Unsupported numeric type: " + o.getClass());
        }
        return o;
    }
}

