/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.StringByteIterator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import voldemort.client.ClientConfig;
import voldemort.client.SocketStoreClientFactory;
import voldemort.client.StoreClient;
import voldemort.versioning.VectorClock;
import voldemort.versioning.Versioned;

public class VoldemortClient
extends DB {
    private StoreClient<String, HashMap<String, String>> storeClient;
    private SocketStoreClientFactory socketFactory;
    private String storeName;
    private final Logger logger = Logger.getLogger(VoldemortClient.class);
    public static final int OK = 0;
    public static final int ERROR = -1;
    public static final int NOT_FOUND = -2;

    @Override
    public void init() throws DBException {
        ClientConfig clientConfig = new ClientConfig(this.getProperties());
        this.socketFactory = new SocketStoreClientFactory(clientConfig);
        this.storeName = this.getProperties().getProperty("store_name", "usertable");
        this.storeClient = this.socketFactory.getStoreClient(this.storeName);
        if (this.storeClient == null) {
            throw new DBException("Unable to instantiate store client");
        }
    }

    @Override
    public void cleanup() throws DBException {
        this.socketFactory.close();
    }

    @Override
    public int delete(String table, String key) {
        if (this.checkStore(table) == -1) {
            return -1;
        }
        if (this.storeClient.delete(key)) {
            return 0;
        }
        return -1;
    }

    @Override
    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        if (this.checkStore(table) == -1) {
            return -1;
        }
        this.storeClient.put(key, StringByteIterator.getStringMap(values));
        return 0;
    }

    @Override
    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        if (this.checkStore(table) == -1) {
            return -1;
        }
        Versioned<HashMap<String, String>> versionedValue = this.storeClient.get(key);
        if (versionedValue == null) {
            return -2;
        }
        if (fields != null) {
            for (String field : fields) {
                String val = versionedValue.getValue().get(field);
                if (val == null) continue;
                result.put(field, new StringByteIterator(val));
            }
        } else {
            StringByteIterator.putAllAsByteIterators(result, (Map<String, String>)versionedValue.getValue());
        }
        return 0;
    }

    @Override
    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        this.logger.warn("Voldemort does not support Scan semantics");
        return 0;
    }

    @Override
    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        VectorClock version;
        if (this.checkStore(table) == -1) {
            return -1;
        }
        Versioned<HashMap<String, String>> versionedValue = this.storeClient.get(key);
        HashMap<String, String> value = new HashMap<String, String>();
        if (versionedValue != null) {
            version = ((VectorClock)versionedValue.getVersion()).incremented(0, 1L);
            value = versionedValue.getValue();
            for (Map.Entry<String, ByteIterator> entry : values.entrySet()) {
                value.put(entry.getKey(), entry.getValue().toString());
            }
        } else {
            version = new VectorClock();
            StringByteIterator.putAllAsStrings(value, values);
        }
        this.storeClient.put(key, Versioned.value(value, version));
        return 0;
    }

    private int checkStore(String table) {
        if (table.compareTo(this.storeName) != 0) {
            try {
                this.storeClient = this.socketFactory.getStoreClient(table);
                if (this.storeClient == null) {
                    this.logger.error("Could not instantiate storeclient for " + table);
                    return -1;
                }
                this.storeName = table;
            }
            catch (Exception e) {
                return -1;
            }
        }
        return 0;
    }
}

