/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb;

import java.util.Properties;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^([0-9\\.]*)([kKmMbBtT])*$");
    private static final Random rand = new Random();
    private static final ThreadLocal<Random> rng = new ThreadLocal();
    public static final int FNV_offset_basis_32 = -2128831035;
    public static final int FNV_prime_32 = 16777619;
    public static final long FNV_offset_basis_64 = -3750763034362895579L;
    public static final long FNV_prime_64 = 1099511628211L;

    public static Random random() {
        Random ret = rng.get();
        if (ret == null) {
            ret = new Random(rand.nextLong());
            rng.set(ret);
        }
        return ret;
    }

    public static String ASCIIString(int length) {
        int interval = 95;
        byte[] buf = new byte[length];
        Utils.random().nextBytes(buf);
        for (int i = 0; i < length; ++i) {
            buf[i] = buf[i] < 0 ? (byte)(-buf[i] % interval + 32) : (byte)(buf[i] % interval + 32);
        }
        return new String(buf);
    }

    public static long hash(long val) {
        return Utils.FNVhash64(val);
    }

    public static int FNVhash32(int val) {
        int hashval = -2128831035;
        for (int i = 0; i < 4; ++i) {
            int octet = val & 0xFF;
            val >>= 8;
            hashval ^= octet;
            hashval *= 16777619;
        }
        return Math.abs(hashval);
    }

    public static long FNVhash64(long val) {
        long hashval = -3750763034362895579L;
        for (int i = 0; i < 8; ++i) {
            long octet = val & 0xFFL;
            val >>= 8;
            hashval ^= octet;
            hashval *= 1099511628211L;
        }
        return Math.abs(hashval);
    }

    public static boolean getPropertyBool(Properties _p, String key, Boolean defaultValue) {
        return _p != null ? Boolean.parseBoolean(_p.getProperty(key, defaultValue.toString())) : defaultValue;
    }

    public static int getPropertyInt(Properties _p, String key, int defaultValue) {
        return (int)Utils.getPropertyDouble(_p, key, defaultValue);
    }

    public static long getPropertyLong(Properties _p, String key, long defaultValue) {
        return (long)Utils.getPropertyDouble(_p, key, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double getPropertyDouble(Properties _p, String key, double defaultValue) {
        double result = defaultValue;
        String val = null;
        if (_p != null && (val = _p.getProperty(key)) != null) {
            result = -1.0;
            try {
                Matcher matcher = NUMBER_PATTERN.matcher(val.trim());
                if (matcher.matches() && matcher.groupCount() == 2) {
                    double number = Double.valueOf(matcher.group(1));
                    long multiplier = 1L;
                    if (matcher.group(2) != null) {
                        switch (matcher.group(2).toLowerCase().charAt(0)) {
                            case 't': {
                                multiplier *= 1000L;
                            }
                            case 'b': {
                                multiplier *= 1000L;
                            }
                            case 'm': {
                                multiplier *= 1000L;
                            }
                            case 'k': {
                                multiplier *= 1000L;
                            }
                        }
                    }
                    result = number * (double)multiplier;
                }
            }
            catch (Throwable e) {
                result = -1.0;
            }
            finally {
                if (result == -1.0) {
                    result = defaultValue;
                    System.err.println("Invalid value '" + val + "' for property '" + key + "' assuming default.");
                }
            }
        }
        return result;
    }

    public static void main(String[] args) {
        Properties _p = new Properties();
        _p.setProperty("number", "12.234k");
        System.out.println(Utils.getPropertyDouble(_p, "number", 3.0));
        System.out.println(Utils.getPropertyInt(_p, "number", 3));
        System.out.println(Utils.getPropertyLong(_p, "number", 3L));
    }
}

