/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.measurements.Measurements;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class DBWrapper
extends DB {
    DB _db;
    Measurements _measurements;

    public DBWrapper(DB db) {
        this._db = db;
        this._measurements = Measurements.getMeasurements();
    }

    @Override
    public void setProperties(Properties p) {
        this._db.setProperties(p);
    }

    @Override
    public Properties getProperties() {
        return this._db.getProperties();
    }

    @Override
    public void init() throws DBException {
        this._db.init();
    }

    @Override
    public void cleanup() throws DBException {
        long st = System.nanoTime();
        this._db.cleanup();
        long en = System.nanoTime();
        this._measurements.measure("CLEANUP", (int)((en - st) / 1000L));
    }

    @Override
    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        long st = System.nanoTime();
        int res = this._db.read(table, key, fields, result);
        long en = System.nanoTime();
        this._measurements.measure("READ", (int)((en - st) / 1000L));
        this._measurements.reportReturnCode("READ", res);
        return res;
    }

    @Override
    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        long st = System.nanoTime();
        int res = this._db.scan(table, startkey, recordcount, fields, result);
        long en = System.nanoTime();
        this._measurements.measure("SCAN", (int)((en - st) / 1000L));
        this._measurements.reportReturnCode("SCAN", res);
        return res;
    }

    @Override
    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        long st = System.nanoTime();
        int res = this._db.update(table, key, values);
        long en = System.nanoTime();
        this._measurements.measure("UPDATE", (int)((en - st) / 1000L));
        this._measurements.reportReturnCode("UPDATE", res);
        return res;
    }

    @Override
    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        long st = System.nanoTime();
        int res = this._db.insert(table, key, values);
        long en = System.nanoTime();
        this._measurements.measure("INSERT", (int)((en - st) / 1000L));
        this._measurements.reportReturnCode("INSERT", res);
        return res;
    }

    @Override
    public int delete(String table, String key) {
        long st = System.nanoTime();
        int res = this._db.delete(table, key);
        long en = System.nanoTime();
        this._measurements.measure("DELETE", (int)((en - st) / 1000L));
        this._measurements.reportReturnCode("DELETE", res);
        return res;
    }
}

