/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JedisPool
extends Pool<Jedis> {
    public JedisPool(GenericObjectPool.Config poolConfig, String host) {
        this(poolConfig, host, 6379, 2000, null);
    }

    public JedisPool(String host, int port) {
        super(new GenericObjectPool.Config(), new JedisFactory(host, port, 2000, null));
    }

    public JedisPool(GenericObjectPool.Config poolConfig, String host, int port, int timeout, String password) {
        super(poolConfig, new JedisFactory(host, port, timeout, password));
    }

    public JedisPool(GenericObjectPool.Config poolConfig, String host, int port) {
        this(poolConfig, host, port, 2000, null);
    }

    public JedisPool(GenericObjectPool.Config poolConfig, String host, int port, int timeout) {
        this(poolConfig, host, port, timeout, null);
    }

    private static class JedisFactory
    extends BasePoolableObjectFactory {
        private final String host;
        private final int port;
        private final int timeout;
        private final String password;

        public JedisFactory(String host, int port, int timeout, String password) {
            this.host = host;
            this.port = port;
            this.timeout = timeout > 0 ? timeout : -1;
            this.password = password;
        }

        public Object makeObject() throws Exception {
            Jedis jedis = this.timeout > 0 ? new Jedis(this.host, this.port, this.timeout) : new Jedis(this.host, this.port);
            jedis.connect();
            if (null != this.password) {
                jedis.auth(this.password);
            }
            return jedis;
        }

        public void destroyObject(Object obj) throws Exception {
            Jedis jedis;
            if (obj instanceof Jedis && (jedis = (Jedis)obj).isConnected()) {
                try {
                    try {
                        jedis.quit();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    jedis.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        public boolean validateObject(Object obj) {
            if (obj instanceof Jedis) {
                Jedis jedis = (Jedis)obj;
                try {
                    return jedis.isConnected() && jedis.ping().equals("PONG");
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
    }
}

