/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.generator;

import com.yahoo.ycsb.Utils;
import com.yahoo.ycsb.generator.LongGenerator;
import java.util.Random;

public class HotspotLongGenerator
extends LongGenerator {
    private final long lowerBound;
    private final long upperBound;
    private final long hotInterval;
    private final long coldInterval;
    private final double hotsetFraction;
    private final double hotOpnFraction;

    public HotspotLongGenerator(long lowerBound, long upperBound, double hotsetFraction, double hotOpnFraction) {
        if (hotsetFraction < 0.0 || hotsetFraction > 1.0) {
            System.err.println("Hotset fraction out of range. Setting to 0.0");
            hotsetFraction = 0.0;
        }
        if (hotOpnFraction < 0.0 || hotOpnFraction > 1.0) {
            System.err.println("Hot operation fraction out of range. Setting to 0.0");
            hotOpnFraction = 0.0;
        }
        if (lowerBound > upperBound) {
            System.err.println("Upper bound of Hotspot generator smaller than the lower bound. Swapping the values.");
            long temp = lowerBound;
            lowerBound = upperBound;
            upperBound = temp;
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.hotsetFraction = hotsetFraction;
        long interval = upperBound - lowerBound + 1L;
        this.hotInterval = (int)((double)interval * hotsetFraction);
        this.coldInterval = interval - this.hotInterval;
        this.hotOpnFraction = hotOpnFraction;
    }

    @Override
    public long nextLong() {
        long value = 0L;
        Random random = Utils.random();
        value = random.nextDouble() < this.hotOpnFraction ? this.lowerBound + random.nextLong() % this.hotInterval + 1L : this.lowerBound + this.hotInterval + random.nextLong() % this.coldInterval + 1L;
        this.setLastLong(value);
        return value;
    }

    public long getLowerBound() {
        return this.lowerBound;
    }

    public long getUpperBound() {
        return this.upperBound;
    }

    public double getHotsetFraction() {
        return this.hotsetFraction;
    }

    public double getHotOpnFraction() {
        return this.hotOpnFraction;
    }

    @Override
    public double mean() {
        return this.hotOpnFraction * ((double)this.lowerBound + (double)this.hotInterval / 2.0) + (1.0 - this.hotOpnFraction) * ((double)(this.lowerBound + this.hotInterval) + (double)this.coldInterval / 2.0);
    }
}

