/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.StringByteIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import redis.clients.jedis.Jedis;

public class RedisClient
extends DB {
    private Jedis jedis;
    public static final String HOST_PROPERTY = "redis.host";
    public static final String PORT_PROPERTY = "redis.port";
    public static final String PASSWORD_PROPERTY = "redis.password";
    public static final String INDEX_KEY = "_indices";

    @Override
    public void init() throws DBException {
        Properties props = this.getProperties();
        String portString = props.getProperty(PORT_PROPERTY);
        int port = portString != null ? Integer.parseInt(portString) : 6379;
        String host = props.getProperty(HOST_PROPERTY);
        this.jedis = new Jedis(host, port);
        this.jedis.connect();
        String password = props.getProperty(PASSWORD_PROPERTY);
        if (password != null) {
            this.jedis.auth(password);
        }
    }

    @Override
    public void cleanup() throws DBException {
        this.jedis.disconnect();
    }

    private double hash(String key) {
        return key.hashCode();
    }

    @Override
    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        if (fields == null) {
            StringByteIterator.putAllAsByteIterators(result, this.jedis.hgetAll(key));
        } else {
            String[] fieldArray = fields.toArray(new String[fields.size()]);
            List<String> values = this.jedis.hmget(key, fieldArray);
            Iterator<String> fieldIterator = fields.iterator();
            Iterator<String> valueIterator = values.iterator();
            while (fieldIterator.hasNext() && valueIterator.hasNext()) {
                result.put(fieldIterator.next(), new StringByteIterator(valueIterator.next()));
            }
            assert (!fieldIterator.hasNext() && !valueIterator.hasNext());
        }
        return result.isEmpty() ? 1 : 0;
    }

    @Override
    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        if (this.jedis.hmset(key, StringByteIterator.getStringMap(values)).equals("OK")) {
            this.jedis.zadd(INDEX_KEY, this.hash(key), key);
            return 0;
        }
        return 1;
    }

    @Override
    public int delete(String table, String key) {
        return this.jedis.del(key) == 0L && this.jedis.zrem(INDEX_KEY, key) == 0L ? 1 : 0;
    }

    @Override
    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        return this.jedis.hmset(key, StringByteIterator.getStringMap(values)).equals("OK") ? 0 : 1;
    }

    @Override
    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        Set<String> keys = this.jedis.zrangeByScore(INDEX_KEY, this.hash(startkey), Double.POSITIVE_INFINITY, 0, recordcount);
        for (String key : keys) {
            HashMap<String, ByteIterator> values = new HashMap<String, ByteIterator>();
            this.read(table, key, fields, values);
            result.add(values);
        }
        return 0;
    }
}

