/*
 * Decompiled with CFR 0.152.
 */
package com.mapr.stats;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpperQuantile {
    private static Logger log = LoggerFactory.getLogger(UpperQuantile.class);
    private int n = 0;
    private Heap biggest;
    private double[] sorted;
    private boolean isSorted;
    private int recommendedHeapSize = 0;
    private boolean resizeHeap = false;

    public UpperQuantile(int maxRetained) {
        this.biggest = new Heap(maxRetained);
        this.biggest.count = 0;
        this.isSorted = false;
    }

    public void add(double x) {
        this.sorted = null;
        this.biggest.add(x);
        ++this.n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double[] getQuantiles(double[] requestedQuantiles) {
        double[] quantileValues = new double[requestedQuantiles.length];
        Heap heap = this.biggest;
        synchronized (heap) {
            if (!this.isSorted) {
                Arrays.sort(this.biggest.data, 1, this.biggest.data.length);
                this.isSorted = true;
            }
            for (int i = 0; i < quantileValues.length; ++i) {
                quantileValues[i] = this.quantile(requestedQuantiles[i]);
            }
        }
        return quantileValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double quantile(double q) {
        double quantileValue = Double.NEGATIVE_INFINITY;
        Heap heap = this.biggest;
        synchronized (heap) {
            if (this.biggest.size() <= 0) {
                System.out.println("Can't get quantile with no data");
                return quantileValue;
            }
            if (q < 0.0 || q > 1.0) {
                System.out.println("Q must be in the range of [0,1] -> " + q);
                return quantileValue;
            }
            double item = (double)(this.n - 1) * (1.0 - q);
            if (item > (double)(this.biggest.size() - 1)) {
                System.out.println("Can't get %" + 100.0 * q + " %-ile, only retained " + this.biggest.size() + " / " + this.n + " items. Needed atleast " + Math.ceil(item) + " samples");
                if (1.1 * item > (double)this.recommendedHeapSize) {
                    this.recommendedHeapSize = (int)(1.1 * item);
                    this.resizeHeap = true;
                }
                return quantileValue;
            }
            item = (double)this.biggest.size() - item;
            if (!this.isSorted) {
                Arrays.sort(this.biggest.data, 1, this.biggest.data.length);
                this.isSorted = true;
            }
            int i = (int)Math.floor(item);
            quantileValue = this.biggest.data[i];
        }
        return quantileValue;
    }

    public void clear() {
        if (this.resizeHeap) {
            this.biggest = new Heap(this.recommendedHeapSize);
            this.resizeHeap = false;
        } else {
            this.biggest.clear();
        }
        this.n = 0;
        this.isSorted = false;
    }

    public void validate() {
        this.biggest.validate(1);
    }

    public void print() {
        this.biggest.print(1);
    }

    private static final class Heap {
        private int count = 0;
        private double[] data;

        private Heap(int size) {
            Preconditions.checkArgument(size > 0);
            this.data = new double[size + 1];
        }

        public void clear() {
            this.count = 0;
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = 0.0;
            }
        }

        public int size() {
            return this.count;
        }

        private void add(double x) {
            if (this.count < this.data.length - 1) {
                ++this.count;
                this.data[this.count] = x;
                this.bubble(this.count);
            } else if (x > this.data[1]) {
                this.pop();
                this.add(x);
            }
        }

        private void bubble(int i) {
            int parent;
            if (i > 1 && this.data[i] < this.data[parent = i / 2]) {
                double tmp = this.data[i];
                this.data[i] = this.data[parent];
                this.data[parent] = tmp;
                this.bubble(parent);
            }
        }

        private double pop() {
            if (this.count <= 0) {
                return -1.0;
            }
            double r = this.data[1];
            this.pop(1);
            return r;
        }

        private double peek() {
            return this.data[1];
        }

        private void pop(int i) {
            int left = 2 * i;
            if (left <= this.count) {
                int right = left + 1;
                if (right <= this.count) {
                    if (this.data[left] < this.data[right]) {
                        this.data[i] = this.data[left];
                        this.pop(left);
                    } else {
                        this.data[i] = this.data[right];
                        this.pop(right);
                    }
                } else {
                    this.data[i] = this.data[left];
                    this.pop(left);
                }
            } else if (i < this.count) {
                this.data[i] = this.data[this.count];
                --this.count;
                this.bubble(i);
            } else {
                --this.count;
            }
        }

        private void rebalance(int base) {
            int right;
            int left = 2 * base;
            if (left <= this.count && this.data[base] > this.data[left]) {
                double tmp = this.data[left];
                this.data[left] = this.data[base];
                this.data[base] = tmp;
                this.rebalance(left);
            }
            if ((right = left + 1) <= this.count && this.data[base] > this.data[right]) {
                double tmp = this.data[right];
                this.data[right] = this.data[base];
                this.data[base] = tmp;
                this.rebalance(right);
            }
        }

        private boolean validate(int i) {
            if (i >= this.count) {
                return true;
            }
            int left = 2 * i;
            if (left <= this.count) {
                if (this.data[i] > this.data[left]) {
                    log.warn("Data at {} > {}", i, (Object)left);
                    log.warn("Data at {} > {}", this.data[i], (Object)this.data[left]);
                    return false;
                }
                if (!this.validate(left)) {
                    return false;
                }
                int right = left + 1;
                if (right <= this.count) {
                    if (this.data[i] > this.data[right]) {
                        log.warn("Data at {} > {}", i, (Object)right);
                        log.warn("Data at {} > {}", this.data[i], (Object)this.data[right]);
                        return false;
                    }
                    if (!this.validate(right)) {
                        return false;
                    }
                }
            }
            return true;
        }

        private void print(int i) {
            if (i <= this.count) {
                System.out.printf("%4d, %4d ", i, 31 - Integer.numberOfLeadingZeros(i));
                this.indent(31 - Integer.numberOfLeadingZeros(i));
                System.out.printf("%.3f\n", this.data[i]);
                this.print(2 * i);
                this.print(2 * i + 1);
            }
        }

        private void indent(int indent) {
            for (int j = 0; j < indent; ++j) {
                System.out.printf("|  ", new Object[0]);
            }
        }
    }
}

