/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.workloads;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.RandomByteIterator;
import com.yahoo.ycsb.Utils;
import com.yahoo.ycsb.Workload;
import com.yahoo.ycsb.WorkloadException;
import com.yahoo.ycsb.generator.ConstantIntegerGenerator;
import com.yahoo.ycsb.generator.DiscreteGenerator;
import com.yahoo.ycsb.generator.ExponentialLongGenerator;
import com.yahoo.ycsb.generator.Generator;
import com.yahoo.ycsb.generator.HistogramGenerator;
import com.yahoo.ycsb.generator.HotspotLongGenerator;
import com.yahoo.ycsb.generator.IntegerGenerator;
import com.yahoo.ycsb.generator.LongCounterGenerator;
import com.yahoo.ycsb.generator.LongGenerator;
import com.yahoo.ycsb.generator.ScrambledZipfianGenerator;
import com.yahoo.ycsb.generator.SkewedLatestGenerator;
import com.yahoo.ycsb.generator.UniformIntegerGenerator;
import com.yahoo.ycsb.generator.UniformLongGenerator;
import com.yahoo.ycsb.generator.ZipfianGenerator;
import com.yahoo.ycsb.measurements.Measurements;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.Vector;

public class CoreWorkload
extends Workload {
    public static final String TABLENAME_PROPERTY = "table";
    public static final String TABLENAME_PROPERTY_DEFAULT = "usertable";
    public static String table;
    public static final String KEYPREFIX_PROPERTY = "keyprefix";
    public static final String KEYPREFIX_PROPERTY_DEFAULT = "user";
    public static final String FIELD_COUNT_PROPERTY = "fieldcount";
    public static final int FIELD_COUNT_PROPERTY_DEFAULT = 10;
    int fieldcount;
    public static final String FIELD_LENGTH_DISTRIBUTION_PROPERTY = "fieldlengthdistribution";
    public static final String FIELD_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT = "constant";
    public static final String FIELD_LENGTH_PROPERTY = "fieldlength";
    public static final int FIELD_LENGTH_PROPERTY_DEFAULT = 100;
    public static final String FIELD_LENGTH_HISTOGRAM_FILE_PROPERTY = "fieldlengthhistogram";
    public static final String FIELD_LENGTH_HISTOGRAM_FILE_PROPERTY_DEFAULT = "hist.txt";
    IntegerGenerator fieldlengthgenerator;
    public static final String READ_ALL_FIELDS_PROPERTY = "readallfields";
    public static final boolean READ_ALL_FIELDS_PROPERTY_DEFAULT = true;
    boolean readallfields;
    public static final String WRITE_ALL_FIELDS_PROPERTY = "writeallfields";
    public static final boolean WRITE_ALL_FIELDS_PROPERTY_DEFAULT = false;
    boolean writeallfields;
    public static final String READ_PROPORTION_PROPERTY = "readproportion";
    public static final double READ_PROPORTION_PROPERTY_DEFAULT = 0.95;
    public static final String UPDATE_PROPORTION_PROPERTY = "updateproportion";
    public static final double UPDATE_PROPORTION_PROPERTY_DEFAULT = 0.05;
    public static final String INSERT_PROPORTION_PROPERTY = "insertproportion";
    public static final double INSERT_PROPORTION_PROPERTY_DEFAULT = 0.0;
    public static final String SCAN_PROPORTION_PROPERTY = "scanproportion";
    public static final double SCAN_PROPORTION_PROPERTY_DEFAULT = 0.0;
    public static final String READMODIFYWRITE_PROPORTION_PROPERTY = "readmodifywriteproportion";
    public static final double READMODIFYWRITE_PROPORTION_PROPERTY_DEFAULT = 0.0;
    public static final String REQUEST_DISTRIBUTION_PROPERTY = "requestdistribution";
    public static final String REQUEST_DISTRIBUTION_PROPERTY_DEFAULT = "uniform";
    public static final String MAX_SCAN_LENGTH_PROPERTY = "maxscanlength";
    public static final String MIN_SCAN_LENGTH_PROPERTY = "minscanlength";
    public static final int MAX_SCAN_LENGTH_PROPERTY_DEFAULT = 1000;
    public static final int MIN_SCAN_LENGTH_PROPERTY_DEFAULT = 1;
    public static final String SCAN_LENGTH_DISTRIBUTION_PROPERTY = "scanlengthdistribution";
    public static final String SCAN_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT = "uniform";
    public static final String INSERT_ORDER_PROPERTY = "insertorder";
    public static final String INSERT_ORDER_PROPERTY_DEFAULT = "hashed";
    public static final String HOTSPOT_DATA_FRACTION = "hotspotdatafraction";
    public static final double HOTSPOT_DATA_FRACTION_DEFAULT = 0.2;
    public static final String HOTSPOT_OPN_FRACTION = "hotspotopnfraction";
    public static final double HOTSPOT_OPN_FRACTION_DEFAULT = 0.8;
    LongGenerator keysequence;
    DiscreteGenerator operationchooser;
    LongGenerator keychooser;
    Generator fieldchooser;
    LongCounterGenerator transactioninsertkeysequence;
    IntegerGenerator scanlength;
    boolean orderedinserts;
    long recordcount;
    private String keyPrefix;

    protected static IntegerGenerator getFieldLengthGenerator(Properties p) throws WorkloadException {
        IntegerGenerator fieldlengthgenerator;
        String fieldlengthdistribution = p.getProperty(FIELD_LENGTH_DISTRIBUTION_PROPERTY, FIELD_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT);
        int fieldlength = Utils.getPropertyInt(p, FIELD_LENGTH_PROPERTY, 100);
        String fieldlengthhistogram = p.getProperty(FIELD_LENGTH_HISTOGRAM_FILE_PROPERTY, FIELD_LENGTH_HISTOGRAM_FILE_PROPERTY_DEFAULT);
        if (fieldlengthdistribution.compareTo(FIELD_LENGTH_DISTRIBUTION_PROPERTY_DEFAULT) == 0) {
            fieldlengthgenerator = new ConstantIntegerGenerator(fieldlength);
        } else if (fieldlengthdistribution.compareTo("uniform") == 0) {
            fieldlengthgenerator = new UniformIntegerGenerator(1, fieldlength);
        } else if (fieldlengthdistribution.compareTo("zipfian") == 0) {
            fieldlengthgenerator = new ZipfianGenerator(1L, fieldlength);
        } else if (fieldlengthdistribution.compareTo("histogram") == 0) {
            try {
                fieldlengthgenerator = new HistogramGenerator(fieldlengthhistogram);
            }
            catch (IOException e) {
                throw new WorkloadException("Couldn't read field length histogram file: " + fieldlengthhistogram, e);
            }
        } else {
            throw new WorkloadException("Unknown field length distribution \"" + fieldlengthdistribution + "\"");
        }
        return fieldlengthgenerator;
    }

    @Override
    public void init(Properties p) throws WorkloadException {
        table = p.getProperty(TABLENAME_PROPERTY, TABLENAME_PROPERTY_DEFAULT);
        this.keyPrefix = p.getProperty(KEYPREFIX_PROPERTY, KEYPREFIX_PROPERTY_DEFAULT);
        this.fieldcount = Utils.getPropertyInt(p, FIELD_COUNT_PROPERTY, 10);
        this.fieldlengthgenerator = CoreWorkload.getFieldLengthGenerator(p);
        double readproportion = Utils.getPropertyDouble(p, READ_PROPORTION_PROPERTY, 0.95);
        double updateproportion = Utils.getPropertyDouble(p, UPDATE_PROPORTION_PROPERTY, 0.05);
        double insertproportion = Utils.getPropertyDouble(p, INSERT_PROPORTION_PROPERTY, 0.0);
        double scanproportion = Utils.getPropertyDouble(p, SCAN_PROPORTION_PROPERTY, 0.0);
        double readmodifywriteproportion = Utils.getPropertyDouble(p, READMODIFYWRITE_PROPORTION_PROPERTY, 0.0);
        this.recordcount = Utils.getPropertyLong(p, "recordcount", 0L);
        String requestdistrib = p.getProperty(REQUEST_DISTRIBUTION_PROPERTY, "uniform");
        int maxscanlength = Utils.getPropertyInt(p, MAX_SCAN_LENGTH_PROPERTY, 1000);
        int minscanlength = Utils.getPropertyInt(p, MIN_SCAN_LENGTH_PROPERTY, 1);
        String scanlengthdistrib = p.getProperty(SCAN_LENGTH_DISTRIBUTION_PROPERTY, "uniform");
        long insertstart = Utils.getPropertyLong(p, "insertstart", 0L);
        this.readallfields = Utils.getPropertyBool(p, READ_ALL_FIELDS_PROPERTY, true);
        this.writeallfields = Utils.getPropertyBool(p, WRITE_ALL_FIELDS_PROPERTY, false);
        if (p.getProperty(INSERT_ORDER_PROPERTY, INSERT_ORDER_PROPERTY_DEFAULT).compareTo(INSERT_ORDER_PROPERTY_DEFAULT) == 0) {
            this.orderedinserts = false;
        } else if (requestdistrib.compareTo("exponential") == 0) {
            double percentile = Utils.getPropertyDouble(p, "exponential.percentile", 95.0);
            double frac = Utils.getPropertyDouble(p, "exponential.frac", 0.8571428571);
            this.keychooser = new ExponentialLongGenerator(percentile, (double)this.recordcount * frac);
        } else {
            this.orderedinserts = true;
        }
        this.keysequence = new LongCounterGenerator(insertstart);
        this.operationchooser = new DiscreteGenerator();
        if (readproportion > 0.0) {
            this.operationchooser.addValue(readproportion, "READ");
        }
        if (updateproportion > 0.0) {
            this.operationchooser.addValue(updateproportion, "UPDATE");
        }
        if (insertproportion > 0.0) {
            this.operationchooser.addValue(insertproportion, "INSERT");
        }
        if (scanproportion > 0.0) {
            this.operationchooser.addValue(scanproportion, "SCAN");
        }
        if (readmodifywriteproportion > 0.0) {
            this.operationchooser.addValue(readmodifywriteproportion, "READMODIFYWRITE");
        }
        this.transactioninsertkeysequence = new LongCounterGenerator(this.recordcount);
        if (requestdistrib.compareTo("uniform") == 0) {
            this.keychooser = new UniformLongGenerator(0L, this.recordcount - 1L);
        } else if (requestdistrib.compareTo("zipfian") == 0) {
            int opcount = Utils.getPropertyInt(p, "operationcount", 0);
            int expectednewkeys = (int)((double)opcount * insertproportion * 2.0);
            this.keychooser = new ScrambledZipfianGenerator(this.recordcount + (long)expectednewkeys);
        } else if (requestdistrib.compareTo("latest") == 0) {
            this.keychooser = new SkewedLatestGenerator(this.transactioninsertkeysequence);
        } else if (requestdistrib.equals("hotspot")) {
            double hotsetfraction = Utils.getPropertyDouble(p, HOTSPOT_DATA_FRACTION, 0.2);
            double hotopnfraction = Utils.getPropertyDouble(p, HOTSPOT_OPN_FRACTION, 0.8);
            this.keychooser = new HotspotLongGenerator(0L, this.recordcount - 1L, hotsetfraction, hotopnfraction);
        } else {
            throw new WorkloadException("Unknown request distribution \"" + requestdistrib + "\"");
        }
        this.fieldchooser = new UniformIntegerGenerator(0, this.fieldcount - 1);
        if (scanlengthdistrib.compareTo("uniform") == 0) {
            this.scanlength = new UniformIntegerGenerator(minscanlength, maxscanlength);
        } else if (scanlengthdistrib.compareTo("zipfian") == 0) {
            this.scanlength = new ZipfianGenerator((long)minscanlength, maxscanlength);
        } else {
            throw new WorkloadException("Distribution \"" + scanlengthdistrib + "\" not allowed for scan length");
        }
    }

    public String buildKeyName(long keynum) {
        if (!this.orderedinserts) {
            keynum = Utils.hash(keynum);
        }
        return this.keyPrefix + keynum;
    }

    HashMap<String, ByteIterator> buildValues() {
        HashMap<String, ByteIterator> values = new HashMap<String, ByteIterator>();
        for (int i = 0; i < this.fieldcount; ++i) {
            String fieldkey = "field" + i;
            RandomByteIterator data = new RandomByteIterator(this.fieldlengthgenerator.nextInt());
            values.put(fieldkey, data);
        }
        return values;
    }

    HashMap<String, ByteIterator> buildUpdate() {
        HashMap<String, ByteIterator> values = new HashMap<String, ByteIterator>();
        String fieldname = "field" + this.fieldchooser.nextString();
        RandomByteIterator data = new RandomByteIterator(this.fieldlengthgenerator.nextInt());
        values.put(fieldname, data);
        return values;
    }

    @Override
    public boolean doInsert(DB db, Object threadstate) {
        HashMap<String, ByteIterator> values;
        long keynum = this.keysequence.nextLong();
        String dbkey = this.buildKeyName(keynum);
        return db.insert(table, dbkey, values = this.buildValues()) == 0;
    }

    @Override
    public boolean doTransaction(DB db, Object threadstate) {
        String op = this.operationchooser.nextString();
        if (op.compareTo("READ") == 0) {
            this.doTransactionRead(db);
        } else if (op.compareTo("UPDATE") == 0) {
            this.doTransactionUpdate(db);
        } else if (op.compareTo("INSERT") == 0) {
            this.doTransactionInsert(db);
        } else if (op.compareTo("SCAN") == 0) {
            this.doTransactionScan(db);
        } else {
            this.doTransactionReadModifyWrite(db);
        }
        return true;
    }

    long nextKeynum() {
        long keynum = -1L;
        if (this.keychooser instanceof ExponentialLongGenerator) {
            while (keynum < 0L) {
            }
        } else {
            while ((keynum = this.keychooser.nextLong()) > this.transactioninsertkeysequence.lastLong()) {
            }
        }
        return keynum;
    }

    public void doTransactionRead(DB db) {
        long keynum = this.nextKeynum();
        String keyname = this.buildKeyName(keynum);
        HashSet<String> fields = null;
        if (!this.readallfields) {
            String fieldname = "field" + this.fieldchooser.nextString();
            fields = new HashSet<String>();
            fields.add(fieldname);
        }
        db.read(table, keyname, fields, new HashMap<String, ByteIterator>());
    }

    public void doTransactionReadModifyWrite(DB db) {
        long keynum = this.nextKeynum();
        String keyname = this.buildKeyName(keynum);
        HashSet<String> fields = null;
        if (!this.readallfields) {
            String fieldname = "field" + this.fieldchooser.nextString();
            fields = new HashSet<String>();
            fields.add(fieldname);
        }
        HashMap<String, ByteIterator> values = this.writeallfields ? this.buildValues() : this.buildUpdate();
        long st = System.nanoTime();
        db.read(table, keyname, fields, new HashMap<String, ByteIterator>());
        db.update(table, keyname, values);
        long en = System.nanoTime();
        Measurements.getMeasurements().measure("READ-MODIFY-WRITE", (int)((en - st) / 1000L));
    }

    public void doTransactionScan(DB db) {
        long keynum = this.nextKeynum();
        String startkeyname = this.buildKeyName(keynum);
        int len = this.scanlength.nextInt();
        HashSet<String> fields = null;
        if (!this.readallfields) {
            String fieldname = "field" + this.fieldchooser.nextString();
            fields = new HashSet<String>();
            fields.add(fieldname);
        }
        db.scan(table, startkeyname, len, fields, new Vector<HashMap<String, ByteIterator>>());
    }

    public void doTransactionUpdate(DB db) {
        long keynum = this.nextKeynum();
        String keyname = this.buildKeyName(keynum);
        HashMap<String, ByteIterator> values = this.writeallfields ? this.buildValues() : this.buildUpdate();
        db.update(table, keyname, values);
    }

    public void doTransactionInsert(DB db) {
        long keynum = this.transactioninsertkeysequence.nextLong();
        String dbkey = this.buildKeyName(keynum);
        HashMap<String, ByteIterator> values = this.buildValues();
        db.insert(table, dbkey, values);
    }
}

