/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.measurements;

import com.yahoo.ycsb.Utils;
import com.yahoo.ycsb.measurements.OneMeasurement;
import com.yahoo.ycsb.measurements.SeriesUnit;
import com.yahoo.ycsb.measurements.exporter.MeasurementsExporter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Properties;
import java.util.Vector;

public class OneMeasurementTimeSeries
extends OneMeasurement {
    public static final String GRANULARITY = "timeseries.granularity";
    public static final int GRANULARITY_DEFAULT = 1000;
    private static final long LATENCY_THRESHOLD = Long.valueOf(System.getProperty("ycsb.latency.limit", "1000")) * 1000L;
    int _granularity;
    Vector<SeriesUnit> _measurements;
    long start = -1L;
    long currentunit = -1L;
    int count = 0;
    int sum = 0;
    int operations = 0;
    long totallatency = 0L;
    int windowoperations = 0;
    long windowtotallatency = 0L;
    long windowmaxlatency = -1L;
    long windowminlatency = -1L;
    int min = -1;
    int max = -1;
    private HashMap<Integer, int[]> returncodes;

    public OneMeasurementTimeSeries(String name, Properties props) {
        super(name);
        this._granularity = Utils.getPropertyInt(props, GRANULARITY, 1000);
        this._measurements = new Vector();
        this.returncodes = new HashMap();
    }

    void checkEndOfUnit(boolean forceend) {
        long unit;
        long now = System.currentTimeMillis();
        if (this.start < 0L) {
            this.currentunit = 0L;
            this.start = now;
        }
        if ((unit = (now - this.start) / (long)this._granularity * (long)this._granularity) > this.currentunit || forceend) {
            double avg = (double)this.sum / (double)this.count;
            this._measurements.add(new SeriesUnit(this.currentunit, avg));
            this.currentunit = unit;
            this.count = 0;
            this.sum = 0;
        }
    }

    @Override
    public void measure(int latency) {
        this.checkEndOfUnit(false);
        ++this.count;
        this.sum += latency;
        this.totallatency += (long)latency;
        ++this.operations;
        ++this.windowoperations;
        this.windowtotallatency += (long)latency;
        if ((long)latency > LATENCY_THRESHOLD) {
            System.out.println("Latency Spike: " + latency);
        }
        if (latency > this.max) {
            this.max = latency;
        }
        if (latency < this.min || this.min < 0) {
            this.min = latency;
        }
        if ((long)latency > this.windowmaxlatency) {
            this.windowmaxlatency = latency;
        }
        if ((long)latency < this.windowminlatency || this.windowminlatency < 0L) {
            this.windowminlatency = latency;
        }
    }

    @Override
    public void exportMeasurements(MeasurementsExporter exporter) throws IOException {
        this.checkEndOfUnit(true);
        exporter.write(this.getName(), "Operations", this.operations);
        exporter.write(this.getName(), "AverageLatency(us)", (double)this.totallatency / (double)this.operations);
        exporter.write(this.getName(), "MinLatency(us)", this.min);
        exporter.write(this.getName(), "MaxLatency(us)", this.max);
        for (Integer I : this.returncodes.keySet()) {
            int[] val = this.returncodes.get(I);
            exporter.write(this.getName(), "Return=" + I, val[0]);
        }
        for (SeriesUnit unit : this._measurements) {
            exporter.write(this.getName(), Long.toString(unit.time), unit.average);
        }
    }

    @Override
    public void reportReturnCode(int code) {
        Integer Icode = code;
        if (!this.returncodes.containsKey(Icode)) {
            int[] val = new int[]{0};
            this.returncodes.put(Icode, val);
        }
        int[] nArray = this.returncodes.get(Icode);
        nArray[0] = nArray[0] + 1;
    }

    @Override
    public String getSummary() {
        if (this.windowoperations == 0) {
            return "";
        }
        DecimalFormat d = new DecimalFormat("#.##");
        double report = (double)this.windowtotallatency / (double)this.windowoperations;
        long reportMin = this.windowminlatency;
        long reportMax = this.windowmaxlatency;
        this.windowtotallatency = 0L;
        this.windowoperations = 0;
        this.windowminlatency = -1L;
        this.windowmaxlatency = -1L;
        return "[" + this.getName() + " AverageLatency(us)=" + d.format(report) + " MinLatency(us)=" + reportMin + " MaxLatency(us)=" + reportMax + " ]";
    }
}

