/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.measurements;

import com.mapr.stats.UpperQuantile;
import com.yahoo.ycsb.Utils;
import com.yahoo.ycsb.measurements.OneMeasurement;
import com.yahoo.ycsb.measurements.exporter.MeasurementsExporter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;

public class OneMeasurementHistogram
extends OneMeasurement {
    private static final String YCSB_LATENCY_SPIKE_TRIGGER = "ycsb.latency.limit";
    private static final String MAPR_PERCENTILE_CAPACITY_DEFAULT = "1000";
    private static final String MAPR_PERCENTILE_CAPACITY = "mapr.percentile.capacity";
    private static final String MAPR_PERCENTILE_LIST_DEFAULT = "99.9";
    private static final String MAPR_PERCENTILE_LIST = "mapr.percentile.list";
    private static final long LATENCY_THRESHOLD = Long.valueOf(System.getProperty("ycsb.latency.limit", "1000")) * 1000L;
    public static final String BUCKETS = "histogram.buckets";
    public static final int BUCKETS_DEFAULT = 1000;
    private static boolean reportPercentile;
    int _buckets;
    int[] histogram;
    int histogramoverflow;
    int operations;
    long totallatency;
    int windowoperations;
    long windowtotallatency;
    long windowmaxlatency = -1L;
    long windowminlatency = -1L;
    private static final int PERCENTILE_CAPACITY;
    UpperQuantile uprQtile = new UpperQuantile(PERCENTILE_CAPACITY);
    double[] quantileList = this.setPercentiles(System.getProperty("mapr.percentile.list", "99.9"));
    int min;
    int max;
    HashMap<Integer, int[]> returncodes;

    public OneMeasurementHistogram(String name, Properties props) {
        super(name);
        this._buckets = Utils.getPropertyInt(props, BUCKETS, 1000);
        this.histogram = new int[this._buckets];
        this.histogramoverflow = 0;
        this.operations = 0;
        this.totallatency = 0L;
        this.windowoperations = 0;
        this.windowtotallatency = 0L;
        this.min = -1;
        this.max = -1;
        this.returncodes = new HashMap();
        String requestedPercentiles = System.getProperty(MAPR_PERCENTILE_LIST);
        if (requestedPercentiles.length() > 0) {
            System.out.println("[MapR-Perf] Will be tracking percentiles : [" + System.getProperty(MAPR_PERCENTILE_LIST, MAPR_PERCENTILE_LIST_DEFAULT) + "] ");
            reportPercentile = true;
        } else {
            System.out.println("[MapR-Perf] Will NOT be tracking percentiles!!");
            reportPercentile = false;
        }
    }

    private double[] setPercentiles(String csvPercentileList) {
        ArrayList<Double> percentileList = new ArrayList<Double>();
        for (String percentileAsStr : csvPercentileList.split(",")) {
            try {
                percentileList.add(Double.valueOf(percentileAsStr) / 100.0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        double[] requestedPercentiles = new double[percentileList.size()];
        for (int i = 0; i < requestedPercentiles.length; ++i) {
            requestedPercentiles[i] = (Double)percentileList.get(i);
        }
        return requestedPercentiles;
    }

    @Override
    public synchronized void reportReturnCode(int code) {
        Integer Icode = code;
        if (!this.returncodes.containsKey(Icode)) {
            int[] val = new int[]{0};
            this.returncodes.put(Icode, val);
        }
        int[] nArray = this.returncodes.get(Icode);
        nArray[0] = nArray[0] + 1;
    }

    @Override
    public synchronized void measure(int latency) {
        if (latency / 1000 >= this._buckets) {
            ++this.histogramoverflow;
        } else {
            int n = latency / 1000;
            this.histogram[n] = this.histogram[n] + 1;
        }
        ++this.operations;
        this.totallatency += (long)latency;
        ++this.windowoperations;
        this.windowtotallatency += (long)latency;
        if ((long)latency > LATENCY_THRESHOLD) {
            System.out.println("Latency Spike: " + latency);
        }
        if (this.min < 0 || latency < this.min) {
            this.min = latency;
        }
        if (this.max < 0 || latency > this.max) {
            this.max = latency;
        }
        if ((long)latency > this.windowmaxlatency) {
            this.windowmaxlatency = latency;
        }
        if ((long)latency < this.windowminlatency || this.windowminlatency < 0L) {
            this.windowminlatency = latency;
        }
        if (reportPercentile) {
            this.uprQtile.add(latency);
        }
    }

    @Override
    public void exportMeasurements(MeasurementsExporter exporter) throws IOException {
        exporter.write(this.getName(), "Operations", this.operations);
        exporter.write(this.getName(), "AverageLatency(us)", (double)this.totallatency / (double)this.operations);
        exporter.write(this.getName(), "MinLatency(us)", this.min);
        exporter.write(this.getName(), "MaxLatency(us)", this.max);
        int opcounter = 0;
        boolean done95th = false;
        for (int i = 0; i < this._buckets; ++i) {
            opcounter += this.histogram[i];
            if (!done95th && (double)opcounter / (double)this.operations >= 0.95) {
                exporter.write(this.getName(), "95thPercentileLatency(ms)", i);
                done95th = true;
            }
            if (!((double)opcounter / (double)this.operations >= 0.99)) continue;
            exporter.write(this.getName(), "99thPercentileLatency(ms)", i);
            break;
        }
        for (Integer I : this.returncodes.keySet()) {
            int[] val = this.returncodes.get(I);
            exporter.write(this.getName(), "Return=" + I, val[0]);
        }
        for (int i = 0; i < this._buckets; ++i) {
            exporter.write(this.getName(), Integer.toString(i), this.histogram[i]);
        }
        exporter.write(this.getName(), ">" + this._buckets, this.histogramoverflow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getSummary() {
        if (this.windowoperations == 0) {
            return "";
        }
        DecimalFormat d = new DecimalFormat("#.##");
        double report = (double)this.windowtotallatency / (double)this.windowoperations;
        long reportMin = this.windowminlatency;
        long reportMax = this.windowmaxlatency;
        double[] reportPcTiles = new double[this.quantileList.length];
        if (reportPercentile) {
            UpperQuantile upperQuantile = this.uprQtile;
            synchronized (upperQuantile) {
                reportPcTiles = this.uprQtile.getQuantiles(this.quantileList);
                this.uprQtile.clear();
            }
        }
        this.windowtotallatency = 0L;
        this.windowoperations = 0;
        this.windowminlatency = -1L;
        this.windowmaxlatency = -1L;
        if (reportPercentile) {
            StringBuilder percentileReport = new StringBuilder();
            for (int i = 0; i < reportPcTiles.length; ++i) {
                percentileReport.append(this.quantileList[i] * 100.0 + "%ile(us)=" + (reportPcTiles[i] < 0.0 ? "#N/A" : d.format(reportPcTiles[i])) + " ");
            }
            return "[" + this.getName() + " AverageLatency(us)=" + d.format(report) + " MinLatency(us)=" + reportMin + " MaxLatency(us)=" + reportMax + " " + percentileReport + "]";
        }
        return "[" + this.getName() + " AverageLatency(us)=" + d.format(report) + " MinLatency(us)=" + reportMin + " MaxLatency(us)=" + reportMax + " ]";
    }

    static {
        PERCENTILE_CAPACITY = Integer.valueOf(System.getProperty(MAPR_PERCENTILE_CAPACITY, MAPR_PERCENTILE_CAPACITY_DEFAULT));
    }
}

