/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.generator;

import com.yahoo.ycsb.Utils;
import com.yahoo.ycsb.generator.LongGenerator;

public class ExponentialLongGenerator
extends LongGenerator {
    public static final String EXPONENTIAL_PERCENTILE_PROPERTY = "exponential.percentile";
    public static final double EXPONENTIAL_PERCENTILE_DEFAULT = 95.0;
    public static final String EXPONENTIAL_FRAC_PROPERTY = "exponential.frac";
    public static final double EXPONENTIAL_FRAC_DEFAULT = 0.8571428571;
    double _gamma;

    public ExponentialLongGenerator(double mean) {
        this._gamma = 1.0 / mean;
    }

    public ExponentialLongGenerator(double percentile, double range) {
        this._gamma = -Math.log(1.0 - percentile / 100.0) / range;
    }

    public int nextInt() {
        return (int)this.nextLong();
    }

    @Override
    public long nextLong() {
        return (long)(-Math.log(Utils.random().nextDouble()) / this._gamma);
    }

    @Override
    public double mean() {
        return 1.0 / this._gamma;
    }

    public static void main(String[] args) {
        ExponentialLongGenerator e = new ExponentialLongGenerator(90.0, 100.0);
        int j = 0;
        for (int i = 0; i < 1000; ++i) {
            if (e.nextInt() >= 100) continue;
            ++j;
        }
        System.out.println("Got " + j + " hits.  Expect 900");
    }
}

