/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.mongodb.BasicDBObject;
import com.mongodb.DBAddress;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.Mongo;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import com.yahoo.ycsb.ByteArrayByteIterator;
import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;

public class MongoDbClient
extends DB {
    protected static final Integer INCLUDE = 1;
    private static Mongo mongo;
    private static WriteConcern writeConcern;
    private static String database;
    private static final AtomicInteger initCount;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws DBException {
        initCount.incrementAndGet();
        Integer n = INCLUDE;
        synchronized (n) {
            if (mongo != null) {
                return;
            }
            Properties props = this.getProperties();
            String url = props.getProperty("mongodb.url", "mongodb://localhost:27017");
            database = props.getProperty("mongodb.database", "ycsb");
            String writeConcernType = props.getProperty("mongodb.writeConcern", "safe").toLowerCase();
            String maxConnections = props.getProperty("mongodb.maxconnections", "10");
            if ("none".equals(writeConcernType)) {
                writeConcern = WriteConcern.NONE;
            } else if ("safe".equals(writeConcernType)) {
                writeConcern = WriteConcern.SAFE;
            } else if ("normal".equals(writeConcernType)) {
                writeConcern = WriteConcern.NORMAL;
            } else if ("fsync_safe".equals(writeConcernType)) {
                writeConcern = WriteConcern.FSYNC_SAFE;
            } else if ("replicas_safe".equals(writeConcernType)) {
                writeConcern = WriteConcern.REPLICAS_SAFE;
            } else {
                System.err.println("ERROR: Invalid writeConcern: '" + writeConcernType + "'. " + "Must be [ none | safe | normal | fsync_safe | replicas_safe ]");
                System.exit(1);
            }
            try {
                if (url.startsWith("mongodb://")) {
                    url = url.substring(10);
                }
                url = url + "/" + database;
                System.out.println("new database url = " + url);
                MongoOptions options = new MongoOptions();
                options.connectionsPerHost = Integer.parseInt(maxConnections);
                mongo = new Mongo((ServerAddress)new DBAddress(url), options);
                System.out.println("mongo connection created with " + url);
            }
            catch (Exception e1) {
                System.err.println("Could not initialize MongoDB connection pool for Loader: " + e1.toString());
                e1.printStackTrace();
                return;
            }
        }
    }

    @Override
    public void cleanup() throws DBException {
        if (initCount.decrementAndGet() <= 0) {
            try {
                mongo.close();
            }
            catch (Exception e1) {
                System.err.println("Could not close MongoDB connection pool: " + e1.toString());
                e1.printStackTrace();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int delete(String table, String key) {
        com.mongodb.DB db = null;
        try {
            db = mongo.getDB(database);
            db.requestStart();
            DBCollection collection = db.getCollection(table);
            BasicDBObject q = new BasicDBObject().append("_id", key);
            WriteResult res = collection.remove(q, writeConcern);
            int n = res.getN() == 1 ? 0 : 1;
            return n;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            int n = 1;
            return n;
        }
        finally {
            if (db != null) {
                db.requestDone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        com.mongodb.DB db = null;
        try {
            db = mongo.getDB(database);
            db.requestStart();
            DBCollection collection = db.getCollection(table);
            BasicDBObject r = new BasicDBObject().append("_id", key);
            for (String k : values.keySet()) {
                r.put(k, (Object)values.get(k).toArray());
            }
            WriteResult res = collection.insert((DBObject)r, writeConcern);
            int n = res.getError() == null ? 0 : 1;
            return n;
        }
        catch (Exception e) {
            e.printStackTrace();
            int n = 1;
            return n;
        }
        finally {
            if (db != null) {
                db.requestDone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        com.mongodb.DB db = null;
        try {
            db = mongo.getDB(database);
            db.requestStart();
            DBCollection collection = db.getCollection(table);
            BasicDBObject q = new BasicDBObject().append("_id", key);
            BasicDBObject fieldsToReturn = new BasicDBObject();
            DBObject queryResult = null;
            if (fields != null) {
                Iterator<String> iter = fields.iterator();
                while (iter.hasNext()) {
                    fieldsToReturn.put(iter.next(), (Object)INCLUDE);
                }
                queryResult = collection.findOne(q, (DBObject)fieldsToReturn);
            } else {
                queryResult = collection.findOne(q);
            }
            if (queryResult != null) {
                result.putAll(queryResult.toMap());
            }
            int n = queryResult != null ? 0 : 1;
            return n;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            int n = 1;
            return n;
        }
        finally {
            if (db != null) {
                db.requestDone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        com.mongodb.DB db = null;
        try {
            db = mongo.getDB(database);
            db.requestStart();
            DBCollection collection = db.getCollection(table);
            BasicDBObject q = new BasicDBObject().append("_id", key);
            BasicDBObject u = new BasicDBObject();
            BasicDBObject fieldsToSet = new BasicDBObject();
            for (String tmpKey : values.keySet()) {
                fieldsToSet.put(tmpKey, (Object)values.get(tmpKey).toArray());
            }
            u.put("$set", (Object)fieldsToSet);
            WriteResult res = collection.update(q, u, false, false, writeConcern);
            int n = res.getN() == 1 ? 0 : 1;
            return n;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            int n = 1;
            return n;
        }
        finally {
            if (db != null) {
                db.requestDone();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        com.mongodb.DB db = null;
        try {
            db = mongo.getDB(database);
            db.requestStart();
            DBCollection collection = db.getCollection(table);
            BasicDBObject scanRange = new BasicDBObject().append("$gte", startkey);
            BasicDBObject q = new BasicDBObject().append("_id", scanRange);
            DBCursor cursor = collection.find(q).limit(recordcount);
            while (cursor.hasNext()) {
                HashMap<String, ByteIterator> resultMap = new HashMap<String, ByteIterator>();
                DBObject obj = cursor.next();
                this.fillMap(resultMap, obj);
                result.add(resultMap);
            }
            int n = 0;
            return n;
        }
        catch (Exception e) {
            System.err.println(e.toString());
            int n = 1;
            return n;
        }
        finally {
            if (db != null) {
                db.requestDone();
            }
        }
    }

    protected void fillMap(HashMap<String, ByteIterator> resultMap, DBObject obj) {
        Map objMap = obj.toMap();
        for (Map.Entry entry : objMap.entrySet()) {
            if (!(entry.getValue() instanceof byte[])) continue;
            resultMap.put((String)entry.getKey(), new ByteArrayByteIterator((byte[])entry.getValue()));
        }
    }

    static {
        initCount = new AtomicInteger(0);
    }
}

