/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb;

import com.yahoo.ycsb.ClientThread;
import com.yahoo.ycsb.Utils;
import com.yahoo.ycsb.measurements.Measurements;
import java.io.File;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;

class StatusThread
extends Thread {
    private static ThreadMXBean threadBean = ManagementFactory.getThreadMXBean();
    Vector<Thread> _threads;
    String _label;
    boolean _standardstatus;
    PrintStream _stackDumpStream;
    int _stackDumpIterationThreshold;
    int _stackDumpOperationThreshold;
    private long _sleeptime;

    public StatusThread(Vector<Thread> threads, String label, boolean standardstatus, Properties props) {
        this._threads = threads;
        this._label = label;
        this._standardstatus = standardstatus;
        this._sleeptime = Utils.getPropertyLong(props, "statusInterval", 1000L);
        String threadDumpFile = props.getProperty("stackdumpFile");
        if (threadDumpFile == null) {
            this._stackDumpStream = null;
        } else {
            this._stackDumpIterationThreshold = Utils.getPropertyInt(props, "stackdumpIterationThreshold", 5);
            this._stackDumpOperationThreshold = Utils.getPropertyInt(props, "stackDumpOperationThreshold", 0);
            try {
                this._stackDumpStream = new PrintStream(new File(threadDumpFile));
                System.out.println("Stack traces will be dumped to " + threadDumpFile);
            }
            catch (Exception e) {
                System.out.println("Unable to open file stream for stack trace dump.");
                e.printStackTrace();
                this._stackDumpStream = null;
            }
        }
    }

    private static String getTaskName(long id, String name) {
        if (name == null) {
            return Long.toString(id);
        }
        return id + " (" + name + ")";
    }

    public static void printThreadInfo(PrintStream stream, String title) {
        int STACK_DEPTH = 20;
        boolean contention = threadBean.isThreadContentionMonitoringEnabled();
        long[] threadIds = threadBean.getAllThreadIds();
        stream.println("Process Thread Dump: " + title);
        stream.println(threadIds.length + " active threads");
        for (long tid : threadIds) {
            ThreadInfo info = threadBean.getThreadInfo(tid, 20);
            if (info == null) {
                stream.println("  Inactive");
                continue;
            }
            stream.println("Thread " + StatusThread.getTaskName(info.getThreadId(), info.getThreadName()) + ":");
            Thread.State state = info.getThreadState();
            stream.println("  State: " + (Object)((Object)state));
            stream.println("  Blocked count: " + info.getBlockedCount());
            stream.println("  Waited count: " + info.getWaitedCount());
            if (contention) {
                stream.println("  Blocked time: " + info.getBlockedTime());
                stream.println("  Waited time: " + info.getWaitedTime());
            }
            if (state == Thread.State.WAITING) {
                stream.println("  Waiting on " + info.getLockName());
            } else if (state == Thread.State.BLOCKED) {
                stream.println("  Blocked on " + info.getLockName());
                stream.println("  Blocked by " + StatusThread.getTaskName(info.getLockOwnerId(), info.getLockOwnerName()));
            }
            stream.println("  Stack:");
            for (StackTraceElement frame : info.getStackTrace()) {
                stream.println("    " + frame.toString());
            }
        }
        stream.flush();
    }

    @Override
    public void run() {
        boolean alldone;
        long st;
        long lasten = st = System.currentTimeMillis();
        long lasttotalops = 0L;
        int zeroOpsCount = 0;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS");
        do {
            alldone = true;
            int totalops = 0;
            for (Thread t : this._threads) {
                if (t.getState() != Thread.State.TERMINATED) {
                    alldone = false;
                }
                ClientThread ct = (ClientThread)t;
                totalops += ct.getOpsDone();
            }
            long en = System.currentTimeMillis();
            long interval = en - st;
            double curthroughput = 1000.0 * ((double)((long)totalops - lasttotalops) / (double)(en - lasten));
            lasttotalops = totalops;
            lasten = en;
            Date date = new Date();
            DecimalFormat d = new DecimalFormat("#.##");
            if (this._stackDumpStream != null) {
                if (curthroughput <= (double)this._stackDumpOperationThreshold) {
                    if (++zeroOpsCount > this._stackDumpIterationThreshold) {
                        StatusThread.printThreadInfo(this._stackDumpStream, df.format(new Date(System.currentTimeMillis())));
                        zeroOpsCount = 0;
                    }
                } else {
                    zeroOpsCount = 0;
                }
            }
            if (totalops == 0) {
                System.err.println(this._label + " " + date.toString() + " " + interval / 1000L + " sec: " + totalops + " operations; " + Measurements.getMeasurements().getSummary());
            } else {
                System.err.println(this._label + " " + date.toString() + " " + interval / 1000L + " sec: " + totalops + " operations; " + d.format(curthroughput) + " current ops/sec; " + Measurements.getMeasurements().getSummary());
            }
            if (this._standardstatus) {
                if (totalops == 0) {
                    System.out.println(this._label + " " + date.toString() + " " + interval / 1000L + " sec: " + totalops + " operations; " + Measurements.getMeasurements().getSummary());
                } else {
                    System.out.println(this._label + " " + date.toString() + " " + interval / 1000L + " sec: " + totalops + " operations; " + d.format(curthroughput) + " current ops/sec; " + Measurements.getMeasurements().getSummary());
                }
            }
            try {
                StatusThread.sleep(this._sleeptime);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (!alldone);
        if (this._stackDumpStream != null) {
            this._stackDumpStream.close();
        }
    }
}

