/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb;

import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.DBException;
import com.yahoo.ycsb.Utils;
import com.yahoo.ycsb.Workload;
import com.yahoo.ycsb.WorkloadException;
import java.util.Properties;

class ClientThread
extends Thread {
    DB _db;
    boolean _dotransactions;
    Workload _workload;
    int _opcount;
    double _target;
    int _opsdone;
    int _threadid;
    int _threadcount;
    Object _workloadstate;
    Properties _props;

    public ClientThread(DB db, boolean dotransactions, Workload workload, int threadid, int threadcount, Properties props, int opcount, double targetperthreadperms) {
        super("YCSB Client Thread " + threadid + "/" + threadcount);
        this._db = db;
        this._dotransactions = dotransactions;
        this._workload = workload;
        this._opcount = opcount;
        this._opsdone = 0;
        this._target = targetperthreadperms;
        this._threadid = threadid;
        this._threadcount = threadcount;
        this._props = props;
    }

    public int getOpsDone() {
        return this._opsdone;
    }

    @Override
    public void run() {
        try {
            this._db.init();
        }
        catch (DBException e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            return;
        }
        try {
            this._workloadstate = this._workload.initThread(this._props, this._threadid, this._threadcount);
        }
        catch (WorkloadException e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            return;
        }
        try {
            if (this._target > 0.0 && this._target <= 1.0) {
                ClientThread.sleep(Utils.random().nextInt((int)(1.0 / this._target)));
            }
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            long st;
            if (this._dotransactions) {
                st = System.currentTimeMillis();
                while ((this._opcount == 0 || this._opsdone < this._opcount) && !this._workload.isStopRequested() && this._workload.doTransaction(this._db, this._workloadstate)) {
                    ++this._opsdone;
                    if (!(this._target > 0.0)) continue;
                    while ((double)(System.currentTimeMillis() - st) < (double)this._opsdone / this._target) {
                        try {
                            ClientThread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            } else {
                st = System.currentTimeMillis();
                while ((this._opcount == 0 || this._opsdone < this._opcount) && !this._workload.isStopRequested() && this._workload.doInsert(this._db, this._workloadstate)) {
                    ++this._opsdone;
                    if (!(this._target > 0.0)) continue;
                    while ((double)(System.currentTimeMillis() - st) < (double)this._opsdone / this._target) {
                        try {
                            ClientThread.sleep(1L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            System.exit(0);
        }
        try {
            this._db.cleanup();
        }
        catch (DBException e) {
            e.printStackTrace();
            e.printStackTrace(System.out);
            return;
        }
    }
}

