/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb;

import com.yahoo.ycsb.ByteIterator;
import com.yahoo.ycsb.DB;
import com.yahoo.ycsb.Utils;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class BasicDB
extends DB {
    public static final String VERBOSE = "basicdb.verbose";
    public static final boolean VERBOSE_DEFAULT = true;
    public static final String SIMULATE_DELAY = "basicdb.simulatedelay";
    public static final int SIMULATE_DELAY_DEFAULT = 0;
    boolean verbose;
    int todelay = 0;

    void delay() {
        if (this.todelay > 0) {
            try {
                Thread.sleep(Utils.random().nextInt(this.todelay));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public void init() {
        this.verbose = this.getPropertyBool(VERBOSE, true);
        this.todelay = this.getPropertyInt(SIMULATE_DELAY, 0);
        if (this.verbose) {
            System.out.println("***************** properties *****************");
            Properties p = this.getProperties();
            if (p != null) {
                Enumeration<?> e = p.propertyNames();
                while (e.hasMoreElements()) {
                    String k = (String)e.nextElement();
                    System.out.println("\"" + k + "\"=\"" + p.getProperty(k) + "\"");
                }
            }
            System.out.println("**********************************************");
        }
    }

    @Override
    public int read(String table, String key, Set<String> fields, HashMap<String, ByteIterator> result) {
        this.delay();
        if (this.verbose) {
            System.out.print("READ " + table + " " + key + " [ ");
            if (fields != null) {
                for (String f : fields) {
                    System.out.print(f + " ");
                }
            } else {
                System.out.print("<all fields>");
            }
            System.out.println("]");
        }
        return 0;
    }

    @Override
    public int scan(String table, String startkey, int recordcount, Set<String> fields, Vector<HashMap<String, ByteIterator>> result) {
        this.delay();
        if (this.verbose) {
            System.out.print("SCAN " + table + " " + startkey + " " + recordcount + " [ ");
            if (fields != null) {
                for (String f : fields) {
                    System.out.print(f + " ");
                }
            } else {
                System.out.print("<all fields>");
            }
            System.out.println("]");
        }
        return 0;
    }

    @Override
    public int update(String table, String key, HashMap<String, ByteIterator> values) {
        this.delay();
        if (this.verbose) {
            System.out.print("UPDATE " + table + " " + key + " [ ");
            if (values != null) {
                for (String k : values.keySet()) {
                    System.out.print(k + "=" + values.get(k) + " ");
                }
            }
            System.out.println("]");
        }
        return 0;
    }

    @Override
    public int insert(String table, String key, HashMap<String, ByteIterator> values) {
        this.delay();
        if (this.verbose) {
            System.out.print("INSERT " + table + " " + key + " [ ");
            if (values != null) {
                for (String k : values.keySet()) {
                    System.out.print(k + "=" + values.get(k) + " ");
                }
            }
            System.out.println("]");
        }
        return 0;
    }

    @Override
    public int delete(String table, String key) {
        this.delay();
        if (this.verbose) {
            System.out.println("DELETE " + table + " " + key);
        }
        return 0;
    }
}

