/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.ConnectionStatus;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MongosStatus
extends ConnectionStatus {
    private static final Logger logger = Logger.getLogger("com.mongodb.MongosStatus");
    private volatile ConnectionStatus.Node preferred;

    MongosStatus(Mongo mongo, List<ServerAddress> mongosAddresses) {
        super(mongosAddresses, mongo);
        this._updater = new MongosUpdater();
    }

    @Override
    boolean hasServerUp() {
        return this.preferred != null;
    }

    @Override
    ConnectionStatus.Node ensureMaster() {
        this.checkClosed();
        return this.getPreferred();
    }

    @Override
    List<ServerAddress> getServerAddressList() {
        return new ArrayList<ServerAddress>(this._mongosAddresses);
    }

    private synchronized void setPreferred(MongosNode bestThisPass) {
        this.preferred = bestThisPass == null ? null : new ConnectionStatus.Node(bestThisPass._pingTimeMS, bestThisPass._addr, bestThisPass._maxBsonObjectSize, bestThisPass._ok);
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ConnectionStatus.Node getPreferred() {
        if (this.preferred == null) {
            try {
                MongosStatus mongosStatus = this;
                synchronized (mongosStatus) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                throw new MongoException("Interrupted while waiting for next update to mongos status", e);
            }
        }
        return this.preferred;
    }

    static class MongosNode
    extends ConnectionStatus.UpdatableNode {
        MongosNode(ServerAddress addr, Mongo mongo, MongoOptions mongoOptions) {
            super(addr, mongo, mongoOptions);
        }

        protected Logger getLogger() {
            return logger;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MongosUpdater
    extends ConnectionStatus.BackgroundUpdater {
        MongosUpdater() {
            super("MongosStatus:MongosUpdater");
        }

        @Override
        public void run() {
            List<MongosNode> mongosNodes = this.getMongosNodes();
            try {
                while (!Thread.interrupted()) {
                    try {
                        MongosNode bestThisPass = null;
                        for (MongosNode cur : mongosNodes) {
                            cur.update();
                            if (!cur._ok || bestThisPass != null && !(cur._pingTimeMS < bestThisPass._pingTimeMS)) continue;
                            bestThisPass = cur;
                        }
                        MongosStatus.this.setPreferred(bestThisPass);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "couldn't do update pass", e);
                    }
                    int sleepTime = MongosStatus.this.preferred == null ? ConnectionStatus.updaterIntervalNoMasterMS : ConnectionStatus.updaterIntervalMS;
                    Thread.sleep(sleepTime);
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.INFO, "Exiting background thread");
            }
        }

        private List<MongosNode> getMongosNodes() {
            ArrayList<MongosNode> mongosNodes = new ArrayList<MongosNode>(MongosStatus.this._mongosAddresses.size());
            for (ServerAddress serverAddress : MongosStatus.this._mongosAddresses) {
                mongosNodes.add(new MongosNode(serverAddress, MongosStatus.this._mongo, MongosStatus.this._mongoOptions));
            }
            return mongosNodes;
        }
    }
}

