/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.io.ObjectStreamException;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.iterators.FilterIterator;
import org.apache.commons.collections.iterators.IteratorChain;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Closeable;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.ChangeTracker;
import org.apache.openjpa.util.ImplHelper;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.LRSProxy;
import org.apache.openjpa.util.MapChangeTracker;
import org.apache.openjpa.util.MapChangeTrackerImpl;
import org.apache.openjpa.util.Proxies;

public abstract class AbstractLRSProxyMap<K, V>
implements Map<K, V>,
LRSProxy,
MapChangeTracker,
Predicate {
    private static final int MODE_KEY = 0;
    private static final int MODE_VALUE = 1;
    private static final int MODE_ENTRY = 2;
    private static final Localizer _loc = Localizer.forPackage(AbstractLRSProxyMap.class);
    private Class<K> _keyType = null;
    private Class<V> _valueType = null;
    private MapChangeTrackerImpl _ct = null;
    private OpenJPAStateManager _sm = null;
    private int _field = -1;
    private OpenJPAStateManager _origOwner = null;
    private int _origField = -1;
    private Map<K, V> _map = null;
    private int _count = -1;
    private boolean _iterated = false;

    public AbstractLRSProxyMap(Class<K> keyType, Class<V> valueType) {
        this._keyType = keyType;
        this._valueType = valueType;
        this._ct = new MapChangeTrackerImpl(this, false);
        this._ct.setAutoOff(false);
    }

    @Override
    public void setOwner(OpenJPAStateManager sm, int field) {
        if (sm != null && this._origOwner != null && (this._origOwner != sm || this._origField != field)) {
            throw new InvalidStateException(_loc.get("transfer-lrs", this._origOwner.getMetaData().getField(this._origField)));
        }
        this._sm = sm;
        this._field = field;
        if (sm != null) {
            this._origOwner = sm;
            this._origField = field;
        }
    }

    @Override
    public OpenJPAStateManager getOwner() {
        return this._sm;
    }

    @Override
    public int getOwnerField() {
        return this._field;
    }

    @Override
    public ChangeTracker getChangeTracker() {
        return this;
    }

    @Override
    public Object copy(Object orig) {
        return null;
    }

    boolean isIterated() {
        return this._iterated;
    }

    void setIterated(boolean it) {
        this._iterated = it;
    }

    @Override
    public int size() {
        if (this._count == -1) {
            this._count = this.count();
        }
        if (this._count == Integer.MAX_VALUE) {
            return this._count;
        }
        return this._count + this._ct.getAdded().size() - this._ct.getRemoved().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this._keyType != null && !this._keyType.isInstance(key)) {
            return false;
        }
        if (this._map != null && this._map.containsKey(key)) {
            return true;
        }
        if (this._ct.getTrackKeys()) {
            if (this._ct.getRemoved().contains(key)) {
                return false;
            }
            return this.hasKey(key);
        }
        if (this._ct.getRemoved().isEmpty()) {
            return this.hasKey(key);
        }
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object val) {
        if (this._valueType != null && !this._valueType.isInstance(val)) {
            return false;
        }
        if (this._map != null && this._map.containsValue(val)) {
            return true;
        }
        if (!this._ct.getTrackKeys()) {
            if (this._ct.getRemoved().contains(val)) {
                return false;
            }
            return this.hasValue(val);
        }
        Collection<K> keys = this.keys(val);
        if (keys == null || keys.isEmpty()) {
            return false;
        }
        keys.removeAll(this._ct.getRemoved());
        keys.removeAll(this._ct.getChanged());
        return keys.size() > 0;
    }

    @Override
    public V get(Object key) {
        V ret;
        if (this._keyType != null && !this._keyType.isInstance(key)) {
            return null;
        }
        V v = ret = this._map == null ? null : (V)this._map.get(key);
        if (ret != null) {
            return ret;
        }
        if (this._ct.getTrackKeys() && this._ct.getRemoved().contains(key)) {
            return null;
        }
        V val = this.value(key);
        if (!this._ct.getTrackKeys() && this._ct.getRemoved().contains(val)) {
            return null;
        }
        return val;
    }

    @Override
    public V put(K key, V value) {
        V old;
        Proxies.assertAllowedType(key, this._keyType);
        Proxies.assertAllowedType(value, this._valueType);
        Proxies.dirty(this, false);
        if (this._map == null) {
            this._map = new HashMap();
        }
        if (!((old = this._map.put(key, value)) != null || this._ct.getTrackKeys() && this._ct.getRemoved().contains(key))) {
            old = this.value(key);
        }
        if (old != null) {
            this._ct.changed(key, old, value);
            Proxies.removed(this, old, false);
        } else {
            this._ct.added(key, value);
        }
        return old;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        V old;
        Proxies.dirty(this, false);
        V v = old = this._map == null ? null : (V)this._map.remove(key);
        if (!(old != null || this._ct.getTrackKeys() && this._ct.getRemoved().contains(key))) {
            old = this.value(key);
        }
        if (old != null) {
            this._ct.removed(key, old);
            Proxies.removed(this, key, true);
            Proxies.removed(this, old, false);
        }
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Proxies.dirty(this, false);
        Itr itr = this.iterator(2);
        try {
            while (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)itr.next();
                Proxies.removed(this, entry.getKey(), true);
                Proxies.removed(this, entry.getValue(), false);
                this._ct.removed(entry.getKey(), entry.getValue());
            }
        }
        finally {
            itr.close();
        }
    }

    @Override
    public Set<K> keySet() {
        return new AbstractSet<K>(){

            @Override
            public int size() {
                return AbstractLRSProxyMap.this.size();
            }

            @Override
            public boolean remove(Object o) {
                return AbstractLRSProxyMap.this.remove(o) != null;
            }

            @Override
            public Iterator<K> iterator() {
                return AbstractLRSProxyMap.this.iterator(0);
            }
        };
    }

    @Override
    public Collection<V> values() {
        return new AbstractCollection<V>(){

            @Override
            public int size() {
                return AbstractLRSProxyMap.this.size();
            }

            @Override
            public Iterator<V> iterator() {
                return AbstractLRSProxyMap.this.iterator(1);
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public int size() {
                return AbstractLRSProxyMap.this.size();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return AbstractLRSProxyMap.this.iterator(2);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object writeReplace() throws ObjectStreamException {
        Itr itr = this.iterator(2);
        try {
            HashMap map = new HashMap();
            while (itr.hasNext()) {
                Map.Entry entry = (Map.Entry)itr.next();
                map.put(entry.getKey(), entry.getValue());
            }
            HashMap hashMap = map;
            return hashMap;
        }
        finally {
            itr.close();
        }
    }

    protected abstract boolean hasKey(Object var1);

    protected abstract boolean hasValue(Object var1);

    protected abstract Collection<K> keys(Object var1);

    protected abstract V value(Object var1);

    protected abstract Iterator<?> itr();

    protected abstract int count();

    private Itr iterator(int mode) {
        this._iterated = true;
        IteratorChain chain = new IteratorChain();
        if (this._map != null) {
            chain.addIterator(new ArrayList<Map.Entry<K, V>>(this._map.entrySet()).iterator());
        }
        chain.addIterator((Iterator)new FilterIterator(this.itr(), (Predicate)this));
        return new Itr(mode, chain);
    }

    @Override
    public boolean evaluate(Object obj) {
        Map.Entry entry = (Map.Entry)obj;
        return (this._ct.getTrackKeys() && !this._ct.getRemoved().contains(entry.getKey()) || !this._ct.getTrackKeys() && !this._ct.getRemoved().contains(entry.getValue())) && (this._map == null || !this._map.containsKey(entry.getKey()));
    }

    @Override
    public boolean isTracking() {
        return this._ct.isTracking();
    }

    @Override
    public void startTracking() {
        this._ct.startTracking();
        this.reset();
    }

    @Override
    public void stopTracking() {
        this._ct.stopTracking();
        this.reset();
    }

    private void reset() {
        if (this._map != null) {
            this._map.clear();
        }
        if (this._count != Integer.MAX_VALUE) {
            this._count = -1;
        }
    }

    @Override
    public boolean getTrackKeys() {
        return this._ct.getTrackKeys();
    }

    @Override
    public void setTrackKeys(boolean keys) {
        this._ct.setTrackKeys(keys);
    }

    @Override
    public Collection getAdded() {
        return this._ct.getAdded();
    }

    @Override
    public Collection getRemoved() {
        return this._ct.getRemoved();
    }

    @Override
    public Collection getChanged() {
        return this._ct.getChanged();
    }

    @Override
    public void added(Object key, Object val) {
        this._ct.added(key, val);
    }

    @Override
    public void removed(Object key, Object val) {
        this._ct.removed(key, val);
    }

    @Override
    public void changed(Object key, Object orig, Object val) {
        this._ct.changed(key, orig, val);
    }

    @Override
    public int getNextSequence() {
        return this._ct.getNextSequence();
    }

    @Override
    public void setNextSequence(int seq) {
        this._ct.setNextSequence(seq);
    }

    private class Itr
    implements Iterator,
    Closeable {
        private static final int OPEN = 0;
        private static final int LAST_ELEM = 1;
        private static final int CLOSED = 2;
        private final int _mode;
        private final IteratorChain _itr;
        private Map.Entry _last = null;
        private int _state = 0;

        public Itr(int mode, IteratorChain itr) {
            this._mode = mode;
            this._itr = itr;
        }

        @Override
        public boolean hasNext() {
            if (this._state != 0) {
                return false;
            }
            if (!this._itr.hasNext()) {
                this.free();
                this._state = 1;
                return false;
            }
            return true;
        }

        public Object next() {
            if (this._state != 0) {
                throw new NoSuchElementException();
            }
            this._last = (Map.Entry)this._itr.next();
            switch (this._mode) {
                case 0: {
                    return this._last.getKey();
                }
                case 1: {
                    return this._last.getValue();
                }
            }
            return this._last;
        }

        @Override
        public void remove() {
            if (this._state == 2 || this._last == null) {
                throw new NoSuchElementException();
            }
            Proxies.dirty(AbstractLRSProxyMap.this, false);
            Proxies.removed(AbstractLRSProxyMap.this, this._last.getKey(), true);
            Proxies.removed(AbstractLRSProxyMap.this, this._last.getValue(), false);
            Object key = this._last.getKey();
            Object value = this._last.getValue();
            if (AbstractLRSProxyMap.this._map != null) {
                AbstractLRSProxyMap.this._map.remove(key);
            }
            AbstractLRSProxyMap.this._ct.removed(key, value);
            this._last = null;
        }

        @Override
        public void close() {
            this.free();
            this._state = 2;
        }

        private void free() {
            if (this._state != 0) {
                return;
            }
            List itrs = this._itr.getIterators();
            for (int i = 0; i < itrs.size(); ++i) {
                Iterator itr = (Iterator)itrs.get(i);
                if (itr instanceof FilterIterator) {
                    itr = ((FilterIterator)itr).getIterator();
                }
                ImplHelper.close(itr);
            }
        }

        protected void finalize() {
            this.close();
        }
    }
}

