/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.sql;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.DBDictionary;

public class AccessDictionary
extends DBDictionary {
    public AccessDictionary() {
        this.platform = "Microsoft Access";
        this.joinSyntax = 1;
        this.validationSQL = "SELECT 1";
        this.reservedWordSet.add("VALUE");
        this.supportsAutoAssign = true;
        this.autoAssignTypeName = "COUNTER";
        this.lastGeneratedKeyQuery = "SELECT @@identity";
        this.maxTableNameLength = 64;
        this.maxColumnNameLength = 64;
        this.maxIndexNameLength = 64;
        this.maxConstraintNameLength = 64;
        this.useGetBytesForBlobs = true;
        this.useGetBestRowIdentifierForPrimaryKeys = true;
        this.binaryTypeName = "LONGBINARY";
        this.blobTypeName = "LONGBINARY";
        this.longVarbinaryTypeName = "LONGBINARY";
        this.clobTypeName = "LONGCHAR";
        this.longVarcharTypeName = "LONGCHAR";
        this.bigintTypeName = "REAL";
        this.numericTypeName = "REAL";
        this.integerTypeName = "INTEGER";
        this.smallintTypeName = "SMALLINT";
        this.tinyintTypeName = "SMALLINT";
        this.supportsForeignKeys = false;
        this.supportsDeferredConstraints = false;
        this.maxIndexesPerTable = 32;
        this.substringFunctionName = "MID";
        this.setLeadingDelimiter("[");
        this.setTrailingDelimiter("]");
    }

    @Override
    public void setLong(PreparedStatement stmnt, int idx, long val, Column col) throws SQLException {
        if (val < Integer.MAX_VALUE && val > Integer.MIN_VALUE) {
            stmnt.setInt(idx, (int)val);
        } else {
            stmnt.setDouble(idx, val);
        }
    }
}

