/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.db.JdbcDBClientConstants;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;

public class JdbcDBCreateTable
implements JdbcDBClientConstants {
    private static void usageMessage() {
        System.out.println("Create Table Client. Options:");
        System.out.println("  -p   key=value properties defined.");
        System.out.println("  -P   location of the properties file to load.");
        System.out.println("  -n   name of the table.");
        System.out.println("  -f   number of fields (default 10).");
    }

    private static void createTable(Properties props, String tablename) throws SQLException {
        String driver = props.getProperty("db.driver");
        String username = props.getProperty("db.user");
        String password = props.getProperty("db.passwd", "");
        String url = props.getProperty("db.url");
        int fieldcount = Integer.parseInt(props.getProperty("fieldcount", "10"));
        if (driver == null || username == null || url == null) {
            throw new SQLException("Missing connection information.");
        }
        Connection conn = null;
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(url, username, password);
            Statement stmt = conn.createStatement();
            StringBuilder sql2 = new StringBuilder("DROP TABLE IF EXISTS ");
            sql2.append(tablename);
            sql2.append(";");
            stmt.execute(sql2.toString());
            sql2 = new StringBuilder("CREATE TABLE ");
            sql2.append(tablename);
            sql2.append(" (KEY VARCHAR PRIMARY KEY");
            for (int idx = 0; idx < fieldcount; ++idx) {
                sql2.append(", FIELD");
                sql2.append(idx);
                sql2.append(" VARCHAR");
            }
            sql2.append(");");
            stmt.execute(sql2.toString());
            System.out.println("Table " + tablename + " created..");
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("JDBC Driver class not found.");
        }
        finally {
            if (conn != null) {
                System.out.println("Closing database connection.");
                conn.close();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JdbcDBCreateTable.usageMessage();
            System.exit(0);
        }
        String tablename = null;
        int fieldcount = -1;
        Properties props = new Properties();
        Properties fileprops = new Properties();
        int argindex = 0;
        while (args[argindex].startsWith("-")) {
            if (args[argindex].compareTo("-P") == 0) {
                if (++argindex >= args.length) {
                    JdbcDBCreateTable.usageMessage();
                    System.exit(0);
                }
                String propfile = args[argindex];
                ++argindex;
                Properties myfileprops = new Properties();
                try {
                    myfileprops.load(new FileInputStream(propfile));
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    System.exit(0);
                }
                Enumeration<?> e = myfileprops.propertyNames();
                while (e.hasMoreElements()) {
                    String prop = (String)e.nextElement();
                    fileprops.setProperty(prop, myfileprops.getProperty(prop));
                }
            } else if (args[argindex].compareTo("-p") == 0) {
                int eq;
                if (++argindex >= args.length) {
                    JdbcDBCreateTable.usageMessage();
                    System.exit(0);
                }
                if ((eq = args[argindex].indexOf(61)) < 0) {
                    JdbcDBCreateTable.usageMessage();
                    System.exit(0);
                }
                String name = args[argindex].substring(0, eq);
                String value = args[argindex].substring(eq + 1);
                props.put(name, value);
                ++argindex;
            } else if (args[argindex].compareTo("-n") == 0) {
                if (++argindex >= args.length) {
                    JdbcDBCreateTable.usageMessage();
                    System.exit(0);
                }
                tablename = args[argindex++];
            } else if (args[argindex].compareTo("-f") == 0) {
                if (++argindex >= args.length) {
                    JdbcDBCreateTable.usageMessage();
                    System.exit(0);
                }
                try {
                    fieldcount = Integer.parseInt(args[argindex++]);
                }
                catch (NumberFormatException e) {
                    System.err.println("Invalid number for field count");
                    JdbcDBCreateTable.usageMessage();
                    System.exit(1);
                }
            } else {
                System.out.println("Unknown option " + args[argindex]);
                JdbcDBCreateTable.usageMessage();
                System.exit(0);
            }
            if (argindex < args.length) continue;
        }
        if (argindex != args.length) {
            JdbcDBCreateTable.usageMessage();
            System.exit(0);
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            fileprops.setProperty(prop, props.getProperty(prop));
        }
        props = fileprops;
        if (tablename == null) {
            System.err.println("table name missing.");
            JdbcDBCreateTable.usageMessage();
            System.exit(1);
        }
        if (fieldcount > 0) {
            props.setProperty("fieldcount", String.valueOf(fieldcount));
        }
        try {
            JdbcDBCreateTable.createTable(props, tablename);
        }
        catch (SQLException e2) {
            System.err.println("Error in creating table. " + e2);
            System.exit(1);
        }
    }
}

