/*
 * Decompiled with CFR 0.152.
 */
package com.yahoo.ycsb.db;

import com.yahoo.ycsb.db.JdbcDBClientConstants;
import java.io.FileInputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;

public class JdbcDBCli
implements JdbcDBClientConstants {
    private static void usageMessage() {
        System.out.println("JdbcCli. Options:");
        System.out.println("  -p   key=value properties defined.");
        System.out.println("  -P   location of the properties file to load.");
        System.out.println("  -c   SQL command to execute.");
    }

    private static void executeCommand(Properties props, String sql2) throws SQLException {
        String driver = props.getProperty("db.driver");
        String username = props.getProperty("db.user");
        String password = props.getProperty("db.passwd", "");
        String url = props.getProperty("db.url");
        if (driver == null || username == null || url == null) {
            throw new SQLException("Missing connection information.");
        }
        Connection conn = null;
        try {
            Class.forName(driver);
            conn = DriverManager.getConnection(url, username, password);
            Statement stmt = conn.createStatement();
            stmt.execute(sql2);
            System.out.println("Command  \"" + sql2 + "\" successfully executed.");
        }
        catch (ClassNotFoundException e) {
            throw new SQLException("JDBC Driver class not found.");
        }
        finally {
            if (conn != null) {
                System.out.println("Closing database connection.");
                conn.close();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            JdbcDBCli.usageMessage();
            System.exit(0);
        }
        Properties props = new Properties();
        Properties fileprops = new Properties();
        String sql2 = null;
        int argindex = 0;
        while (args[argindex].startsWith("-")) {
            if (args[argindex].compareTo("-P") == 0) {
                if (++argindex >= args.length) {
                    JdbcDBCli.usageMessage();
                    System.exit(0);
                }
                String propfile = args[argindex];
                ++argindex;
                Properties myfileprops = new Properties();
                try {
                    myfileprops.load(new FileInputStream(propfile));
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                    System.exit(0);
                }
                Enumeration<?> e = myfileprops.propertyNames();
                while (e.hasMoreElements()) {
                    String prop = (String)e.nextElement();
                    fileprops.setProperty(prop, myfileprops.getProperty(prop));
                }
            } else if (args[argindex].compareTo("-p") == 0) {
                int eq;
                if (++argindex >= args.length) {
                    JdbcDBCli.usageMessage();
                    System.exit(0);
                }
                if ((eq = args[argindex].indexOf(61)) < 0) {
                    JdbcDBCli.usageMessage();
                    System.exit(0);
                }
                String name = args[argindex].substring(0, eq);
                String value = args[argindex].substring(eq + 1);
                props.put(name, value);
                ++argindex;
            } else if (args[argindex].compareTo("-c") == 0) {
                if (++argindex >= args.length) {
                    JdbcDBCli.usageMessage();
                    System.exit(0);
                }
                sql2 = args[argindex++];
            } else {
                System.out.println("Unknown option " + args[argindex]);
                JdbcDBCli.usageMessage();
                System.exit(0);
            }
            if (argindex < args.length) continue;
        }
        if (argindex != args.length) {
            JdbcDBCli.usageMessage();
            System.exit(0);
        }
        Enumeration<?> e = props.propertyNames();
        while (e.hasMoreElements()) {
            String prop = (String)e.nextElement();
            fileprops.setProperty(prop, props.getProperty(prop));
        }
        if (sql2 == null) {
            System.err.println("Missing command.");
            JdbcDBCli.usageMessage();
            System.exit(1);
        }
        try {
            JdbcDBCli.executeCommand(fileprops, sql2);
        }
        catch (SQLException e2) {
            System.err.println("Error in executing command. " + e2);
            System.exit(1);
        }
    }
}

