/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.support;

import java.io.IOException;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.CachedStreamOutput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseOptions;

public class TransportStreams {
    public static final int HEADER_SIZE = 13;
    public static final byte[] HEADER_PLACEHOLDER = new byte[13];
    private static final byte STATUS_REQRES = 1;
    private static final byte STATUS_ERROR = 2;
    private static final byte STATUS_COMPRESS = 4;

    public static void writeHeader(byte[] data, int dataLength, long requestId, byte status) {
        TransportStreams.writeInt(data, 0, dataLength - 4);
        TransportStreams.writeLong(data, 4, requestId);
        data[12] = status;
    }

    private static void writeLong(byte[] buffer, int offset, long value) {
        buffer[offset++] = (byte)(value >> 56);
        buffer[offset++] = (byte)(value >> 48);
        buffer[offset++] = (byte)(value >> 40);
        buffer[offset++] = (byte)(value >> 32);
        buffer[offset++] = (byte)(value >> 24);
        buffer[offset++] = (byte)(value >> 16);
        buffer[offset++] = (byte)(value >> 8);
        buffer[offset] = (byte)value;
    }

    private static void writeInt(byte[] buffer, int offset, int value) {
        buffer[offset++] = (byte)(value >> 24);
        buffer[offset++] = (byte)(value >> 16);
        buffer[offset++] = (byte)(value >> 8);
        buffer[offset] = (byte)value;
    }

    public static boolean statusIsRequest(byte value) {
        return (value & 1) == 0;
    }

    public static byte statusSetRequest(byte value) {
        value = (byte)(value & 0xFFFFFFFE);
        return value;
    }

    public static byte statusSetResponse(byte value) {
        value = (byte)(value | 1);
        return value;
    }

    public static boolean statusIsError(byte value) {
        return (value & 2) != 0;
    }

    public static byte statusSetError(byte value) {
        value = (byte)(value | 2);
        return value;
    }

    public static boolean statusIsCompress(byte value) {
        return (value & 4) != 0;
    }

    public static byte statusSetCompress(byte value) {
        value = (byte)(value | 4);
        return value;
    }

    public static void buildRequest(CachedStreamOutput.Entry cachedEntry, long requestId, String action, Streamable message, TransportRequestOptions options) throws IOException {
        byte status = 0;
        status = TransportStreams.statusSetRequest(status);
        if (options.compress()) {
            status = TransportStreams.statusSetCompress(status);
            StreamOutput stream = cachedEntry.cachedHandles(CompressorFactory.defaultCompressor());
            cachedEntry.bytes().write(HEADER_PLACEHOLDER);
            stream.writeUTF(action);
            message.writeTo(stream);
            stream.close();
        } else {
            StreamOutput stream = cachedEntry.cachedHandles();
            cachedEntry.bytes().write(HEADER_PLACEHOLDER);
            stream.writeUTF(action);
            message.writeTo(stream);
            stream.close();
        }
        TransportStreams.writeHeader(cachedEntry.bytes().underlyingBytes(), cachedEntry.bytes().size(), requestId, status);
    }

    public static void buildResponse(CachedStreamOutput.Entry cachedEntry, long requestId, Streamable message, TransportResponseOptions options) throws IOException {
        byte status = 0;
        status = TransportStreams.statusSetResponse(status);
        if (options.compress()) {
            status = TransportStreams.statusSetCompress(status);
            StreamOutput stream = cachedEntry.cachedHandles(CompressorFactory.defaultCompressor());
            cachedEntry.bytes().write(HEADER_PLACEHOLDER);
            message.writeTo(stream);
            stream.close();
        } else {
            StreamOutput stream = cachedEntry.cachedHandles();
            cachedEntry.bytes().write(HEADER_PLACEHOLDER);
            message.writeTo(stream);
            stream.close();
        }
        TransportStreams.writeHeader(cachedEntry.bytes().underlyingBytes(), cachedEntry.bytes().size(), requestId, status);
    }
}

