/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.highlight;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class HighlightBuilder
implements ToXContent {
    private List<Field> fields;
    private String tagsSchema;
    private String[] preTags;
    private String[] postTags;
    private String order;
    private String encoder;
    private Boolean requireFieldMatch;

    public HighlightBuilder field(String name) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(new Field(name));
        return this;
    }

    public HighlightBuilder field(String name, int fragmentSize) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(new Field(name).fragmentSize(fragmentSize));
        return this;
    }

    public HighlightBuilder field(String name, int fragmentSize, int numberOfFragments) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(new Field(name).fragmentSize(fragmentSize).numOfFragments(numberOfFragments));
        return this;
    }

    public HighlightBuilder field(String name, int fragmentSize, int numberOfFragments, int fragmentOffset) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(new Field(name).fragmentSize(fragmentSize).numOfFragments(numberOfFragments).fragmentOffset(fragmentOffset));
        return this;
    }

    public HighlightBuilder field(Field field) {
        if (this.fields == null) {
            this.fields = Lists.newArrayList();
        }
        this.fields.add(field);
        return this;
    }

    public HighlightBuilder tagsSchema(String schemaName) {
        this.tagsSchema = schemaName;
        return this;
    }

    public HighlightBuilder encoder(String encoder) {
        this.encoder = encoder;
        return this;
    }

    public HighlightBuilder preTags(String ... preTags) {
        this.preTags = preTags;
        return this;
    }

    public HighlightBuilder postTags(String ... postTags) {
        this.postTags = postTags;
        return this;
    }

    public HighlightBuilder order(String order) {
        this.order = order;
        return this;
    }

    public HighlightBuilder requireFieldMatch(boolean requireFieldMatch) {
        this.requireFieldMatch = requireFieldMatch;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("highlight");
        if (this.tagsSchema != null) {
            builder.field("tags_schema", this.tagsSchema);
        }
        if (this.preTags != null) {
            builder.array("pre_tags", this.preTags);
        }
        if (this.postTags != null) {
            builder.array("post_tags", this.postTags);
        }
        if (this.order != null) {
            builder.field("order", this.order);
        }
        if (this.encoder != null) {
            builder.field("encoder", this.encoder);
        }
        if (this.requireFieldMatch != null) {
            builder.field("require_field_match", (Object)this.requireFieldMatch);
        }
        if (this.fields != null) {
            builder.startObject("fields");
            for (Field field : this.fields) {
                builder.startObject(field.name());
                if (field.fragmentSize != -1) {
                    builder.field("fragment_size", field.fragmentSize);
                }
                if (field.numOfFragments != -1) {
                    builder.field("number_of_fragments", field.numOfFragments);
                }
                if (field.fragmentOffset != -1) {
                    builder.field("fragment_offset", field.fragmentOffset);
                }
                if (field.requireFieldMatch != null) {
                    builder.field("require_field_match", (Object)field.requireFieldMatch);
                }
                builder.endObject();
            }
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public static class Field {
        final String name;
        int fragmentSize = -1;
        int fragmentOffset = -1;
        int numOfFragments = -1;
        Boolean requireFieldMatch;

        private Field(String name) {
            this.name = name;
        }

        public String name() {
            return this.name;
        }

        public Field fragmentSize(int fragmentSize) {
            this.fragmentSize = fragmentSize;
            return this;
        }

        public Field fragmentOffset(int fragmentOffset) {
            this.fragmentOffset = fragmentOffset;
            return this;
        }

        public Field numOfFragments(int numOfFragments) {
            this.numOfFragments = numOfFragments;
            return this;
        }

        public Field requireFieldMatch(boolean requireFieldMatch) {
            this.requireFieldMatch = requireFieldMatch;
            return this;
        }
    }
}

