/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.util.List;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;

public class RecoveryStatus {
    volatile Thread recoveryThread;
    volatile boolean canceled;
    volatile boolean sentCanceledToSource;
    ConcurrentMap<String, IndexOutput> openIndexOutputs = ConcurrentCollections.newConcurrentMap();
    ConcurrentMap<String, String> checksums = ConcurrentCollections.newConcurrentMap();
    final long startTime = System.currentTimeMillis();
    long time;
    List<String> phase1FileNames;
    List<Long> phase1FileSizes;
    List<String> phase1ExistingFileNames;
    List<Long> phase1ExistingFileSizes;
    long phase1TotalSize;
    long phase1ExistingTotalSize;
    volatile Stage stage = Stage.INIT;
    volatile long currentTranslogOperations = 0L;
    AtomicLong currentFilesSize = new AtomicLong();

    public long startTime() {
        return this.startTime;
    }

    public long time() {
        return this.time;
    }

    public long phase1TotalSize() {
        return this.phase1TotalSize;
    }

    public long phase1ExistingTotalSize() {
        return this.phase1ExistingTotalSize;
    }

    public Stage stage() {
        return this.stage;
    }

    public long currentTranslogOperations() {
        return this.currentTranslogOperations;
    }

    public long currentFilesSize() {
        return this.currentFilesSize.get();
    }

    public static enum Stage {
        INIT,
        INDEX,
        TRANSLOG,
        FINALIZE,
        DONE;

    }
}

