/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CachingTokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FuzzyQuery;
import org.apache.lucene.search.MultiPhraseQuery;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.ElasticSearchIllegalStateException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.FastStringReader;
import org.elasticsearch.common.lucene.search.MatchNoDocsQuery;
import org.elasticsearch.common.lucene.search.MultiPhrasePrefixQuery;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.query.support.QueryParsers;

public class TextQueryParser {
    private final QueryParseContext parseContext;
    private final String fieldName;
    private final String text;
    private String analyzer;
    private BooleanClause.Occur occur = BooleanClause.Occur.SHOULD;
    private boolean enablePositionIncrements = true;
    private int phraseSlop = 0;
    private String fuzziness = null;
    private int fuzzyPrefixLength = 0;
    private int maxExpansions = Integer.MAX_VALUE;
    private MultiTermQuery.RewriteMethod rewriteMethod;
    private MultiTermQuery.RewriteMethod fuzzyRewriteMethod;

    public TextQueryParser(QueryParseContext parseContext, String fieldName, String text) {
        this.parseContext = parseContext;
        this.fieldName = fieldName;
        this.text = text;
    }

    public void setAnalyzer(String analyzer) {
        this.analyzer = analyzer;
    }

    public void setOccur(BooleanClause.Occur occur) {
        this.occur = occur;
    }

    public void setEnablePositionIncrements(boolean enablePositionIncrements) {
        this.enablePositionIncrements = enablePositionIncrements;
    }

    public void setPhraseSlop(int phraseSlop) {
        this.phraseSlop = phraseSlop;
    }

    public void setFuzziness(String fuzziness) {
        this.fuzziness = fuzziness;
    }

    public void setFuzzyPrefixLength(int fuzzyPrefixLength) {
        this.fuzzyPrefixLength = fuzzyPrefixLength;
    }

    public void setMaxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
    }

    public void setRewriteMethod(MultiTermQuery.RewriteMethod rewriteMethod) {
        this.rewriteMethod = rewriteMethod;
    }

    public void setFuzzyRewriteMethod(MultiTermQuery.RewriteMethod fuzzyRewriteMethod) {
        this.fuzzyRewriteMethod = fuzzyRewriteMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query parse(Type type) {
        TokenStream source;
        Term fieldTerm;
        FieldMapper mapper = null;
        MapperService.SmartNameFieldMappers smartNameFieldMappers = this.parseContext.smartFieldMappers(this.fieldName);
        if (smartNameFieldMappers != null && smartNameFieldMappers.hasMapper()) {
            mapper = smartNameFieldMappers.mapper();
            fieldTerm = mapper.names().indexNameTerm();
        } else {
            fieldTerm = new Term(this.fieldName);
        }
        if (mapper != null && mapper.useFieldQueryWithQueryString()) {
            if (smartNameFieldMappers.explicitTypeInNameWithDocMapper()) {
                String[] previousTypes = QueryParseContext.setTypesWithPrevious(new String[]{smartNameFieldMappers.docMapper().type()});
                try {
                    Query query = QueryParsers.wrapSmartNameQuery(mapper.fieldQuery(this.text, this.parseContext), smartNameFieldMappers, this.parseContext);
                    return query;
                }
                finally {
                    QueryParseContext.setTypes(previousTypes);
                }
            }
            return QueryParsers.wrapSmartNameQuery(mapper.fieldQuery(this.text, this.parseContext), smartNameFieldMappers, this.parseContext);
        }
        Analyzer analyzer = null;
        if (this.analyzer == null) {
            if (mapper != null) {
                analyzer = mapper.searchAnalyzer();
            }
            if (analyzer == null && smartNameFieldMappers != null) {
                analyzer = smartNameFieldMappers.searchAnalyzer();
            }
            if (analyzer == null) {
                analyzer = this.parseContext.mapperService().searchAnalyzer();
            }
        } else {
            analyzer = this.parseContext.mapperService().analysisService().analyzer(this.analyzer);
            if (analyzer == null) {
                throw new ElasticSearchIllegalArgumentException("No analyzer found for [" + this.analyzer + "]");
            }
        }
        try {
            source = analyzer.reusableTokenStream(fieldTerm.field(), new FastStringReader(this.text));
            source.reset();
        }
        catch (IOException e) {
            source = analyzer.tokenStream(fieldTerm.field(), new FastStringReader(this.text));
        }
        CachingTokenFilter buffer = new CachingTokenFilter(source);
        CharTermAttribute termAtt = null;
        PositionIncrementAttribute posIncrAtt = null;
        int numTokens = 0;
        boolean success = false;
        try {
            buffer.reset();
            success = true;
        }
        catch (IOException e) {
            // empty catch block
        }
        if (success) {
            if (buffer.hasAttribute(CharTermAttribute.class)) {
                termAtt = buffer.getAttribute(CharTermAttribute.class);
            }
            if (buffer.hasAttribute(PositionIncrementAttribute.class)) {
                posIncrAtt = buffer.getAttribute(PositionIncrementAttribute.class);
            }
        }
        int positionCount = 0;
        boolean severalTokensAtSamePosition = false;
        boolean hasMoreTokens = false;
        if (termAtt != null) {
            try {
                hasMoreTokens = buffer.incrementToken();
                while (hasMoreTokens) {
                    int positionIncrement;
                    ++numTokens;
                    int n = positionIncrement = posIncrAtt != null ? posIncrAtt.getPositionIncrement() : 1;
                    if (positionIncrement != 0) {
                        positionCount += positionIncrement;
                    } else {
                        severalTokensAtSamePosition = true;
                    }
                    hasMoreTokens = buffer.incrementToken();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        try {
            buffer.reset();
            source.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if (numTokens == 0) {
            return MatchNoDocsQuery.INSTANCE;
        }
        if (type == Type.BOOLEAN) {
            if (numTokens == 1) {
                String term = null;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                }
                catch (IOException e) {
                    // empty catch block
                }
                Query q = this.newTermQuery(mapper, fieldTerm.createTerm(term));
                return QueryParsers.wrapSmartNameQuery(q, smartNameFieldMappers, this.parseContext);
            }
            BooleanQuery q = new BooleanQuery(positionCount == 1);
            for (int i = 0; i < numTokens; ++i) {
                String term = null;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                }
                catch (IOException e) {
                    // empty catch block
                }
                Query currentQuery = this.newTermQuery(mapper, fieldTerm.createTerm(term));
                q.add(currentQuery, this.occur);
            }
            return QueryParsers.wrapSmartNameQuery(q, smartNameFieldMappers, this.parseContext);
        }
        if (type == Type.PHRASE) {
            if (severalTokensAtSamePosition) {
                MultiPhraseQuery mpq = new MultiPhraseQuery();
                mpq.setSlop(this.phraseSlop);
                ArrayList<Term> multiTerms = new ArrayList<Term>();
                int position = -1;
                for (int i = 0; i < numTokens; ++i) {
                    String term = null;
                    int positionIncrement = 1;
                    try {
                        boolean hasNext = buffer.incrementToken();
                        assert (hasNext);
                        term = termAtt.toString();
                        if (posIncrAtt != null) {
                            positionIncrement = posIncrAtt.getPositionIncrement();
                        }
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    if (positionIncrement > 0 && multiTerms.size() > 0) {
                        if (this.enablePositionIncrements) {
                            mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
                        } else {
                            mpq.add(multiTerms.toArray(new Term[multiTerms.size()]));
                        }
                        multiTerms.clear();
                    }
                    position += positionIncrement;
                    multiTerms.add(fieldTerm.createTerm(term));
                }
                if (this.enablePositionIncrements) {
                    mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
                } else {
                    mpq.add(multiTerms.toArray(new Term[multiTerms.size()]));
                }
                return QueryParsers.wrapSmartNameQuery(mpq, smartNameFieldMappers, this.parseContext);
            }
            PhraseQuery pq = new PhraseQuery();
            pq.setSlop(this.phraseSlop);
            int position = -1;
            for (int i = 0; i < numTokens; ++i) {
                String term = null;
                int positionIncrement = 1;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                    if (posIncrAtt != null) {
                        positionIncrement = posIncrAtt.getPositionIncrement();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (this.enablePositionIncrements) {
                    pq.add(fieldTerm.createTerm(term), position += positionIncrement);
                    continue;
                }
                pq.add(fieldTerm.createTerm(term));
            }
            return QueryParsers.wrapSmartNameQuery(pq, smartNameFieldMappers, this.parseContext);
        }
        if (type == Type.PHRASE_PREFIX) {
            MultiPhrasePrefixQuery mpq = new MultiPhrasePrefixQuery();
            mpq.setSlop(this.phraseSlop);
            mpq.setMaxExpansions(this.maxExpansions);
            ArrayList<Term> multiTerms = new ArrayList<Term>();
            int position = -1;
            for (int i = 0; i < numTokens; ++i) {
                String term = null;
                int positionIncrement = 1;
                try {
                    boolean hasNext = buffer.incrementToken();
                    assert (hasNext);
                    term = termAtt.toString();
                    if (posIncrAtt != null) {
                        positionIncrement = posIncrAtt.getPositionIncrement();
                    }
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (positionIncrement > 0 && multiTerms.size() > 0) {
                    if (this.enablePositionIncrements) {
                        mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
                    } else {
                        mpq.add(multiTerms.toArray(new Term[multiTerms.size()]));
                    }
                    multiTerms.clear();
                }
                position += positionIncrement;
                multiTerms.add(fieldTerm.createTerm(term));
            }
            if (this.enablePositionIncrements) {
                mpq.add(multiTerms.toArray(new Term[multiTerms.size()]), position);
            } else {
                mpq.add(multiTerms.toArray(new Term[multiTerms.size()]));
            }
            return QueryParsers.wrapSmartNameQuery(mpq, smartNameFieldMappers, this.parseContext);
        }
        throw new ElasticSearchIllegalStateException("No type found for [" + (Object)((Object)type) + "]");
    }

    private Query newTermQuery(@Nullable FieldMapper mapper, Term term) {
        Query termQuery;
        if (this.fuzziness != null) {
            Query query;
            if (mapper != null && (query = mapper.fuzzyQuery(term.text(), this.fuzziness, this.fuzzyPrefixLength, this.maxExpansions)) instanceof FuzzyQuery) {
                QueryParsers.setRewriteMethod((MultiTermQuery)((FuzzyQuery)query), this.fuzzyRewriteMethod);
            }
            query = new FuzzyQuery(term, Float.parseFloat(this.fuzziness), this.fuzzyPrefixLength, this.maxExpansions);
            QueryParsers.setRewriteMethod((MultiTermQuery)query, this.rewriteMethod);
            return query;
        }
        if (mapper != null && (termQuery = mapper.queryStringTermQuery(term)) != null) {
            return termQuery;
        }
        return new TermQuery(term);
    }

    public static enum Type {
        BOOLEAN,
        PHRASE,
        PHRASE_PREFIX;

    }
}

