/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.query;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.BaseQueryBuilder;
import org.elasticsearch.index.query.BoostableQueryBuilder;

public class TextQueryBuilder
extends BaseQueryBuilder
implements BoostableQueryBuilder<TextQueryBuilder> {
    private final String name;
    private final Object text;
    private Type type;
    private Operator operator;
    private String analyzer;
    private Float boost;
    private Integer slop;
    private String fuzziness;
    private Integer prefixLength;
    private Integer maxExpansions;
    private String minimumShouldMatch;
    private String rewrite = null;
    private String fuzzyRewrite = null;

    public TextQueryBuilder(String name, Object text) {
        this.name = name;
        this.text = text;
    }

    public TextQueryBuilder type(Type type) {
        this.type = type;
        return this;
    }

    public TextQueryBuilder operator(Operator operator) {
        this.operator = operator;
        return this;
    }

    public TextQueryBuilder analyzer(String analyzer) {
        this.analyzer = analyzer;
        return this;
    }

    @Override
    public TextQueryBuilder boost(float boost) {
        this.boost = Float.valueOf(boost);
        return this;
    }

    public TextQueryBuilder slop(int slop) {
        this.slop = slop;
        return this;
    }

    public TextQueryBuilder fuzziness(Object fuzziness) {
        this.fuzziness = fuzziness.toString();
        return this;
    }

    public TextQueryBuilder prefixLength(int prefixLength) {
        this.prefixLength = prefixLength;
        return this;
    }

    public TextQueryBuilder maxExpansions(int maxExpansions) {
        this.maxExpansions = maxExpansions;
        return this;
    }

    public TextQueryBuilder minimumShouldMatch(String minimumShouldMatch) {
        this.minimumShouldMatch = minimumShouldMatch;
        return this;
    }

    public TextQueryBuilder rewrite(String rewrite) {
        this.rewrite = rewrite;
        return this;
    }

    public TextQueryBuilder fuzzyRewrite(String fuzzyRewrite) {
        this.fuzzyRewrite = fuzzyRewrite;
        return this;
    }

    @Override
    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("text");
        builder.startObject(this.name);
        builder.field("query", this.text);
        if (this.type != null) {
            builder.field("type", this.type.toString().toLowerCase(Locale.ENGLISH));
        }
        if (this.operator != null) {
            builder.field("operator", this.operator.toString());
        }
        if (this.analyzer != null) {
            builder.field("analyzer", this.analyzer);
        }
        if (this.boost != null) {
            builder.field("boost", this.boost);
        }
        if (this.slop != null) {
            builder.field("slop", this.slop);
        }
        if (this.fuzziness != null) {
            builder.field("fuzziness", this.fuzziness);
        }
        if (this.prefixLength != null) {
            builder.field("prefix_length", this.prefixLength);
        }
        if (this.maxExpansions != null) {
            builder.field("max_expansions", this.maxExpansions);
        }
        if (this.minimumShouldMatch != null) {
            builder.field("minimum_should_match", this.minimumShouldMatch);
        }
        if (this.rewrite != null) {
            builder.field("rewrite", this.rewrite);
        }
        if (this.fuzzyRewrite != null) {
            builder.field("fuzzy_rewrite", this.fuzzyRewrite);
        }
        builder.endObject();
        builder.endObject();
    }

    public static enum Type {
        BOOLEAN,
        PHRASE,
        PHRASE_PREFIX;

    }

    public static enum Operator {
        OR,
        AND;

    }
}

