/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.internal;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.lucene.all.AllField;
import org.elasticsearch.common.lucene.all.AllTermQuery;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.InternalMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.RootMapper;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;

public class AllFieldMapper
extends AbstractFieldMapper<Void>
implements InternalMapper,
RootMapper {
    public static final String NAME = "_all";
    public static final String CONTENT_TYPE = "_all";
    private boolean enabled;

    public AllFieldMapper() {
        this("_all", Defaults.STORE, Defaults.TERM_VECTOR, false, false, null, null, true);
    }

    protected AllFieldMapper(String name, Field.Store store, Field.TermVector termVector, boolean omitNorms, boolean omitTermFreqAndPositions, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer, boolean enabled) {
        super(new FieldMapper.Names(name, name, name, name), Field.Index.ANALYZED, store, termVector, 1.0f, omitNorms, omitTermFreqAndPositions, indexAnalyzer, searchAnalyzer);
        this.enabled = enabled;
    }

    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public Query queryStringTermQuery(Term term) {
        return new AllTermQuery(term);
    }

    @Override
    public Query fieldQuery(String value, QueryParseContext context) {
        return new AllTermQuery(this.names().createIndexNameTerm(value));
    }

    @Override
    public void preParse(ParseContext context) throws IOException {
    }

    @Override
    public void postParse(ParseContext context) throws IOException {
        super.parse(context);
    }

    @Override
    public void parse(ParseContext context) throws IOException {
    }

    @Override
    public void validate(ParseContext context) throws MapperParsingException {
    }

    @Override
    public boolean includeInObject() {
        return true;
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        if (!this.enabled) {
            return null;
        }
        context.allEntries().reset();
        Analyzer analyzer = this.findAnalyzer(context);
        return new AllField(this.names.indexName(), this.store, this.termVector, context.allEntries(), analyzer);
    }

    private Analyzer findAnalyzer(ParseContext context) {
        Analyzer analyzer = this.indexAnalyzer;
        if (analyzer == null && (analyzer = context.analyzer()) == null && (analyzer = context.docMapper().indexAnalyzer()) == null) {
            analyzer = Lucene.STANDARD_ANALYZER;
        }
        return analyzer;
    }

    @Override
    public Void value(Fieldable field) {
        return null;
    }

    @Override
    public Void valueFromString(String value) {
        return null;
    }

    @Override
    public String valueAsString(Fieldable field) {
        return null;
    }

    @Override
    public Object valueForSearch(Fieldable field) {
        return null;
    }

    @Override
    protected String contentType() {
        return "_all";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.enabled && this.store == Defaults.STORE && this.termVector == Defaults.TERM_VECTOR && this.indexAnalyzer == null && this.searchAnalyzer == null) {
            return builder;
        }
        builder.startObject("_all");
        if (!this.enabled) {
            builder.field("enabled", this.enabled);
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (this.indexAnalyzer != null && this.searchAnalyzer != null && this.indexAnalyzer.name().equals(this.searchAnalyzer.name()) && !this.indexAnalyzer.name().startsWith("_")) {
            builder.field("analyzer", this.indexAnalyzer.name());
        } else {
            if (this.indexAnalyzer != null && !this.indexAnalyzer.name().startsWith("_")) {
                builder.field("index_analyzer", this.indexAnalyzer.name());
            }
            if (this.searchAnalyzer != null && !this.searchAnalyzer.name().startsWith("_")) {
                builder.field("search_analyzer", this.searchAnalyzer.name());
            }
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.all();
            TypeParsers.parseField(builder, builder.name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (!fieldName.equals("enabled")) continue;
                builder.enabled(XContentMapValues.nodeBooleanValue(fieldNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends AbstractFieldMapper.Builder<Builder, AllFieldMapper> {
        private boolean enabled = true;

        public Builder() {
            super("_all");
            this.builder = this;
            this.indexName = "_all";
        }

        public Builder enabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        @Override
        public Builder store(Field.Store store) {
            return (Builder)super.store(store);
        }

        @Override
        public Builder termVector(Field.TermVector termVector) {
            return (Builder)super.termVector(termVector);
        }

        @Override
        protected Builder indexAnalyzer(NamedAnalyzer indexAnalyzer) {
            return (Builder)super.indexAnalyzer(indexAnalyzer);
        }

        @Override
        protected Builder searchAnalyzer(NamedAnalyzer searchAnalyzer) {
            return (Builder)super.searchAnalyzer(searchAnalyzer);
        }

        @Override
        public AllFieldMapper build(Mapper.BuilderContext context) {
            return new AllFieldMapper(this.name, this.store, this.termVector, this.omitNorms, this.omitTermFreqAndPositions, this.indexAnalyzer, this.searchAnalyzer, this.enabled);
        }
    }

    public static class Defaults
    extends AbstractFieldMapper.Defaults {
        public static final String NAME = "_all";
        public static final String INDEX_NAME = "_all";
        public static final boolean ENABLED = true;
    }

    public static interface IncludeInAll
    extends Mapper {
        public void includeInAll(Boolean var1);

        public void includeInAllIfNotSet(Boolean var1);
    }
}

