/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.geo;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Field;
import org.elasticsearch.ElasticSearchIllegalArgumentException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.FieldMapperListener;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ObjectMapperListener;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.AbstractFieldMapper;
import org.elasticsearch.index.mapper.core.DoubleFieldMapper;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.StringFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.mapper.geo.GeoPointFieldDataType;
import org.elasticsearch.index.mapper.object.ArrayValueMapperParser;
import org.elasticsearch.index.search.geo.GeoHashUtils;
import org.elasticsearch.index.search.geo.GeoUtils;
import org.elasticsearch.index.search.geo.Point;

public class GeoPointFieldMapper
implements Mapper,
ArrayValueMapperParser {
    public static final String CONTENT_TYPE = "geo_point";
    private final String name;
    private final ContentPath.Type pathType;
    private final boolean enableLatLon;
    private final boolean enableGeoHash;
    private final Integer precisionStep;
    private final int precision;
    private final DoubleFieldMapper latMapper;
    private final DoubleFieldMapper lonMapper;
    private final StringFieldMapper geohashMapper;
    private final GeoStringFieldMapper geoStringMapper;
    private final boolean validateLon;
    private final boolean validateLat;
    private final boolean normalizeLon;
    private final boolean normalizeLat;

    public GeoPointFieldMapper(String name, ContentPath.Type pathType, boolean enableLatLon, boolean enableGeoHash, Integer precisionStep, int precision, DoubleFieldMapper latMapper, DoubleFieldMapper lonMapper, StringFieldMapper geohashMapper, GeoStringFieldMapper geoStringMapper, boolean validateLon, boolean validateLat, boolean normalizeLon, boolean normalizeLat) {
        this.name = name;
        this.pathType = pathType;
        this.enableLatLon = enableLatLon;
        this.enableGeoHash = enableGeoHash;
        this.precisionStep = precisionStep;
        this.precision = precision;
        this.latMapper = latMapper;
        this.lonMapper = lonMapper;
        this.geoStringMapper = geoStringMapper;
        this.geohashMapper = geohashMapper;
        this.geoStringMapper.geoMapper = this;
        this.validateLat = validateLat;
        this.validateLon = validateLon;
        this.normalizeLat = normalizeLat;
        this.normalizeLon = normalizeLon;
    }

    @Override
    public String name() {
        return this.name;
    }

    public DoubleFieldMapper latMapper() {
        return this.latMapper;
    }

    public DoubleFieldMapper lonMapper() {
        return this.lonMapper;
    }

    public boolean isEnableLatLon() {
        return this.enableLatLon;
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        ContentPath.Type origPathType = context.path().pathType();
        context.path().pathType(this.pathType);
        context.path().add(this.name);
        XContentParser.Token token = context.parser().currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            token = context.parser().nextToken();
            if (token == XContentParser.Token.START_ARRAY) {
                while (token != XContentParser.Token.END_ARRAY) {
                    token = context.parser().nextToken();
                    double lon = context.parser().doubleValue();
                    token = context.parser().nextToken();
                    double lat = context.parser().doubleValue();
                    while ((token = context.parser().nextToken()) != XContentParser.Token.END_ARRAY) {
                    }
                    this.parseLatLon(context, lat, lon);
                    token = context.parser().nextToken();
                }
            } else if (token == XContentParser.Token.VALUE_NUMBER) {
                double lon = context.parser().doubleValue();
                token = context.parser().nextToken();
                double lat = context.parser().doubleValue();
                while ((token = context.parser().nextToken()) != XContentParser.Token.END_ARRAY) {
                }
                this.parseLatLon(context, lat, lon);
            } else {
                while (token != XContentParser.Token.END_ARRAY) {
                    if (token == XContentParser.Token.START_OBJECT) {
                        this.parseObjectLatLon(context);
                    } else if (token == XContentParser.Token.VALUE_STRING) {
                        this.parseStringLatLon(context);
                    }
                    token = context.parser().nextToken();
                }
            }
        } else if (token == XContentParser.Token.START_OBJECT) {
            this.parseObjectLatLon(context);
        } else if (token == XContentParser.Token.VALUE_STRING) {
            this.parseStringLatLon(context);
        }
        context.path().remove();
        context.path().pathType(origPathType);
    }

    private void parseStringLatLon(ParseContext context) throws IOException {
        String value = context.parser().text();
        int comma = value.indexOf(44);
        if (comma != -1) {
            double lat = Double.parseDouble(value.substring(0, comma).trim());
            double lon = Double.parseDouble(value.substring(comma + 1).trim());
            this.parseLatLon(context, lat, lon);
        } else {
            this.parseGeohash(context, value);
        }
    }

    private void parseObjectLatLon(ParseContext context) throws IOException {
        XContentParser.Token token;
        String currentName = context.parser().currentName();
        Double lat = null;
        Double lon = null;
        String geohash = null;
        while ((token = context.parser().nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentName = context.parser().currentName();
                continue;
            }
            if (!token.isValue()) continue;
            if (currentName.equals("lat")) {
                lat = context.parser().doubleValue();
                continue;
            }
            if (currentName.equals("lon")) {
                lon = context.parser().doubleValue();
                continue;
            }
            if (!currentName.equals("geohash")) continue;
            geohash = context.parser().text();
        }
        if (geohash != null) {
            this.parseGeohash(context, geohash);
        } else if (lat != null && lon != null) {
            this.parseLatLon(context, lat, lon);
        }
    }

    private void parseLatLon(ParseContext context, double lat, double lon) throws IOException {
        if (this.normalizeLat || this.normalizeLon) {
            Point point = new Point(lat, lon);
            GeoUtils.normalizePoint(point, this.normalizeLat, this.normalizeLon);
            lat = point.lat;
            lon = point.lon;
        }
        if (this.validateLat && (lat > 90.0 || lat < -90.0)) {
            throw new ElasticSearchIllegalArgumentException("illegal latitude value [" + lat + "] for " + this.name);
        }
        if (this.validateLon && (lon > 180.0 || lon < -180.0)) {
            throw new ElasticSearchIllegalArgumentException("illegal longitude value [" + lon + "] for " + this.name);
        }
        context.externalValue(Double.toString(lat) + ',' + Double.toString(lon));
        this.geoStringMapper.parse(context);
        if (this.enableGeoHash) {
            context.externalValue(GeoHashUtils.encode(lat, lon, this.precision));
            this.geohashMapper.parse(context);
        }
        if (this.enableLatLon) {
            context.externalValue(lat);
            this.latMapper.parse(context);
            context.externalValue(lon);
            this.lonMapper.parse(context);
        }
    }

    private void parseGeohash(ParseContext context, String geohash) throws IOException {
        double[] values = GeoHashUtils.decode(geohash);
        double lat = values[0];
        double lon = values[1];
        if (this.normalizeLat || this.normalizeLon) {
            Point point = new Point(lat, lon);
            GeoUtils.normalizePoint(point, this.normalizeLat, this.normalizeLon);
            lat = point.lat;
            lon = point.lon;
        }
        if (this.validateLat && (lat > 90.0 || lat < -90.0)) {
            throw new ElasticSearchIllegalArgumentException("illegal latitude value [" + lat + "] for " + this.name);
        }
        if (this.validateLon && (lon > 180.0 || lon < -180.0)) {
            throw new ElasticSearchIllegalArgumentException("illegal longitude value [" + lon + "] for " + this.name);
        }
        context.externalValue(Double.toString(lat) + ',' + Double.toString(lon));
        this.geoStringMapper.parse(context);
        if (this.enableGeoHash) {
            context.externalValue(geohash);
            this.geohashMapper.parse(context);
        }
        if (this.enableLatLon) {
            context.externalValue(lat);
            this.latMapper.parse(context);
            context.externalValue(lon);
            this.lonMapper.parse(context);
        }
    }

    @Override
    public void close() {
        if (this.latMapper != null) {
            this.latMapper.close();
        }
        if (this.lonMapper != null) {
            this.lonMapper.close();
        }
        if (this.geohashMapper != null) {
            this.geohashMapper.close();
        }
        if (this.geoStringMapper != null) {
            this.geoStringMapper.close();
        }
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
    }

    @Override
    public void traverse(FieldMapperListener fieldMapperListener) {
        this.geoStringMapper.traverse(fieldMapperListener);
        if (this.enableGeoHash) {
            this.geohashMapper.traverse(fieldMapperListener);
        }
        if (this.enableLatLon) {
            this.latMapper.traverse(fieldMapperListener);
            this.lonMapper.traverse(fieldMapperListener);
        }
    }

    @Override
    public void traverse(ObjectMapperListener objectMapperListener) {
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.name);
        builder.field("type", CONTENT_TYPE);
        if (this.pathType != Defaults.PATH_TYPE) {
            builder.field("path", this.pathType.name().toLowerCase());
        }
        if (this.enableLatLon) {
            builder.field("lat_lon", this.enableLatLon);
        }
        if (this.enableGeoHash) {
            builder.field("geohash", this.enableGeoHash);
        }
        if (this.geoStringMapper.store() != Defaults.STORE) {
            builder.field("store", this.geoStringMapper.store().name().toLowerCase());
        }
        if (this.precision != 12) {
            builder.field("geohash_precision", this.precision);
        }
        if (this.precisionStep != null) {
            builder.field("precision_step", this.precisionStep);
        }
        if (!this.validateLat && !this.validateLon) {
            builder.field("validate", false);
        } else {
            if (!this.validateLat) {
                builder.field("validate_lat", this.validateLat);
            }
            if (!this.validateLon) {
                builder.field("validate_lon", this.validateLon);
            }
        }
        if (!this.normalizeLat && !this.normalizeLon) {
            builder.field("normalize", false);
        } else {
            if (!this.normalizeLat) {
                builder.field("normalize_lat", this.normalizeLat);
            }
            if (!this.normalizeLon) {
                builder.field("normalize_lon", this.normalizeLon);
            }
        }
        builder.endObject();
        return builder;
    }

    public static class GeoStringFieldMapper
    extends StringFieldMapper {
        GeoPointFieldMapper geoMapper;

        public GeoStringFieldMapper(FieldMapper.Names names, Field.Index index, Field.Store store, Field.TermVector termVector, float boost, boolean omitNorms, boolean omitTermFreqAndPositions, String nullValue, NamedAnalyzer indexAnalyzer, NamedAnalyzer searchAnalyzer) {
            super(names, index, store, termVector, boost, omitNorms, omitTermFreqAndPositions, nullValue, indexAnalyzer, searchAnalyzer);
        }

        @Override
        public FieldDataType fieldDataType() {
            return GeoPointFieldDataType.TYPE;
        }

        public GeoPointFieldMapper geoMapper() {
            return this.geoMapper;
        }

        public static class Builder
        extends AbstractFieldMapper.OpenBuilder<Builder, StringFieldMapper> {
            protected String nullValue = StringFieldMapper.Defaults.NULL_VALUE;

            public Builder(String name) {
                super(name);
                this.builder = this;
            }

            public Builder nullValue(String nullValue) {
                this.nullValue = nullValue;
                return this;
            }

            @Override
            public Builder includeInAll(Boolean includeInAll) {
                this.includeInAll = includeInAll;
                return this;
            }

            @Override
            public GeoStringFieldMapper build(Mapper.BuilderContext context) {
                GeoStringFieldMapper fieldMapper = new GeoStringFieldMapper(this.buildNames(context), this.index, this.store, this.termVector, this.boost, this.omitNorms, this.omitTermFreqAndPositions, this.nullValue, this.indexAnalyzer, this.searchAnalyzer);
                fieldMapper.includeInAll(this.includeInAll);
                return fieldMapper;
            }
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String fieldName = Strings.toUnderscoreCase(entry.getKey());
                Object fieldNode = entry.getValue();
                if (fieldName.equals("path")) {
                    builder.pathType(TypeParsers.parsePathType(name, fieldNode.toString()));
                    continue;
                }
                if (fieldName.equals("store")) {
                    builder.store(TypeParsers.parseStore(name, fieldNode.toString()));
                    continue;
                }
                if (fieldName.equals("lat_lon")) {
                    builder.enableLatLon(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("geohash")) {
                    builder.enableGeoHash(XContentMapValues.nodeBooleanValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("precision_step")) {
                    builder.precisionStep(XContentMapValues.nodeIntegerValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("geohash_precision")) {
                    builder.precision(XContentMapValues.nodeIntegerValue(fieldNode));
                    continue;
                }
                if (fieldName.equals("validate")) {
                    builder.validateLat = XContentMapValues.nodeBooleanValue(fieldNode);
                    builder.validateLon = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("validate_lon")) {
                    builder.validateLon = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("validate_lat")) {
                    builder.validateLat = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("normalize")) {
                    builder.normalizeLat = XContentMapValues.nodeBooleanValue(fieldNode);
                    builder.normalizeLon = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (fieldName.equals("normalize_lat")) {
                    builder.normalizeLat = XContentMapValues.nodeBooleanValue(fieldNode);
                    continue;
                }
                if (!fieldName.equals("normalize_lon")) continue;
                builder.normalizeLon = XContentMapValues.nodeBooleanValue(fieldNode);
            }
            return builder;
        }
    }

    public static class Builder
    extends Mapper.Builder<Builder, GeoPointFieldMapper> {
        private ContentPath.Type pathType = Defaults.PATH_TYPE;
        private boolean enableGeoHash = false;
        private boolean enableLatLon = false;
        private Integer precisionStep;
        private int precision = 12;
        private Field.Store store = Defaults.STORE;
        boolean validateLat = true;
        boolean validateLon = true;
        boolean normalizeLat = true;
        boolean normalizeLon = true;

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder pathType(ContentPath.Type pathType) {
            this.pathType = pathType;
            return this;
        }

        public Builder enableGeoHash(boolean enableGeoHash) {
            this.enableGeoHash = enableGeoHash;
            return this;
        }

        public Builder enableLatLon(boolean enableLatLon) {
            this.enableLatLon = enableLatLon;
            return this;
        }

        public Builder precisionStep(int precisionStep) {
            this.precisionStep = precisionStep;
            return this;
        }

        public Builder precision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder store(Field.Store store) {
            this.store = store;
            return this;
        }

        @Override
        public GeoPointFieldMapper build(Mapper.BuilderContext context) {
            ContentPath.Type origPathType = context.path().pathType();
            context.path().pathType(this.pathType);
            GeoStringFieldMapper geoStringMapper = ((GeoStringFieldMapper.Builder)((GeoStringFieldMapper.Builder)((GeoStringFieldMapper.Builder)((GeoStringFieldMapper.Builder)new GeoStringFieldMapper.Builder(this.name).index(Field.Index.NOT_ANALYZED)).omitNorms(true)).omitTermFreqAndPositions(true)).includeInAll(false).store(this.store)).build(context);
            DoubleFieldMapper latMapper = null;
            DoubleFieldMapper lonMapper = null;
            context.path().add(this.name);
            if (this.enableLatLon) {
                AbstractFieldMapper.Builder latMapperBuilder = MapperBuilders.doubleField("lat").includeInAll(false);
                AbstractFieldMapper.Builder lonMapperBuilder = MapperBuilders.doubleField("lon").includeInAll(false);
                if (this.precisionStep != null) {
                    ((NumberFieldMapper.Builder)latMapperBuilder).precisionStep(this.precisionStep);
                    ((NumberFieldMapper.Builder)lonMapperBuilder).precisionStep(this.precisionStep);
                }
                latMapper = (DoubleFieldMapper)((NumberFieldMapper.Builder)((NumberFieldMapper.Builder)latMapperBuilder).includeInAll(false)).store(this.store).build(context);
                lonMapper = (DoubleFieldMapper)((NumberFieldMapper.Builder)((NumberFieldMapper.Builder)lonMapperBuilder).includeInAll(false)).store(this.store).build(context);
            }
            StringFieldMapper geohashMapper = null;
            if (this.enableGeoHash) {
                geohashMapper = ((StringFieldMapper.Builder)((StringFieldMapper.Builder)((StringFieldMapper.Builder)MapperBuilders.stringField("geohash").index(Field.Index.NOT_ANALYZED)).includeInAll(false).omitNorms(true)).omitTermFreqAndPositions(true)).build(context);
            }
            context.path().remove();
            context.path().pathType(origPathType);
            return new GeoPointFieldMapper(this.name, this.pathType, this.enableLatLon, this.enableGeoHash, this.precisionStep, this.precision, latMapper, lonMapper, geohashMapper, geoStringMapper, this.validateLon, this.validateLat, this.normalizeLon, this.normalizeLat);
        }
    }

    public static class Defaults {
        public static final ContentPath.Type PATH_TYPE = ContentPath.Type.FULL;
        public static final Field.Store STORE = Field.Store.NO;
        public static final boolean ENABLE_LATLON = false;
        public static final boolean ENABLE_GEOHASH = false;
        public static final int PRECISION = 12;
        public static final boolean NORMALIZE_LAT = true;
        public static final boolean NORMALIZE_LON = true;
        public static final boolean VALIDATE_LAT = true;
        public static final boolean VALIDATE_LON = true;
    }

    public static class Names {
        public static final String LAT = "lat";
        public static final String LAT_SUFFIX = ".lat";
        public static final String LON = "lon";
        public static final String LON_SUFFIX = ".lon";
        public static final String GEOHASH = "geohash";
        public static final String GEOHASH_SUFFIX = ".geohash";
    }
}

