/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper.core;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Numbers;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.analysis.NumericIntegerAnalyzer;
import org.elasticsearch.index.cache.field.data.FieldDataCache;
import org.elasticsearch.index.field.data.FieldDataType;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperBuilders;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.MergeContext;
import org.elasticsearch.index.mapper.MergeMappingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.core.NumberFieldMapper;
import org.elasticsearch.index.mapper.core.TypeParsers;
import org.elasticsearch.index.query.QueryParseContext;
import org.elasticsearch.index.search.NumericRangeFieldDataFilter;

public class ShortFieldMapper
extends NumberFieldMapper<Short> {
    public static final String CONTENT_TYPE = "short";
    private Short nullValue;
    private String nullValueAsString;

    protected ShortFieldMapper(FieldMapper.Names names, int precisionStep, String fuzzyFactor, Field.Index index, Field.Store store, float boost, boolean omitNorms, boolean omitTermFreqAndPositions, Short nullValue) {
        super(names, precisionStep, fuzzyFactor, index, store, boost, omitNorms, omitTermFreqAndPositions, new NamedAnalyzer("_short/" + precisionStep, new NumericIntegerAnalyzer(precisionStep)), new NamedAnalyzer("_short/max", new NumericIntegerAnalyzer(Integer.MAX_VALUE)));
        this.nullValue = nullValue;
        this.nullValueAsString = nullValue == null ? null : nullValue.toString();
    }

    @Override
    protected int maxPrecisionStep() {
        return 32;
    }

    @Override
    public Short value(Fieldable field) {
        byte[] value = field.getBinaryValue();
        if (value == null) {
            return null;
        }
        return Numbers.bytesToShort(value);
    }

    @Override
    public Short valueFromString(String value) {
        return Short.valueOf(value);
    }

    @Override
    public String indexedValue(String value) {
        return NumericUtils.intToPrefixCoded(Short.parseShort(value));
    }

    @Override
    public Query fuzzyQuery(String value, String minSim, int prefixLength, int maxExpansions) {
        short iSim;
        short iValue = Short.parseShort(value);
        try {
            iSim = Short.parseShort(minSim);
        }
        catch (NumberFormatException e) {
            iSim = (short)Float.parseFloat(minSim);
        }
        return NumericRangeQuery.newIntRange(this.names.indexName(), this.precisionStep, iValue - iSim, iValue + iSim, true, true);
    }

    @Override
    public Query fuzzyQuery(String value, double minSim, int prefixLength, int maxExpansions) {
        short iValue = Short.parseShort(value);
        short iSim = (short)(minSim * this.dFuzzyFactor);
        return NumericRangeQuery.newIntRange(this.names.indexName(), this.precisionStep, iValue - iSim, iValue + iSim, true, true);
    }

    @Override
    public Query fieldQuery(String value, @Nullable QueryParseContext context) {
        int iValue = Integer.parseInt(value);
        return NumericRangeQuery.newIntRange(this.names.indexName(), this.precisionStep, iValue, iValue, true, true);
    }

    @Override
    public Query rangeQuery(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeQuery.newIntRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Integer.valueOf(Integer.parseInt(lowerTerm)), upperTerm == null ? null : Integer.valueOf(Integer.parseInt(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter fieldFilter(String value, @Nullable QueryParseContext context) {
        int iValue = Integer.parseInt(value);
        return NumericRangeFilter.newIntRange(this.names.indexName(), this.precisionStep, iValue, iValue, true, true);
    }

    @Override
    public Filter rangeFilter(String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFilter.newIntRange(this.names.indexName(), this.precisionStep, lowerTerm == null ? null : Integer.valueOf(Integer.parseInt(lowerTerm)), upperTerm == null ? null : Integer.valueOf(Integer.parseInt(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter rangeFilter(FieldDataCache fieldDataCache, String lowerTerm, String upperTerm, boolean includeLower, boolean includeUpper, @Nullable QueryParseContext context) {
        return NumericRangeFieldDataFilter.newShortRange(fieldDataCache, this.names.indexName(), lowerTerm == null ? null : Short.valueOf(Short.parseShort(lowerTerm)), upperTerm == null ? null : Short.valueOf(Short.parseShort(upperTerm)), includeLower, includeUpper);
    }

    @Override
    public Filter nullValueFilter() {
        if (this.nullValue == null) {
            return null;
        }
        return NumericRangeFilter.newIntRange(this.names.indexName(), this.precisionStep, this.nullValue.intValue(), this.nullValue.intValue(), true, true);
    }

    @Override
    protected boolean customBoost() {
        return true;
    }

    @Override
    protected Fieldable parseCreateField(ParseContext context) throws IOException {
        short value;
        float boost = this.boost;
        if (context.externalValueSet()) {
            Object externalValue = context.externalValue();
            if (externalValue == null) {
                if (this.nullValue == null) {
                    return null;
                }
                value = this.nullValue;
            } else if (externalValue instanceof String) {
                String sExternalValue = (String)externalValue;
                if (sExternalValue.length() == 0) {
                    if (this.nullValue == null) {
                        return null;
                    }
                    value = this.nullValue;
                } else {
                    value = Short.parseShort(sExternalValue);
                }
            } else {
                value = ((Number)externalValue).shortValue();
            }
            if (context.includeInAll(this.includeInAll, this)) {
                context.allEntries().addText(this.names.fullName(), Short.toString(value), boost);
            }
        } else {
            XContentParser parser = context.parser();
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL || parser.currentToken() == XContentParser.Token.VALUE_STRING && parser.textLength() == 0) {
                if (this.nullValue == null) {
                    return null;
                }
                value = this.nullValue;
                if (this.nullValueAsString != null && context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.names.fullName(), this.nullValueAsString, boost);
                }
            } else if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                XContentParser.Token token;
                String currentFieldName = null;
                Short objValue = this.nullValue;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        currentFieldName = parser.currentName();
                        continue;
                    }
                    if ("value".equals(currentFieldName) || "_value".equals(currentFieldName)) {
                        if (parser.currentToken() == XContentParser.Token.VALUE_NULL) continue;
                        objValue = parser.shortValue();
                        continue;
                    }
                    if (!"boost".equals(currentFieldName) && !"_boost".equals(currentFieldName)) continue;
                    boost = parser.floatValue();
                }
                if (objValue == null) {
                    return null;
                }
                value = objValue;
            } else {
                value = parser.shortValue();
                if (context.includeInAll(this.includeInAll, this)) {
                    context.allEntries().addText(this.names.fullName(), parser.text(), boost);
                }
            }
        }
        CustomShortNumericField field = new CustomShortNumericField((NumberFieldMapper)this, value);
        field.setBoost(boost);
        return field;
    }

    @Override
    public FieldDataType fieldDataType() {
        return FieldDataType.DefaultTypes.SHORT;
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    public void merge(Mapper mergeWith, MergeContext mergeContext) throws MergeMappingException {
        super.merge(mergeWith, mergeContext);
        if (!this.getClass().equals(mergeWith.getClass())) {
            return;
        }
        if (!mergeContext.mergeFlags().simulate()) {
            this.nullValue = ((ShortFieldMapper)mergeWith).nullValue;
            this.nullValueAsString = ((ShortFieldMapper)mergeWith).nullValueAsString;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder) throws IOException {
        super.doXContentBody(builder);
        if (this.index != Defaults.INDEX) {
            builder.field("index", this.index.name().toLowerCase());
        }
        if (this.store != Defaults.STORE) {
            builder.field("store", this.store.name().toLowerCase());
        }
        if (this.termVector != Defaults.TERM_VECTOR) {
            builder.field("term_vector", this.termVector.name().toLowerCase());
        }
        if (!this.omitNorms) {
            builder.field("omit_norms", this.omitNorms);
        }
        if (!this.omitTermFreqAndPositions) {
            builder.field("omit_term_freq_and_positions", this.omitTermFreqAndPositions);
        }
        if (this.precisionStep != 4) {
            builder.field("precision_step", this.precisionStep);
        }
        if (this.fuzzyFactor != Defaults.FUZZY_FACTOR) {
            builder.field("fuzzy_factor", this.fuzzyFactor);
        }
        if (this.nullValue != null) {
            builder.field("null_value", (Object)this.nullValue);
        }
        if (this.includeInAll != null) {
            builder.field("include_in_all", (Object)this.includeInAll);
        }
    }

    public static class CustomShortNumericField
    extends NumberFieldMapper.CustomNumericField {
        private final short number;
        private final NumberFieldMapper mapper;

        public CustomShortNumericField(NumberFieldMapper mapper, short number) {
            super(mapper, mapper.stored() ? Numbers.shortToBytes(number) : null);
            this.mapper = mapper;
            this.number = number;
        }

        @Override
        public TokenStream tokenStreamValue() {
            if (this.isIndexed) {
                return this.mapper.popCachedStream().setIntValue(this.number);
            }
            return null;
        }

        @Override
        public String numericAsString() {
            return Short.toString(this.number);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        @Override
        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = MapperBuilders.shortField(name);
            TypeParsers.parseNumberField(builder, name, node, parserContext);
            for (Map.Entry<String, Object> entry : node.entrySet()) {
                String propName = Strings.toUnderscoreCase(entry.getKey());
                Object propNode = entry.getValue();
                if (!propName.equals("null_value")) continue;
                builder.nullValue(XContentMapValues.nodeShortValue(propNode));
            }
            return builder;
        }
    }

    public static class Builder
    extends NumberFieldMapper.Builder<Builder, ShortFieldMapper> {
        protected Short nullValue = Defaults.NULL_VALUE;

        public Builder(String name) {
            super(name);
            this.builder = this;
        }

        public Builder nullValue(short nullValue) {
            this.nullValue = nullValue;
            return this;
        }

        @Override
        public ShortFieldMapper build(Mapper.BuilderContext context) {
            ShortFieldMapper fieldMapper = new ShortFieldMapper(this.buildNames(context), this.precisionStep, this.fuzzyFactor, this.index, this.store, this.boost, this.omitNorms, this.omitTermFreqAndPositions, this.nullValue);
            fieldMapper.includeInAll(this.includeInAll);
            return fieldMapper;
        }
    }

    public static class Defaults
    extends NumberFieldMapper.Defaults {
        public static final Short NULL_VALUE = null;
    }
}

