/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway.shared;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticSearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.common.StopWatch;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.gateway.Gateway;
import org.elasticsearch.gateway.GatewayException;
import org.elasticsearch.index.Index;
import org.elasticsearch.threadpool.ThreadPool;

public abstract class SharedStorageGateway
extends AbstractLifecycleComponent<Gateway>
implements Gateway,
ClusterStateListener {
    private final ClusterService clusterService;
    private final ThreadPool threadPool;
    private ExecutorService writeStateExecutor;
    private volatile MetaData currentMetaData;
    private NodeEnvironment nodeEnv;

    public SharedStorageGateway(Settings settings, ThreadPool threadPool, ClusterService clusterService) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.writeStateExecutor = Executors.newSingleThreadExecutor(EsExecutors.daemonThreadFactory(settings, "gateway#writeMetaData"));
        clusterService.addLast(this);
    }

    @Inject
    public void setNodeEnv(NodeEnvironment nodeEnv) {
        this.nodeEnv = nodeEnv;
    }

    @Override
    protected void doStart() throws ElasticSearchException {
    }

    @Override
    protected void doStop() throws ElasticSearchException {
    }

    @Override
    protected void doClose() throws ElasticSearchException {
        this.clusterService.remove(this);
        this.writeStateExecutor.shutdown();
        try {
            this.writeStateExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void performStateRecovery(final Gateway.GatewayStateRecoveredListener listener) throws GatewayException {
        this.threadPool.generic().execute(new Runnable(){

            @Override
            public void run() {
                SharedStorageGateway.this.logger.debug("reading state from gateway {} ...", this);
                StopWatch stopWatch = new StopWatch().start();
                try {
                    MetaData metaData = SharedStorageGateway.this.read();
                    SharedStorageGateway.this.logger.debug("read state from gateway {}, took {}", this, stopWatch.stop().totalTime());
                    if (metaData == null) {
                        SharedStorageGateway.this.logger.debug("no state read from gateway", new Object[0]);
                        listener.onSuccess(ClusterState.builder().build());
                    } else {
                        listener.onSuccess(ClusterState.builder().metaData(metaData).build());
                    }
                }
                catch (Exception e) {
                    SharedStorageGateway.this.logger.error("failed to read from gateway", e, new Object[0]);
                    listener.onFailure(ExceptionsHelper.detailedMessage(e));
                }
            }
        });
    }

    @Override
    public void clusterChanged(final ClusterChangedEvent event) {
        if (!this.lifecycle.started()) {
            return;
        }
        if (event.state().blocks().disableStatePersistence()) {
            this.currentMetaData = null;
            return;
        }
        if (!event.metaDataChanged()) {
            return;
        }
        this.writeStateExecutor.execute(new Runnable(){

            @Override
            public void run() {
                if (event.localNodeMaster()) {
                    SharedStorageGateway.this.logger.debug("writing to gateway {} ...", this);
                    StopWatch stopWatch = new StopWatch().start();
                    try {
                        SharedStorageGateway.this.write(event.state().metaData());
                        SharedStorageGateway.this.logger.debug("wrote to gateway {}, took {}", this, stopWatch.stop().totalTime());
                    }
                    catch (Exception e) {
                        SharedStorageGateway.this.logger.error("failed to write to gateway", e, new Object[0]);
                    }
                    if (SharedStorageGateway.this.currentMetaData != null) {
                        for (IndexMetaData current : SharedStorageGateway.this.currentMetaData) {
                            if (event.state().metaData().hasIndex(current.index())) continue;
                            SharedStorageGateway.this.delete(current);
                        }
                    }
                }
                if (SharedStorageGateway.this.nodeEnv != null && SharedStorageGateway.this.nodeEnv.hasNodeFile() && SharedStorageGateway.this.currentMetaData != null) {
                    for (IndexMetaData current : SharedStorageGateway.this.currentMetaData) {
                        if (event.state().metaData().hasIndex(current.index())) continue;
                        FileSystemUtils.deleteRecursively(SharedStorageGateway.this.nodeEnv.indexLocations(new Index(current.index())));
                    }
                }
                SharedStorageGateway.this.currentMetaData = event.state().metaData();
            }
        });
    }

    protected abstract MetaData read() throws ElasticSearchException;

    protected abstract void write(MetaData var1) throws ElasticSearchException;

    protected abstract void delete(IndexMetaData var1) throws ElasticSearchException;
}

