/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.netty.util.internal;

import java.util.Collection;
import java.util.concurrent.BlockingQueue;
import org.elasticsearch.common.netty.logging.InternalLogger;
import org.elasticsearch.common.netty.logging.InternalLoggerFactory;
import org.elasticsearch.common.netty.util.internal.DetectionUtil;
import org.elasticsearch.common.netty.util.internal.LegacyLinkedTransferQueue;
import org.elasticsearch.common.netty.util.internal.LinkedTransferQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class QueueFactory {
    private static final boolean useUnsafe = DetectionUtil.hasUnsafe();
    private static final InternalLogger LOGGER = InternalLoggerFactory.getInstance(QueueFactory.class);

    private QueueFactory() {
    }

    public static <T> BlockingQueue<T> createQueue(Class<T> itemClass) {
        block4: {
            if (DetectionUtil.javaVersion() >= 7) {
                return new java.util.concurrent.LinkedTransferQueue();
            }
            try {
                if (useUnsafe) {
                    return new LinkedTransferQueue();
                }
            }
            catch (Throwable t) {
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug("Unable to instance LinkedTransferQueue, fallback to LegacyLinkedTransferQueue", t);
            }
        }
        return new LegacyLinkedTransferQueue();
    }

    public static <T> BlockingQueue<T> createQueue(Collection<? extends T> collection, Class<T> itemClass) {
        block4: {
            if (DetectionUtil.javaVersion() >= 7) {
                return new java.util.concurrent.LinkedTransferQueue();
            }
            try {
                if (useUnsafe) {
                    return new LinkedTransferQueue<T>(collection);
                }
            }
            catch (Throwable t) {
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug("Unable to instance LinkedTransferQueue, fallback to LegacyLinkedTransferQueue", t);
            }
        }
        return new LegacyLinkedTransferQueue<T>(collection);
    }
}

