/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search.function;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.ToStringUtils;
import org.elasticsearch.common.lucene.docset.DocSet;
import org.elasticsearch.common.lucene.docset.DocSets;
import org.elasticsearch.common.lucene.search.function.ScoreFunction;

public class FiltersFunctionScoreQuery
extends Query {
    Query subQuery;
    final FilterFunction[] filterFunctions;
    final ScoreMode scoreMode;
    final float maxBoost;
    DocSet[] docSets;

    public FiltersFunctionScoreQuery(Query subQuery, ScoreMode scoreMode, FilterFunction[] filterFunctions, float maxBoost) {
        this.subQuery = subQuery;
        this.scoreMode = scoreMode;
        this.filterFunctions = filterFunctions;
        this.docSets = new DocSet[filterFunctions.length];
        this.maxBoost = maxBoost;
    }

    public Query getSubQuery() {
        return this.subQuery;
    }

    public FilterFunction[] getFilterFunctions() {
        return this.filterFunctions;
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query newQ = this.subQuery.rewrite(reader);
        if (newQ == this.subQuery) {
            return this;
        }
        FiltersFunctionScoreQuery bq = (FiltersFunctionScoreQuery)this.clone();
        bq.subQuery = newQ;
        return bq;
    }

    @Override
    public void extractTerms(Set<Term> terms) {
        this.subQuery.extractTerms(terms);
    }

    @Override
    public Weight createWeight(Searcher searcher) throws IOException {
        return new CustomBoostFactorWeight(searcher);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append("custom score (").append(this.subQuery.toString(field)).append(", functions: [");
        for (FilterFunction filterFunction : this.filterFunctions) {
            sb.append("{filter(").append(filterFunction.filter).append("), function [").append(filterFunction.function).append("]}");
        }
        sb.append("])");
        sb.append(ToStringUtils.boost(this.getBoost()));
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this.getClass() != o.getClass()) {
            return false;
        }
        FiltersFunctionScoreQuery other = (FiltersFunctionScoreQuery)o;
        if (this.getBoost() != other.getBoost()) {
            return false;
        }
        if (!this.subQuery.equals(other.subQuery)) {
            return false;
        }
        return Arrays.equals(this.filterFunctions, other.filterFunctions);
    }

    @Override
    public int hashCode() {
        return this.subQuery.hashCode() + 31 * Arrays.hashCode(this.filterFunctions) ^ Float.floatToIntBits(this.getBoost());
    }

    static class CustomBoostFactorScorer
    extends Scorer {
        private final float subQueryWeight;
        private final Scorer scorer;
        private final FilterFunction[] filterFunctions;
        private final ScoreMode scoreMode;
        private final float maxBoost;
        private final DocSet[] docSets;

        private CustomBoostFactorScorer(Similarity similarity, CustomBoostFactorWeight w, Scorer scorer, ScoreMode scoreMode, FilterFunction[] filterFunctions, float maxBoost, DocSet[] docSets) throws IOException {
            super(similarity);
            this.subQueryWeight = w.getValue();
            this.scorer = scorer;
            this.scoreMode = scoreMode;
            this.filterFunctions = filterFunctions;
            this.maxBoost = maxBoost;
            this.docSets = docSets;
        }

        @Override
        public int docID() {
            return this.scorer.docID();
        }

        @Override
        public int advance(int target) throws IOException {
            return this.scorer.advance(target);
        }

        @Override
        public int nextDoc() throws IOException {
            return this.scorer.nextDoc();
        }

        @Override
        public float score() throws IOException {
            int docId = this.scorer.docID();
            float factor = 1.0f;
            if (this.scoreMode == ScoreMode.First) {
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    factor = this.filterFunctions[i].function.factor(docId);
                    break;
                }
            } else if (this.scoreMode == ScoreMode.Max) {
                float maxFactor = Float.NEGATIVE_INFINITY;
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    maxFactor = Math.max(this.filterFunctions[i].function.factor(docId), maxFactor);
                }
                if (maxFactor != Float.NEGATIVE_INFINITY) {
                    factor = maxFactor;
                }
            } else if (this.scoreMode == ScoreMode.Min) {
                float minFactor = Float.POSITIVE_INFINITY;
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    minFactor = Math.min(this.filterFunctions[i].function.factor(docId), minFactor);
                }
                if (minFactor != Float.POSITIVE_INFINITY) {
                    factor = minFactor;
                }
            } else if (this.scoreMode == ScoreMode.Multiply) {
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    factor *= this.filterFunctions[i].function.factor(docId);
                }
            } else {
                float totalFactor = 0.0f;
                int count = 0;
                for (int i = 0; i < this.filterFunctions.length; ++i) {
                    if (!this.docSets[i].get(docId)) continue;
                    totalFactor += this.filterFunctions[i].function.factor(docId);
                    ++count;
                }
                if (count != 0) {
                    factor = totalFactor;
                    if (this.scoreMode == ScoreMode.Avg) {
                        factor /= (float)count;
                    }
                }
            }
            if (factor > this.maxBoost) {
                factor = this.maxBoost;
            }
            float score = this.scorer.score();
            return this.subQueryWeight * score * factor;
        }
    }

    class CustomBoostFactorWeight
    extends Weight {
        Searcher searcher;
        Weight subQueryWeight;

        public CustomBoostFactorWeight(Searcher searcher) throws IOException {
            this.searcher = searcher;
            this.subQueryWeight = FiltersFunctionScoreQuery.this.subQuery.weight(searcher);
        }

        @Override
        public Query getQuery() {
            return FiltersFunctionScoreQuery.this;
        }

        @Override
        public float getValue() {
            return FiltersFunctionScoreQuery.this.getBoost();
        }

        @Override
        public float sumOfSquaredWeights() throws IOException {
            float sum = this.subQueryWeight.sumOfSquaredWeights();
            return sum *= FiltersFunctionScoreQuery.this.getBoost() * FiltersFunctionScoreQuery.this.getBoost();
        }

        @Override
        public void normalize(float norm) {
            this.subQueryWeight.normalize(norm *= FiltersFunctionScoreQuery.this.getBoost());
        }

        @Override
        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            Scorer subQueryScorer = this.subQueryWeight.scorer(reader, scoreDocsInOrder, false);
            if (subQueryScorer == null) {
                return null;
            }
            for (int i = 0; i < FiltersFunctionScoreQuery.this.filterFunctions.length; ++i) {
                FilterFunction filterFunction = FiltersFunctionScoreQuery.this.filterFunctions[i];
                filterFunction.function.setNextReader(reader);
                FiltersFunctionScoreQuery.this.docSets[i] = DocSets.convert(reader, filterFunction.filter.getDocIdSet(reader));
            }
            return new CustomBoostFactorScorer(FiltersFunctionScoreQuery.this.getSimilarity(this.searcher), this, subQueryScorer, FiltersFunctionScoreQuery.this.scoreMode, FiltersFunctionScoreQuery.this.filterFunctions, FiltersFunctionScoreQuery.this.maxBoost, FiltersFunctionScoreQuery.this.docSets);
        }

        @Override
        public Explanation explain(IndexReader reader, int doc) throws IOException {
            Explanation subQueryExpl = this.subQueryWeight.explain(reader, doc);
            if (!subQueryExpl.isMatch()) {
                return subQueryExpl;
            }
            if (FiltersFunctionScoreQuery.this.scoreMode == ScoreMode.First) {
                for (FilterFunction filterFunction : FiltersFunctionScoreQuery.this.filterFunctions) {
                    DocSet docSet = DocSets.convert(reader, filterFunction.filter.getDocIdSet(reader));
                    if (!docSet.get(doc)) continue;
                    filterFunction.function.setNextReader(reader);
                    Explanation functionExplanation = filterFunction.function.explainFactor(doc);
                    float sc = this.getValue() * subQueryExpl.getValue() * functionExplanation.getValue();
                    ComplexExplanation res = new ComplexExplanation(true, sc, "custom score, product of:");
                    res.addDetail(new Explanation(1.0f, "match filter: " + filterFunction.filter.toString()));
                    res.addDetail(functionExplanation);
                    res.addDetail(new Explanation(this.getValue(), "queryBoost"));
                    return res;
                }
            } else {
                int count = 0;
                float total = 0.0f;
                float multiply = 1.0f;
                float max = Float.NEGATIVE_INFINITY;
                float min = Float.POSITIVE_INFINITY;
                ArrayList<ComplexExplanation> filtersExplanations = new ArrayList<ComplexExplanation>();
                for (FilterFunction filterFunction : FiltersFunctionScoreQuery.this.filterFunctions) {
                    DocSet docSet = DocSets.convert(reader, filterFunction.filter.getDocIdSet(reader));
                    if (!docSet.get(doc)) continue;
                    filterFunction.function.setNextReader(reader);
                    Explanation functionExplanation = filterFunction.function.explainFactor(doc);
                    float factor = functionExplanation.getValue();
                    ++count;
                    total += factor;
                    multiply *= factor;
                    max = Math.max(factor, max);
                    min = Math.min(factor, min);
                    ComplexExplanation res = new ComplexExplanation(true, factor, "custom score, product of:");
                    res.addDetail(new Explanation(1.0f, "match filter: " + filterFunction.filter.toString()));
                    res.addDetail(functionExplanation);
                    res.addDetail(new Explanation(this.getValue(), "queryBoost"));
                    filtersExplanations.add(res);
                }
                if (count > 0) {
                    float factor = 0.0f;
                    switch (FiltersFunctionScoreQuery.this.scoreMode) {
                        case Avg: {
                            factor = total / (float)count;
                            break;
                        }
                        case Max: {
                            factor = max;
                            break;
                        }
                        case Min: {
                            factor = min;
                            break;
                        }
                        case Total: {
                            factor = total;
                            break;
                        }
                        case Multiply: {
                            factor = multiply;
                        }
                    }
                    if (factor > FiltersFunctionScoreQuery.this.maxBoost) {
                        factor = FiltersFunctionScoreQuery.this.maxBoost;
                    }
                    float sc = factor * subQueryExpl.getValue() * this.getValue();
                    ComplexExplanation res = new ComplexExplanation(true, sc, "custom score, score mode [" + FiltersFunctionScoreQuery.this.scoreMode.toString().toLowerCase() + "]");
                    res.addDetail(subQueryExpl);
                    for (Explanation explanation : filtersExplanations) {
                        res.addDetail(explanation);
                    }
                    return res;
                }
            }
            float sc = this.getValue() * subQueryExpl.getValue();
            ComplexExplanation res = new ComplexExplanation(true, sc, "custom score, no filter match, product of:");
            res.addDetail(subQueryExpl);
            res.addDetail(new Explanation(this.getValue(), "queryBoost"));
            return res;
        }
    }

    public static enum ScoreMode {
        First,
        Avg,
        Max,
        Total,
        Min,
        Multiply;

    }

    public static class FilterFunction {
        public final Filter filter;
        public final ScoreFunction function;

        public FilterFunction(Filter filter, ScoreFunction function) {
            this.filter = filter;
            this.function = function;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterFunction that = (FilterFunction)o;
            if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
                return false;
            }
            return !(this.function != null ? !this.function.equals(that.function) : that.function != null);
        }

        public int hashCode() {
            int result = this.filter != null ? this.filter.hashCode() : 0;
            result = 31 * result + (this.function != null ? this.function.hashCode() : 0);
            return result;
        }
    }
}

