/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexOutput;
import org.elasticsearch.common.trove.iterator.TLongIterator;
import org.elasticsearch.common.trove.list.array.TLongArrayList;

public abstract class CompressedIndexOutput
extends IndexOutput {
    final IndexOutput out;
    protected byte[] uncompressed;
    private int position = 0;
    private long uncompressedPosition;
    private boolean closed;
    private final long metaDataPointer;
    private TLongArrayList offsets = new TLongArrayList();

    public CompressedIndexOutput(IndexOutput out) throws IOException {
        this.out = out;
        this.writeHeader(out);
        out.writeInt(0);
        this.metaDataPointer = out.getFilePointer();
        out.writeLong(-1L);
    }

    public IndexOutput underlying() {
        return this.out;
    }

    @Override
    public void writeByte(byte b) throws IOException {
        if (this.position >= this.uncompressed.length) {
            this.flushBuffer();
        }
        ++this.uncompressedPosition;
        this.uncompressed[this.position++] = b;
    }

    @Override
    public void writeBytes(byte[] input, int offset, int length) throws IOException {
        if (length == 0) {
            return;
        }
        int BUFFER_LEN = this.uncompressed.length;
        int free = BUFFER_LEN - this.position;
        if (free >= length) {
            System.arraycopy(input, offset, this.uncompressed, this.position, length);
            this.position += length;
            this.uncompressedPosition += (long)length;
            return;
        }
        if (this.position > 0) {
            System.arraycopy(input, offset, this.uncompressed, this.position, free);
            this.position += free;
            this.uncompressedPosition += (long)free;
            this.flushBuffer();
            offset += free;
            length -= free;
        }
        while (length >= BUFFER_LEN) {
            this.offsets.add(this.out.getFilePointer());
            this.compress(input, offset, BUFFER_LEN, this.out);
            offset += BUFFER_LEN;
            length -= BUFFER_LEN;
            this.uncompressedPosition += (long)BUFFER_LEN;
        }
        if (length > 0) {
            System.arraycopy(input, offset, this.uncompressed, 0, length);
        }
        this.position = length;
        this.uncompressedPosition += (long)length;
    }

    @Override
    public void copyBytes(DataInput input, long length) throws IOException {
        int BUFFER_LEN = this.uncompressed.length;
        int free = BUFFER_LEN - this.position;
        if ((long)free >= length) {
            input.readBytes(this.uncompressed, this.position, (int)length, false);
            this.position = (int)((long)this.position + length);
            this.uncompressedPosition += length;
            return;
        }
        if (this.position > 0) {
            input.readBytes(this.uncompressed, this.position, free, false);
            this.position += free;
            this.uncompressedPosition += (long)free;
            this.flushBuffer();
            length -= (long)free;
        }
        while (length >= (long)BUFFER_LEN) {
            this.offsets.add(this.out.getFilePointer());
            input.readBytes(this.uncompressed, 0, BUFFER_LEN);
            this.compress(this.uncompressed, 0, BUFFER_LEN, this.out);
            length -= (long)BUFFER_LEN;
            this.uncompressedPosition += (long)BUFFER_LEN;
        }
        if (length > 0L) {
            input.readBytes(this.uncompressed, 0, (int)length, false);
        }
        this.position = (int)length;
        this.uncompressedPosition += length;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.flushBuffer();
            long metaDataPointerValue = this.out.getFilePointer();
            this.out.writeVLong(this.uncompressedPosition);
            this.out.writeVInt(this.offsets.size());
            TLongIterator it = this.offsets.iterator();
            while (it.hasNext()) {
                this.out.writeVLong(it.next());
            }
            this.out.seek(this.metaDataPointer);
            this.out.writeLong(metaDataPointerValue);
            this.closed = true;
            this.doClose();
            this.out.close();
        }
    }

    protected abstract void doClose() throws IOException;

    @Override
    public long getFilePointer() {
        return this.uncompressedPosition;
    }

    @Override
    public void seek(long pos) throws IOException {
        throw new IOException("seek not supported on compressed output");
    }

    @Override
    public long length() throws IOException {
        return this.uncompressedPosition;
    }

    private void flushBuffer() throws IOException {
        if (this.position > 0) {
            this.offsets.add(this.out.getFilePointer());
            this.compress(this.uncompressed, 0, this.position, this.out);
            this.position = 0;
        }
    }

    protected abstract void writeHeader(IndexOutput var1) throws IOException;

    protected abstract void compress(byte[] var1, int var2, int var3, IndexOutput var4) throws IOException;
}

