/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.compress;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.index.store.support.ForceSyncDirectory;

public class CompressedDirectory
extends Directory
implements ForceSyncDirectory {
    private final Directory dir;
    private final Compressor compressor;
    private final boolean actualLength;
    private final ImmutableSet<String> compressExtensions;
    private final ImmutableSet<String> decompressExtensions;
    private volatile boolean compress = true;

    public CompressedDirectory(Directory dir, Compressor compressor, boolean actualLength, String ... extensions) {
        this(dir, compressor, actualLength, extensions, extensions);
    }

    public CompressedDirectory(Directory dir, Compressor compressor, boolean actualLength, String[] compressExtensions, String[] decompressExtensions) {
        this.dir = dir;
        this.actualLength = actualLength;
        this.compressor = compressor;
        this.compressExtensions = ImmutableSet.copyOf(compressExtensions);
        this.decompressExtensions = ImmutableSet.copyOf(decompressExtensions);
        this.lockFactory = dir.getLockFactory();
    }

    @Override
    public String[] listAll() throws IOException {
        return this.dir.listAll();
    }

    public void setCompress(boolean compress) {
        this.compress = compress;
    }

    public static String getExtension(String name) {
        int i = name.lastIndexOf(46);
        if (i == -1) {
            return "";
        }
        return name.substring(i + 1, name.length());
    }

    @Override
    public boolean fileExists(String name) throws IOException {
        return this.dir.fileExists(name);
    }

    @Override
    public long fileModified(String name) throws IOException {
        return this.dir.fileModified(name);
    }

    @Override
    public void touchFile(String name) throws IOException {
        this.dir.touchFile(name);
    }

    @Override
    public void deleteFile(String name) throws IOException {
        this.dir.deleteFile(name);
    }

    @Override
    public long fileLength(String name) throws IOException {
        if (this.actualLength && this.decompressExtensions.contains(CompressedDirectory.getExtension(name))) {
            IndexInput in = this.openInput(name);
            try {
                return in.length();
            }
            catch (Exception e) {
                in.close();
            }
        }
        return this.dir.fileLength(name);
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.dir.sync(names);
    }

    @Override
    public void sync(String name) throws IOException {
        this.dir.sync(name);
    }

    @Override
    public void forceSync(String name) throws IOException {
        if (this.dir instanceof ForceSyncDirectory) {
            ((ForceSyncDirectory)((Object)this.dir)).forceSync(name);
        } else {
            this.dir.sync(name);
        }
    }

    @Override
    public IndexInput openInput(String name) throws IOException {
        if (this.decompressExtensions.contains(CompressedDirectory.getExtension(name))) {
            IndexInput in = this.dir.openInput(name);
            Compressor compressor1 = CompressorFactory.compressor(in);
            if (compressor1 != null) {
                return compressor1.indexInput(in);
            }
            return in;
        }
        return this.dir.openInput(name);
    }

    @Override
    public IndexInput openInput(String name, int bufferSize) throws IOException {
        if (this.decompressExtensions.contains(CompressedDirectory.getExtension(name))) {
            IndexInput in = this.dir.openInput(name, bufferSize);
            Compressor compressor1 = CompressorFactory.compressor(in);
            if (compressor1 != null) {
                return compressor1.indexInput(in);
            }
            return in;
        }
        return this.dir.openInput(name, bufferSize);
    }

    @Override
    public IndexOutput createOutput(String name) throws IOException {
        if (this.compress && this.compressExtensions.contains(CompressedDirectory.getExtension(name))) {
            return this.compressor.indexOutput(this.dir.createOutput(name));
        }
        return this.dir.createOutput(name);
    }

    @Override
    public void close() throws IOException {
        this.dir.close();
    }

    @Override
    public void setLockFactory(LockFactory lockFactory) throws IOException {
        this.dir.setLockFactory(lockFactory);
    }

    @Override
    public LockFactory getLockFactory() {
        return this.dir.getLockFactory();
    }

    @Override
    public String getLockID() {
        return this.dir.getLockID();
    }

    @Override
    public Lock makeLock(String name) {
        return this.dir.makeLock(name);
    }

    @Override
    public void clearLock(String name) throws IOException {
        this.dir.clearLock(name);
    }

    @Override
    public String toString() {
        return "compressed(" + this.compressExtensions + "):" + this.dir.toString();
    }
}

