/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation.decider;

import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodeFilters;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.AllocationDecider;
import org.elasticsearch.common.collect.ImmutableMap;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.node.settings.NodeSettingsService;

public class FilterAllocationDecider
extends AllocationDecider {
    private volatile DiscoveryNodeFilters clusterIncludeFilters;
    private volatile DiscoveryNodeFilters clusterExcludeFilters;

    @Inject
    public FilterAllocationDecider(Settings settings, NodeSettingsService nodeSettingsService) {
        super(settings);
        ImmutableMap<String, String> includeMap = settings.getByPrefix("cluster.routing.allocation.include.").getAsMap();
        this.clusterIncludeFilters = includeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(includeMap);
        ImmutableMap<String, String> excludeMap = settings.getByPrefix("cluster.routing.allocation.exclude.").getAsMap();
        this.clusterExcludeFilters = excludeMap.isEmpty() ? null : DiscoveryNodeFilters.buildFromKeyValue(excludeMap);
        nodeSettingsService.addListener(new ApplySettings());
    }

    @Override
    public AllocationDecider.Decision canAllocate(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return this.shouldFilter(shardRouting, node, allocation) ? AllocationDecider.Decision.NO : AllocationDecider.Decision.YES;
    }

    @Override
    public boolean canRemain(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        return !this.shouldFilter(shardRouting, node, allocation);
    }

    private boolean shouldFilter(ShardRouting shardRouting, RoutingNode node, RoutingAllocation allocation) {
        if (this.clusterIncludeFilters != null && !this.clusterIncludeFilters.match(node.node())) {
            return true;
        }
        if (this.clusterExcludeFilters != null && this.clusterExcludeFilters.match(node.node())) {
            return true;
        }
        IndexMetaData indexMd = allocation.routingNodes().metaData().index(shardRouting.index());
        if (indexMd.includeFilters() != null && !indexMd.includeFilters().match(node.node())) {
            return true;
        }
        return indexMd.excludeFilters() != null && indexMd.excludeFilters().match(node.node());
    }

    static {
        MetaData.addDynamicSettings("cluster.routing.allocation.include.*", "cluster.routing.allocation.exclude.*");
        IndexMetaData.addDynamicSettings("index.routing.allocation.include.*", "index.routing.allocation.exclude.*");
    }

    class ApplySettings
    implements NodeSettingsService.Listener {
        ApplySettings() {
        }

        @Override
        public void onRefreshSettings(Settings settings) {
            ImmutableMap<String, String> excludeMap;
            ImmutableMap<String, String> includeMap = settings.getByPrefix("cluster.routing.allocation.include.").getAsMap();
            if (!includeMap.isEmpty()) {
                FilterAllocationDecider.this.clusterIncludeFilters = DiscoveryNodeFilters.buildFromKeyValue(includeMap);
            }
            if (!(excludeMap = settings.getByPrefix("cluster.routing.allocation.exclude.").getAsMap()).isEmpty()) {
                FilterAllocationDecider.this.clusterExcludeFilters = DiscoveryNodeFilters.buildFromKeyValue(excludeMap);
            }
        }
    }
}

